/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.definition.controller;

import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.constant.BpmEnum;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.response.ApiResponse;
import java.util.Map;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processDefinition"})
public class ProcessDefinitionsController
extends BaseController {
    @Autowired
    ProcessDefinitionsService processDefinitionsService;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;

    @RequestMapping(value={"/queryProcessDefinitionsList"})
    @ManageBusinessLog(key="/processDefinition/queryProcessDefinitionsList", value="\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", type="\u67e5\u8be2")
    public ApiResponse<Map<String, Object>> queryProcessDefinitionsList(@RequestParam(value="definitionKey", required=false) String definitionKey, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        Map map = this.processDefinitionsService.queryProcessDefinitionsList(definitionKey, page, limit);
        return ApiResponse.data((Object)map);
    }

    @RequestMapping(value={"/setMain"})
    @ManageBusinessLog(key="/processDefinition/setMain", value="\u8bbe\u7f6e\u4e3b\u7248\u672c", type="\u4fee\u6539")
    public ApiResponse<?> setMain(String processDefKey, String id) {
        int num = this.processDefinitionsService.setMain(processDefKey, id);
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processDefKey, id, BaseShiroKit.getUser().getTenantId())) {
                return ApiResponse.success((int)BpmEnum.SET_SUCCESS.getCode(), (String)BpmEnum.SET_SUCCESS.getMessage());
            }
            return ApiResponse.fail((int)BpmEnum.FILES_NOT_FOUND.getCode(), (String)BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        return ApiResponse.fail((int)BpmEnum.SET_FAIL.getCode(), (String)BpmEnum.SET_FAIL.getMessage());
    }

    @RequestMapping(value={"/cancelMain"})
    @ManageBusinessLog(key="/processDefinition/cancelMain", value="\u53d6\u6d88\u4e3b\u7248\u672c", type="\u4fee\u6539")
    public ApiResponse<?> cancelMain(String processDefKey, String id) {
        int num = this.processDefinitionsService.cancelMain(processDefKey, id);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefKey).latestVersion().singleResult();
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processDefKey, processDefinition.getId(), BaseShiroKit.getUser().getTenantId())) {
                return ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
            }
            return ApiResponse.fail((int)BpmEnum.FILES_NOT_FOUND.getCode(), (String)BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
    }
}

