DROP SEQUENCE IF EXISTS ACT_EVT_LOG_LOG_NR__SEQ CASCADE;
CREATE SEQUENCE ACT_EVT_LOG_LOG_NR__SEQ INCREMENT BY 1 START WITH 1 MINVALUE 1 MAXVALUE 9223372036854775807 NO CYCLE  CACHE 1 ;

DROP TABLE IF EXISTS ACT_EVT_LOG;
CREATE TABLE ACT_EVT_LOG
(
    LOG_NR_ integer DEFAULT NEXTVAL('ACT_EVT_LOG_LOG_NR__SEQ'::text) NOT NULL,
    TYPE_ character varying(128) ,
    PROC_DEF_ID_ character varying(128) ,
    PROC_INST_ID_ character varying(128) ,
    EXECUTION_ID_ character varying(128) ,
    TASK_ID_ character varying(128) ,
    TIME_STAMP_ timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    USER_ID_ character varying(510) ,
    DATA_ blob ,
    LOCK_OWNER_ character varying(510) ,
    LOCK_TIME_ timestamp without time zone ,
    IS_PROCESSED_ tinyint DEFAULT 0 ,
    CONSTRAINT ACT_EVT_LOG_PK PRIMARY KEY (LOG_NR_)
)
 BINLOG ON ;

DROP TABLE IF EXISTS ACT_RE_DEPLOYMENT CASCADE;
CREATE TABLE ACT_RE_DEPLOYMENT
(
    ID_ character varying(128) NOT NULL,
    NAME_ character varying(510) ,
    CATEGORY_ character varying(510) ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    DEPLOY_TIME_ timestamp without time zone ,
    CONSTRAINT ACT_RE_DEPLOYMENT_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;

DROP TABLE IF EXISTS ACT_GE_BYTEARRAY CASCADE;
CREATE TABLE ACT_GE_BYTEARRAY
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    NAME_ character varying(510) ,
    DEPLOYMENT_ID_ character varying(128) ,
    BYTES_ blob ,
    GENERATED_ tinyint ,
    CONSTRAINT ACT_GE_BYTEARRAY_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_GE_BYTEARRAY_IBFK_1 FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES ACT_RE_DEPLOYMENT(ID_)
)
 BINLOG ON ;

DROP TABLE IF EXISTS ACT_GE_PROPERTY;
CREATE TABLE ACT_GE_PROPERTY
(
    NAME_ character varying(128) NOT NULL,
    VALUE_ character varying(600) ,
    REV_ integer ,
    CONSTRAINT ACT_GE_PROPERTY_PK PRIMARY KEY (NAME_)
)
 BINLOG ON ;

DROP TABLE IF EXISTS ACT_HI_ACTINST;
CREATE TABLE ACT_HI_ACTINST
(
    ID_ character varying(128) NOT NULL,
    PROC_DEF_ID_ character varying(128) NOT NULL,
    PROC_INST_ID_ character varying(128) NOT NULL,
    EXECUTION_ID_ character varying(128) NOT NULL,
    ACT_ID_ character varying(510) NOT NULL,
    TASK_ID_ character varying(128) ,
    CALL_PROC_INST_ID_ character varying(128) ,
    ACT_NAME_ character varying(510) ,
    ACT_TYPE_ character varying(510) NOT NULL,
    ASSIGNEE_ character varying(510) ,
    START_TIME_ timestamp without time zone ,
    END_TIME_ timestamp without time zone ,
    DURATION_ bigint ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    CONSTRAINT ACT_HI_ACTINST_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_HI_ACTINST_ACT_IDX_HI_ACT_INST_END ON ACT_HI_ACTINST USING BTREE(END_TIME_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_ACTINST_ACT_IDX_HI_ACT_INST_EXEC ON ACT_HI_ACTINST USING BTREE(EXECUTION_ID_, ACT_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_ACTINST_ACT_IDX_HI_ACT_INST_PROCINST ON ACT_HI_ACTINST USING BTREE(PROC_INST_ID_, ACT_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_ACTINST_ACT_IDX_HI_ACT_INST_START ON ACT_HI_ACTINST USING BTREE(START_TIME_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_HI_ATTACHMENT;
CREATE TABLE ACT_HI_ATTACHMENT
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    USER_ID_ character varying(510) ,
    NAME_ character varying(510) ,
    DESCRIPTION_ character varying(8000) ,
    TYPE_ character varying(510) ,
    TASK_ID_ character varying(128) ,
    PROC_INST_ID_ character varying(128) ,
    URL_ character varying(8000) ,
    CONTENT_ID_ character varying(128) ,
    TIME_ timestamp without time zone ,
    CONSTRAINT ACT_HI_ATTACHMENT_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;

DROP TABLE IF EXISTS ACT_HI_COMMENT;
CREATE TABLE ACT_HI_COMMENT
(
    ID_ character varying(128) NOT NULL,
    TYPE_ character varying(510) ,
    TIME_ timestamp without time zone ,
    USER_ID_ character varying(510) ,
    TASK_ID_ character varying(128) ,
    PROC_INST_ID_ character varying(128) ,
    ACTION_ character varying(510) ,
    MESSAGE_ character varying(8000) ,
    FULL_MSG_ blob ,
    CONSTRAINT ACT_HI_COMMENT_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;

CREATE INDEX ACT_IDX_HI_COMMENT_TASK_ID ON ACT_HI_COMMENT USING BTREE(TASK_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_IDX_ACT_HI_COMMENT_TYPE ON ACT_HI_COMMENT USING BTREE(TYPE_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;


DROP TABLE IF EXISTS ACT_HI_DETAIL;
CREATE TABLE ACT_HI_DETAIL
(
    ID_ character varying(128) NOT NULL,
    TYPE_ character varying(510) NOT NULL,
    PROC_INST_ID_ character varying(128) ,
    EXECUTION_ID_ character varying(128) ,
    TASK_ID_ character varying(128) ,
    ACT_INST_ID_ character varying(128) ,
    NAME_ character varying(510) NOT NULL,
    VAR_TYPE_ character varying(510) ,
    REV_ integer ,
    TIME_ timestamp without time zone ,
    BYTEARRAY_ID_ character varying(128) ,
    DOUBLE_ double precision ,
    LONG_ bigint ,
    TEXT_ character varying(8000) ,
    TEXT2_ character varying(8000) ,
    CONSTRAINT ACT_HI_DETAIL_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_HI_DETAIL_ACT_IDX_HI_DETAIL_ACT_INST ON ACT_HI_DETAIL USING BTREE(ACT_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_DETAIL_ACT_IDX_HI_DETAIL_NAME ON ACT_HI_DETAIL USING BTREE(NAME_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_DETAIL_ACT_IDX_HI_DETAIL_PROC_INST ON ACT_HI_DETAIL USING BTREE(PROC_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_DETAIL_ACT_IDX_HI_DETAIL_TASK_ID ON ACT_HI_DETAIL USING BTREE(TASK_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_DETAIL_ACT_IDX_HI_DETAIL_TIME ON ACT_HI_DETAIL USING BTREE(TIME_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_HI_IDENTITYLINK;
CREATE TABLE ACT_HI_IDENTITYLINK
(
    ID_ character varying(128) NOT NULL,
    GROUP_ID_ character varying(510) ,
    TYPE_ character varying(510) ,
    USER_ID_ character varying(510) ,
    TASK_ID_ character varying(128) ,
    PROC_INST_ID_ character varying(128) ,
    CONSTRAINT ACT_HI_IDENTITYLINK_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_HI_IDENTITYLINK_ACT_IDX_HI_IDENT_LNK_PROCINST ON ACT_HI_IDENTITYLINK USING BTREE(PROC_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_IDENTITYLINK_ACT_IDX_HI_IDENT_LNK_TASK ON ACT_HI_IDENTITYLINK USING BTREE(TASK_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_IDENTITYLINK_ACT_IDX_HI_IDENT_LNK_USER ON ACT_HI_IDENTITYLINK USING BTREE(USER_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_HI_PROCINST;
CREATE TABLE ACT_HI_PROCINST
(
    ID_ character varying(128) NOT NULL,
    PROC_INST_ID_ character varying(128) NOT NULL,
    BUSINESS_KEY_ character varying(510) ,
    PROC_DEF_ID_ character varying(128) NOT NULL,
    START_TIME_ timestamp without time zone ,
    END_TIME_ timestamp without time zone ,
    DURATION_ bigint ,
    START_USER_ID_ character varying(510) ,
    START_ACT_ID_ character varying(510) ,
    END_ACT_ID_ character varying(510) ,
    SUPER_PROCESS_INSTANCE_ID_ character varying(128) ,
    DELETE_REASON_ character varying(8000) ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    NAME_ character varying(510) ,
    CONSTRAINT ACT_HI_PROCINST_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_HI_PROCINST_PROC_INST_ID__KEY UNIQUE (PROC_INST_ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_HI_PROCINST_ACT_IDX_HI_PRO_INST_END ON ACT_HI_PROCINST USING BTREE(END_TIME_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_PROCINST_ACT_IDX_HI_PRO_I_BUSKEY ON ACT_HI_PROCINST USING BTREE(BUSINESS_KEY_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_IDX_ACT_HI_PROCINST_SUPER_PROCINST_ID ON ACT_HI_PROCINST USING BTREE(SUPER_PROCESS_INSTANCE_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;


DROP TABLE IF EXISTS ACT_HI_TASKINST;
CREATE TABLE ACT_HI_TASKINST
(
    ID_ character varying(128) NOT NULL,
    PROC_DEF_ID_ character varying(128) ,
    TASK_DEF_KEY_ character varying(510) ,
    PROC_INST_ID_ character varying(128) ,
    EXECUTION_ID_ character varying(128) ,
    NAME_ character varying(510) ,
    PARENT_TASK_ID_ character varying(128) ,
    DESCRIPTION_ character varying(8000) ,
    OWNER_ character varying(510) ,
    ASSIGNEE_ character varying(510) ,
    START_TIME_ timestamp without time zone ,
    CLAIM_TIME_ timestamp without time zone ,
    END_TIME_ timestamp without time zone ,
    DURATION_ bigint ,
    DELETE_REASON_ character varying(8000) ,
    PRIORITY_ integer ,
    DUE_DATE_ timestamp without time zone ,
    FORM_KEY_ character varying(4000) ,
    CATEGORY_ character varying(510) ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    CONSTRAINT ACT_HI_TASKINST_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_HI_TASKINST_ACT_IDX_HI_TASK_INST_PROCINST ON ACT_HI_TASKINST USING BTREE(PROC_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64 MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_IDX_ACT_HI_TASKINST_END_TIME ON ACT_HI_TASKINST USING BTREE(END_TIME_) TABLESPACE SYSTEM INIT 64K NEXT 64 MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_IDX_ACT_HI_TASKINST_ASSIGNEE ON ACT_HI_TASKINST USING BTREE(ASSIGNEE_) TABLESPACE SYSTEM INIT 64K NEXT 64 MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_HI_VARINST;
CREATE TABLE ACT_HI_VARINST
(
    ID_ character varying(128) NOT NULL,
    PROC_INST_ID_ character varying(128) ,
    EXECUTION_ID_ character varying(128) ,
    TASK_ID_ character varying(128) ,
    NAME_ character varying(510) NOT NULL,
    VAR_TYPE_ character varying(200) ,
    REV_ integer ,
    BYTEARRAY_ID_ character varying(128) ,
    DOUBLE_ double precision ,
    LONG_ bigint ,
    TEXT_ character varying(8000) ,
    TEXT2_ character varying(8000) ,
    CREATE_TIME_ timestamp without time zone ,
    LAST_UPDATED_TIME_ timestamp without time zone ,
    CONSTRAINT ACT_HI_VARINST_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_HI_VARINST_ACT_IDX_HI_PROCVAR_NAME_TYPE ON ACT_HI_VARINST USING BTREE(NAME_, VAR_TYPE_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_VARINST_ACT_IDX_HI_PROCVAR_PROC_INST ON ACT_HI_VARINST USING BTREE(PROC_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_HI_VARINST_ACT_IDX_HI_PROCVAR_TASK_ID ON ACT_HI_VARINST USING BTREE(TASK_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_ID_GROUP CASCADE;
CREATE TABLE ACT_ID_GROUP
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    NAME_ character varying(510) ,
    TYPE_ character varying(510) ,
    CONSTRAINT ACT_ID_GROUP_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;

DROP TABLE IF EXISTS ACT_ID_INFO;
CREATE TABLE ACT_ID_INFO
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    USER_ID_ character varying(128) ,
    TYPE_ character varying(128) ,
    KEY_ character varying(510) ,
    VALUE_ character varying(510) ,
    PASSWORD_ blob ,
    PARENT_ID_ character varying(510) ,
    CONSTRAINT ACT_ID_INFO_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;

DROP TABLE IF EXISTS ACT_ID_USER CASCADE;
CREATE TABLE ACT_ID_USER
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    FIRST_ character varying(510) ,
    LAST_ character varying(510) ,
    EMAIL_ character varying(510) ,
    PWD_ character varying(510) ,
    PICTURE_ID_ character varying(128) ,
    CONSTRAINT ACT_ID_USER_PK PRIMARY KEY (ID_)
)
 BINLOG ON ;

DROP TABLE IF EXISTS ACT_ID_MEMBERSHIP;
CREATE TABLE ACT_ID_MEMBERSHIP
(
    USER_ID_ character varying(128) NOT NULL,
    GROUP_ID_ character varying(128) NOT NULL,
    CONSTRAINT ACT_ID_MEMBERSHIP_PK PRIMARY KEY (USER_ID_, GROUP_ID_),
    CONSTRAINT ACT_ID_MEMBERSHIP_IBFK_1 FOREIGN KEY (GROUP_ID_) REFERENCES ACT_ID_GROUP(ID_),
    CONSTRAINT ACT_ID_MEMBERSHIP_IBFK_2 FOREIGN KEY (USER_ID_) REFERENCES ACT_ID_USER(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_ID_MEMBERSHIP_ACT_FK_MEMB_GROUP ON ACT_ID_MEMBERSHIP USING BTREE(GROUP_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_RE_PROCDEF CASCADE;
CREATE TABLE ACT_RE_PROCDEF
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    CATEGORY_ character varying(510) ,
    NAME_ character varying(510) ,
    KEY_ character varying(510) NOT NULL,
    VERSION_ integer NOT NULL,
    DEPLOYMENT_ID_ character varying(128) ,
    RESOURCE_NAME_ character varying(8000) ,
    DGRM_RESOURCE_NAME_ character varying(8000) ,
    DESCRIPTION_ character varying(8000) ,
    HAS_START_FORM_KEY_ tinyint ,
    HAS_GRAPHICAL_NOTATION_ tinyint ,
    SUSPENSION_STATE_ integer ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    MAIN_PROCESS character varying(8) DEFAULT '0' ,
    REAL_VERSION integer,
    CONSTRAINT ACT_RE_PROCDEF_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_RE_PROCDEF_ACT_UNIQ_PROCDEF_KEY UNIQUE (KEY_, VERSION_, TENANT_ID_)
)
 BINLOG ON ;

COMMENT ON COLUMN ACT_RE_PROCDEF.MAIN_PROCESS IS '1主版本 0 不是主版本 2 临时版本' ;
COMMENT ON COLUMN ACT_RE_PROCDEF.REAL_VERSION IS '临时版本流程真实版本号' ;

DROP TABLE IF EXISTS ACT_PROCDEF_INFO;
CREATE TABLE ACT_PROCDEF_INFO
(
    ID_ character varying(128) NOT NULL,
    PROC_DEF_ID_ character varying(128) NOT NULL,
    REV_ integer ,
    INFO_JSON_ID_ character varying(128) ,
    CONSTRAINT ACT_PROCDEF_INFO_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_PROCDEF_INFO_ACT_UNIQ_INFO_PROCDEF_KEY UNIQUE (PROC_DEF_ID_),
    CONSTRAINT ACT_PROCDEF_INFO_IBFK_1 FOREIGN KEY (INFO_JSON_ID_) REFERENCES ACT_GE_BYTEARRAY(ID_),
    CONSTRAINT ACT_PROCDEF_INFO_IBFK_2 FOREIGN KEY (PROC_DEF_ID_) REFERENCES ACT_RE_PROCDEF(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_PROCDEF_INFO_ACT_FK_INFO_JSON_BA ON ACT_PROCDEF_INFO USING BTREE(INFO_JSON_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_PROCDEF_INFO_ACT_IDX_INFO_PROCDEF ON ACT_PROCDEF_INFO USING BTREE(PROC_DEF_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_RE_MODEL;
CREATE TABLE ACT_RE_MODEL
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    NAME_ character varying(510) ,
    KEY_ character varying(510) ,
    CATEGORY_ character varying(510) ,
    CREATE_TIME_ timestamp without time zone ,
    LAST_UPDATE_TIME_ timestamp without time zone ,
    VERSION_ integer ,
    META_INFO_ character varying(8000) ,
    DEPLOYMENT_ID_ character varying(128) ,
    EDITOR_SOURCE_VALUE_ID_ character varying(128) ,
    EDITOR_SOURCE_EXTRA_VALUE_ID_ character varying(128) ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    CONSTRAINT ACT_RE_MODEL_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_RE_MODEL_IBFK_1 FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES ACT_RE_DEPLOYMENT(ID_),
    CONSTRAINT ACT_RE_MODEL_IBFK_2 FOREIGN KEY (EDITOR_SOURCE_VALUE_ID_) REFERENCES ACT_GE_BYTEARRAY(ID_),
    CONSTRAINT ACT_RE_MODEL_IBFK_3 FOREIGN KEY (EDITOR_SOURCE_EXTRA_VALUE_ID_) REFERENCES ACT_GE_BYTEARRAY(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_RE_MODEL_ACT_FK_MODEL_DEPLOYMENT ON ACT_RE_MODEL USING BTREE(DEPLOYMENT_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RE_MODEL_ACT_FK_MODEL_SOURCE ON ACT_RE_MODEL USING BTREE(EDITOR_SOURCE_VALUE_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RE_MODEL_ACT_FK_MODEL_SOURCE_EXTRA ON ACT_RE_MODEL USING BTREE(EDITOR_SOURCE_EXTRA_VALUE_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_RU_EXECUTION CASCADE;
CREATE TABLE ACT_RU_EXECUTION
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    PROC_INST_ID_ character varying(128) ,
    BUSINESS_KEY_ character varying(510) ,
    PARENT_ID_ character varying(128) ,
    PROC_DEF_ID_ character varying(128) ,
    SUPER_EXEC_ character varying(128) ,
    ACT_ID_ character varying(510) ,
    IS_ACTIVE_ tinyint ,
    IS_CONCURRENT_ tinyint ,
    IS_SCOPE_ tinyint ,
    IS_EVENT_SCOPE_ tinyint ,
    SUSPENSION_STATE_ integer ,
    CACHED_ENT_STATE_ integer ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    NAME_ character varying(510) ,
    LOCK_TIME_ timestamp without time zone ,
    CONSTRAINT ACT_RU_EXECUTION_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_RU_EXECUTION_IBFK_1 FOREIGN KEY (PARENT_ID_) REFERENCES ACT_RU_EXECUTION(ID_),
    CONSTRAINT ACT_RU_EXECUTION_IBFK_2 FOREIGN KEY (PROC_DEF_ID_) REFERENCES ACT_RE_PROCDEF(ID_),
    CONSTRAINT ACT_RU_EXECUTION_IBFK_3 FOREIGN KEY (PROC_INST_ID_) REFERENCES ACT_RU_EXECUTION(ID_),
    CONSTRAINT ACT_RU_EXECUTION_IBFK_4 FOREIGN KEY (SUPER_EXEC_) REFERENCES ACT_RU_EXECUTION(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_RU_EXECUTION_ACT_FK_EXE_PARENT ON ACT_RU_EXECUTION USING BTREE(PARENT_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_EXECUTION_ACT_FK_EXE_PROCDEF ON ACT_RU_EXECUTION USING BTREE(PROC_DEF_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_EXECUTION_ACT_FK_EXE_PROCINST ON ACT_RU_EXECUTION USING BTREE(PROC_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_EXECUTION_ACT_FK_EXE_SUPER ON ACT_RU_EXECUTION USING BTREE(SUPER_EXEC_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_EXECUTION_ACT_IDX_EXEC_BUSKEY ON ACT_RU_EXECUTION USING BTREE(BUSINESS_KEY_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_RU_EVENT_SUBSCR;
CREATE TABLE ACT_RU_EVENT_SUBSCR
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    EVENT_TYPE_ character varying(510) NOT NULL,
    EVENT_NAME_ character varying(510) ,
    EXECUTION_ID_ character varying(128) ,
    PROC_INST_ID_ character varying(128) ,
    ACTIVITY_ID_ character varying(128) ,
    CONFIGURATION_ character varying(510) ,
    CREATED_ timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    PROC_DEF_ID_ character varying(128) ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    CONSTRAINT ACT_RU_EVENT_SUBSCR_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_RU_EVENT_SUBSCR_IBFK_1 FOREIGN KEY (EXECUTION_ID_) REFERENCES ACT_RU_EXECUTION(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_RU_EVENT_SUBSCR_ACT_FK_EVENT_EXEC ON ACT_RU_EVENT_SUBSCR USING BTREE(EXECUTION_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_EVENT_SUBSCR_ACT_IDX_EVENT_SUBSCR_CONFIG_ ON ACT_RU_EVENT_SUBSCR USING BTREE(CONFIGURATION_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_RU_TASK CASCADE;
CREATE TABLE ACT_RU_TASK
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    EXECUTION_ID_ character varying(128) ,
    PROC_INST_ID_ character varying(128) ,
    PROC_DEF_ID_ character varying(128) ,
    NAME_ character varying(510) ,
    PARENT_TASK_ID_ character varying(128) ,
    DESCRIPTION_ character varying(8000) ,
    TASK_DEF_KEY_ character varying(510) ,
    OWNER_ character varying(510) ,
    ASSIGNEE_ character varying(510) ,
    DELEGATION_ character varying(128) ,
    PRIORITY_ integer ,
    CREATE_TIME_ timestamp without time zone ,
    DUE_DATE_ timestamp without time zone ,
    CATEGORY_ character varying(510) ,
    SUSPENSION_STATE_ integer ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    FORM_KEY_ character varying(4000) ,
    CONSTRAINT ACT_RU_TASK_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_RU_TASK_IBFK_1 FOREIGN KEY (EXECUTION_ID_) REFERENCES ACT_RU_EXECUTION(ID_),
    CONSTRAINT ACT_RU_TASK_IBFK_2 FOREIGN KEY (PROC_DEF_ID_) REFERENCES ACT_RE_PROCDEF(ID_),
    CONSTRAINT ACT_RU_TASK_IBFK_3 FOREIGN KEY (PROC_INST_ID_) REFERENCES ACT_RU_EXECUTION(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_RU_TASK_ACT_FK_TASK_EXE ON ACT_RU_TASK USING BTREE(EXECUTION_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_TASK_ACT_FK_TASK_PROCDEF ON ACT_RU_TASK USING BTREE(PROC_DEF_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_TASK_ACT_FK_TASK_PROCINST ON ACT_RU_TASK USING BTREE(PROC_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_TASK_ACT_IDX_TASK_CREATE ON ACT_RU_TASK USING BTREE(CREATE_TIME_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_RU_IDENTITYLINK;
CREATE TABLE ACT_RU_IDENTITYLINK
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    GROUP_ID_ character varying(510) ,
    TYPE_ character varying(510) ,
    USER_ID_ character varying(510) ,
    TASK_ID_ character varying(128) ,
    PROC_INST_ID_ character varying(128) ,
    PROC_DEF_ID_ character varying(128) ,
    CONSTRAINT ACT_RU_IDENTITYLINK_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_RU_IDENTITYLINK_IBFK_1 FOREIGN KEY (PROC_DEF_ID_) REFERENCES ACT_RE_PROCDEF(ID_),
    CONSTRAINT ACT_RU_IDENTITYLINK_IBFK_2 FOREIGN KEY (PROC_INST_ID_) REFERENCES ACT_RU_EXECUTION(ID_),
    CONSTRAINT ACT_RU_IDENTITYLINK_IBFK_3 FOREIGN KEY (TASK_ID_) REFERENCES ACT_RU_TASK(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_RU_IDENTITYLINK_ACT_FK_IDL_PROCINST ON ACT_RU_IDENTITYLINK USING BTREE(PROC_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_IDENTITYLINK_ACT_FK_TSKASS_TASK ON ACT_RU_IDENTITYLINK USING BTREE(TASK_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_IDENTITYLINK_ACT_IDX_ATHRZ_PROCEDEF ON ACT_RU_IDENTITYLINK USING BTREE(PROC_DEF_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_IDENTITYLINK_ACT_IDX_IDENT_LNK_GROUP ON ACT_RU_IDENTITYLINK USING BTREE(GROUP_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_IDENTITYLINK_ACT_IDX_IDENT_LNK_USER ON ACT_RU_IDENTITYLINK USING BTREE(USER_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_RU_JOB;
CREATE TABLE ACT_RU_JOB
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    TYPE_ character varying(510) NOT NULL,
    LOCK_EXP_TIME_ timestamp without time zone ,
    LOCK_OWNER_ character varying(510) ,
    EXCLUSIVE_ tinyint ,
    EXECUTION_ID_ character varying(128) ,
    PROCESS_INSTANCE_ID_ character varying(128) ,
    PROC_DEF_ID_ character varying(128) ,
    RETRIES_ integer ,
    EXCEPTION_STACK_ID_ character varying(128) ,
    EXCEPTION_MSG_ character varying(8000) ,
    DUEDATE_ timestamp without time zone ,
    REPEAT_ character varying(510) ,
    HANDLER_TYPE_ character varying(510) ,
    HANDLER_CFG_ character varying(8000) ,
    TENANT_ID_ character varying(510) DEFAULT '' ,
    CONSTRAINT ACT_RU_JOB_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_RU_JOB_IBFK_1 FOREIGN KEY (EXCEPTION_STACK_ID_) REFERENCES ACT_GE_BYTEARRAY(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_RU_JOB_ACT_FK_JOB_EXCEPTION ON ACT_RU_JOB USING BTREE(EXCEPTION_STACK_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS ACT_RU_VARIABLE;
CREATE TABLE ACT_RU_VARIABLE
(
    ID_ character varying(128) NOT NULL,
    REV_ integer ,
    TYPE_ character varying(510) NOT NULL,
    NAME_ character varying(510) NOT NULL,
    EXECUTION_ID_ character varying(128) ,
    PROC_INST_ID_ character varying(128) ,
    TASK_ID_ character varying(128) ,
    BYTEARRAY_ID_ character varying(128) ,
    DOUBLE_ double precision ,
    LONG_ bigint ,
    TEXT_ character varying(8000) ,
    TEXT2_ character varying(8000) ,
    CONSTRAINT ACT_RU_VARIABLE_PK PRIMARY KEY (ID_),
    CONSTRAINT ACT_RU_VARIABLE_IBFK_1 FOREIGN KEY (BYTEARRAY_ID_) REFERENCES ACT_GE_BYTEARRAY(ID_),
    CONSTRAINT ACT_RU_VARIABLE_IBFK_2 FOREIGN KEY (EXECUTION_ID_) REFERENCES ACT_RU_EXECUTION(ID_),
    CONSTRAINT ACT_RU_VARIABLE_IBFK_3 FOREIGN KEY (PROC_INST_ID_) REFERENCES ACT_RU_EXECUTION(ID_)
)
 BINLOG ON ;
--Indexes DDL
CREATE INDEX ACT_RU_VARIABLE_ACT_FK_VAR_BYTEARRAY ON ACT_RU_VARIABLE USING BTREE(BYTEARRAY_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_VARIABLE_ACT_FK_VAR_EXE ON ACT_RU_VARIABLE USING BTREE(EXECUTION_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_VARIABLE_ACT_FK_VAR_PROCINST ON ACT_RU_VARIABLE USING BTREE(PROC_INST_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;
CREATE INDEX ACT_RU_VARIABLE_ACT_IDX_VARIABLE_TASK_ID ON ACT_RU_VARIABLE USING BTREE(TASK_ID_) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

DROP TABLE IF EXISTS SYS_ACT_CC_TASK;
CREATE TABLE SYS_ACT_CC_TASK
(
    ID character varying(64) NOT NULL,
    TASK_ID character varying(128) ,
    PROC_INST_ID character varying(128) ,
    PROC_NAME character varying(510) ,
    TASK_NAME character varying(510) ,
    SEND_USER character varying(64) ,
    RECEIVE_USER character varying(64) ,
    SEND_TIME timestamp without time zone ,
    FORM_KEY character varying(2000) ,
    PROC_DEF_KEY character varying(128) ,
    BUSINESS_ID character varying(510) ,
    TASK_DEF_KEY character varying(128) ,
    TEXT clob ,
    CONSTRAINT SYS_ACT_CC_TASK_PK PRIMARY KEY (ID)
)
 BINLOG ON ;

COMMENT ON COLUMN SYS_ACT_CC_TASK.ID IS '主键' ;
COMMENT ON COLUMN SYS_ACT_CC_TASK.TASK_ID IS '任务ID' ;
COMMENT ON COLUMN SYS_ACT_CC_TASK.PROC_INST_ID IS '实例ID' ;
COMMENT ON COLUMN SYS_ACT_CC_TASK.PROC_NAME IS '流程名称' ;
COMMENT ON COLUMN SYS_ACT_CC_TASK.TASK_NAME IS '任务名称' ;
COMMENT ON COLUMN SYS_ACT_CC_TASK.SEND_USER IS '发送人' ;
COMMENT ON COLUMN SYS_ACT_CC_TASK.RECEIVE_USER IS '接收人' ;
COMMENT ON COLUMN SYS_ACT_CC_TASK.TEXT IS '待办配置' ;

DROP TABLE IF EXISTS SYS_ACT_CONFIG;
CREATE TABLE SYS_ACT_CONFIG
(
    TENANT_ID character varying(64) NOT NULL,
    PROJECT_ADDRESS character varying(510) ,
    IS_MQ_USE character varying(510) ,
    IS_GOD_AXE character varying(510) ,
    IS_MULTI_TENANT character(1) ,
    CONSTRAINT SYS_ACT_CONFIG_PK PRIMARY KEY (TENANT_ID)
)
 BINLOG ON ;

COMMENT ON COLUMN SYS_ACT_CONFIG.TENANT_ID IS '租户id' ;
COMMENT ON COLUMN SYS_ACT_CONFIG.PROJECT_ADDRESS IS '项目地址' ;
COMMENT ON COLUMN SYS_ACT_CONFIG.IS_MULTI_TENANT IS '是否共库 1是 0否' ;
COMMENT ON COLUMN SYS_ACT_CONFIG.IS_MQ_USE IS '是否启用mq 1启用 0不启用' ;
COMMENT ON COLUMN SYS_ACT_CONFIG.IS_GOD_AXE IS '是否天斧 1是 0否' ;

DROP TABLE IF EXISTS SYS_ACT_ENTRUST;
CREATE TABLE SYS_ACT_ENTRUST
(
    ID character varying(72) NOT NULL,
    CONSIGNOR character varying(72) ,
    PROCESS_ID character varying(510) ,
    PROCESS_NAME character varying(510) ,
    CONSIGNEE character varying(72) ,
    CONSIGNEE_NAME character varying(510) ,
    START_TIME timestamp without time zone ,
    END_TIME timestamp without time zone ,
    STATE character(1),
    CONSTRAINT SYS_ACT_ENTRUST_PK PRIMARY KEY (ID)
)
 BINLOG ON ;

COMMENT ON TABLE SYS_ACT_ENTRUST IS '委托表' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.ID IS 'ID主键，UUID' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.CONSIGNOR IS '委托人' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.PROCESS_ID IS '流程ID' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.PROCESS_NAME IS '流程名称' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.CONSIGNEE IS '被委托人ID' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.CONSIGNEE_NAME IS '被委托人姓名' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.START_TIME IS '开始时间' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.END_TIME IS '结束时间' ;
COMMENT ON COLUMN SYS_ACT_ENTRUST.STATE IS '状态' ;

DROP TABLE IF EXISTS SYS_ACT_EXTEND_PROPERTIES;
CREATE TABLE SYS_ACT_EXTEND_PROPERTIES
(
    ID character varying(400) ,
    PROC_DEF_ID character varying(128) ,
    TASK_DEF_KEY character varying(128) ,
    TASK_DEF_NAME character varying(2000) ,
    FORM_DETAIL_KEY clob ,
    ATTRIBUTE character varying(64),
    CONSTRAINT SYS_ACT_EXTEND_PROPERTIES_PK PRIMARY KEY (ID)
)
 BINLOG ON ;

COMMENT ON COLUMN SYS_ACT_EXTEND_PROPERTIES.ID IS '主键采用流程定义ID和节点ID拼接组成' ;
COMMENT ON COLUMN SYS_ACT_EXTEND_PROPERTIES.PROC_DEF_ID IS '流程定义ID' ;
COMMENT ON COLUMN SYS_ACT_EXTEND_PROPERTIES.TASK_DEF_KEY IS '节点ID' ;
COMMENT ON COLUMN SYS_ACT_EXTEND_PROPERTIES.TASK_DEF_NAME IS '节点名称' ;
COMMENT ON COLUMN SYS_ACT_EXTEND_PROPERTIES.FORM_DETAIL_KEY IS '表单地址' ;
COMMENT ON COLUMN SYS_ACT_EXTEND_PROPERTIES.ATTRIBUTE IS '标识扩展的属性类型' ;

DROP TABLE IF EXISTS SYS_ACT_HI_LINE;
CREATE TABLE SYS_ACT_HI_LINE
(
    ID character varying(64) ,
    PROC_INST_ID character varying(128) ,
    PROC_DEF_ID character varying(128) ,
    PROC_DEF_KEY character varying(128) ,
    LINE_ID character varying(128) ,
    COMPLETE_TIME timestamp without time zone ,
    COMPLETE_USER character varying(128) ,
    LINE_NAME character varying(512) ,
    PROCESS_NAME character varying(512) ,
    OUT_NODE character varying(128) ,
    OUT_NODE_NAME character varying(512) ,
    IN_NODE character varying(128) ,
    IN_NODE_NAME character varying(512),
    CONSTRAINT SYS_ACT_HI_LINE_PK PRIMARY KEY (ID)
)
 BINLOG ON ;

 CREATE INDEX ACT_IDX_HI_LINE_PINST ON SYS_ACT_HI_LINE USING BTREE(PROC_INST_ID) TABLESPACE SYSTEM INIT 64K NEXT 64K MAXSIZE UNLIMITED FILL 70 SPLIT 50;

COMMENT ON TABLE SYS_ACT_HI_LINE IS '记录流程在办理过程中连线的办理历史' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.ID IS '主键' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.PROC_INST_ID IS '流程实例ID' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.PROC_DEF_ID IS '流程定义ID' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.PROC_DEF_KEY IS '流程定义KEY' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.LINE_ID IS '连线ID' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.COMPLETE_TIME IS '办理时间' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.COMPLETE_USER IS '办理人' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.LINE_NAME IS '连线名称' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.PROCESS_NAME IS '流程名称' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.OUT_NODE IS '出线节点' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.OUT_NODE_NAME IS '出线节点名称' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.IN_NODE IS '入线节点' ;
COMMENT ON COLUMN SYS_ACT_HI_LINE.IN_NODE_NAME IS '入线节点名称' ;

DROP TABLE IF EXISTS SYS_ACT_INTERFACE_LOG;
CREATE TABLE SYS_ACT_INTERFACE_LOG
(
    LOG_ID character varying(64) NOT NULL,
    SESSION_ID character varying(256) ,
    USER_ID character varying(64) ,
    USER_NAME character varying(64) ,
    CORPORATION_ID character varying(64) ,
    CORPORATION_NAME character varying(256) ,
    LOG_TIME timestamp without time zone ,
    REMOTEADDR character varying(256) ,
    REMOTEHOST character varying(256) ,
    REMOTEPORT character varying(16) ,
    LOCALADDR character varying(256) ,
    LOCALHOST character varying(256) ,
    LOCALPORT character varying(16) ,
    RESOURCE_ID character varying(64) ,
    RESOURCE_ALIAS character varying(256) ,
    SECURITY_LEVEL integer ,
    LOG_TYPE character varying(64) ,
    LOG_TYPE_NAME character varying(128) ,
    LOG_CONTENT clob ,
    USER_ACCOUNT character varying(64) ,
    LEVEL_EVENT character varying(2) ,
    STATE character varying(2) ,
    CONSTRAINT SYS_ACT_INTERFACE_LOG_PK PRIMARY KEY (LOG_ID)
)
 BINLOG ON ;

COMMENT ON TABLE SYS_ACT_INTERFACE_LOG IS '安全日志' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.LOG_ID IS '安全日志编码' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.SESSION_ID IS '会话标识' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.USER_ID IS '用户账户' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.USER_NAME IS '用户名称' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.CORPORATION_ID IS '公司编码' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.CORPORATION_NAME IS '公司名称' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.RESOURCE_ALIAS IS '资源业务语义' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.USER_ACCOUNT IS '用户登录账号' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.LEVEL_EVENT IS '1系统级/2业务级事件' ;
COMMENT ON COLUMN SYS_ACT_INTERFACE_LOG.STATE IS '事件类型' ;

DROP TABLE IF EXISTS SYS_ACT_MANAGE_LOG;
CREATE TABLE SYS_ACT_MANAGE_LOG
(
    LOG_ID character varying(64) NOT NULL,
    SESSION_ID character varying(256) ,
    USER_ID character varying(64) ,
    USER_NAME character varying(64) ,
    CORPORATION_ID character varying(64) ,
    CORPORATION_NAME character varying(256) ,
    LOG_TIME timestamp without time zone ,
    REMOTEADDR character varying(256) ,
    REMOTEHOST character varying(256) ,
    REMOTEPORT character varying(16) ,
    LOCALADDR character varying(256) ,
    LOCALHOST character varying(256) ,
    LOCALPORT character varying(16) ,
    RESOURCE_ID character varying(64) ,
    RESOURCE_ALIAS character varying(256) ,
    SECURITY_LEVEL integer ,
    LOG_TYPE character varying(64) ,
    LOG_TYPE_NAME character varying(128) ,
    LOG_CONTENT clob ,
    USER_ACCOUNT character varying(64) ,
    LEVEL_EVENT character varying(2) ,
    STATE character varying(2) ,
    CONSTRAINT SYS_ACT_MANAGE_LOG_PK PRIMARY KEY (LOG_ID)
)
 BINLOG ON ;

COMMENT ON TABLE SYS_ACT_MANAGE_LOG IS '安全日志' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.LOG_ID IS '安全日志编码' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.SESSION_ID IS '会话标识' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.USER_ID IS '用户账户' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.USER_NAME IS '用户名称' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.CORPORATION_ID IS '公司编码' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.CORPORATION_NAME IS '公司名称' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.RESOURCE_ALIAS IS '资源业务语义' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.USER_ACCOUNT IS '用户登录账号' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.LEVEL_EVENT IS '1系统级/2业务级事件' ;
COMMENT ON COLUMN SYS_ACT_MANAGE_LOG.STATE IS '事件类型' ;

DROP TABLE IF EXISTS SYS_ACT_PROCESS_FILE;
CREATE TABLE SYS_ACT_PROCESS_FILE
(
    FILE_ID character varying(128) NOT NULL,
    PROCESS_KEY character varying(128) ,
    PROCESS_ID character varying(128) ,
    "VERSION" integer ,
    "TYPE" character varying(16) ,
    "CONTENT" blob ,
    MODEL_ID character varying(128) ,
    TENANT_ID character varying(128) ,
    CREATE_TIME timestamp without time zone ,
    CONSTRAINT SYS_ACT_PROCESS_FILE_PK PRIMARY KEY (FILE_ID)
)
 BINLOG ON ;

COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.FILE_ID IS '文件ID' ;
COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.PROCESS_KEY IS '流程标识' ;
COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.PROCESS_ID IS '流程ID' ;
COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.VERSION IS '版本号' ;
COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.TYPE IS '文件类型' ;
COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.CONTENT IS '文件内容' ;
COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.MODEL_ID IS '模块ID' ;
COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.TENANT_ID IS '租户ID' ;
COMMENT ON COLUMN SYS_ACT_PROCESS_FILE.CREATE_TIME IS '创建时间' ;

DROP TABLE IF EXISTS SYS_ACT_URGE_TASK;
CREATE TABLE SYS_ACT_URGE_TASK
(
    ID character varying(64) NOT NULL,
    TASK_ID character varying(128) ,
    PROC_INST_ID character varying(128) ,
    PROC_NAME character varying(510) ,
    TASK_NAME character varying(510) ,
    SEND_USER character varying(64) ,
    RECEIVE_USER character varying(64) ,
    SEND_TIME timestamp without time zone ,
    FORM_KEY character varying(2000) ,
    PROC_DEF_KEY character varying(128) ,
    BUSINESS_ID character varying(510) ,
    TASK_DEF_KEY character varying(128) ,
    TEXT clob ,
    CONSTRAINT SYS_ACT_URGE_TASK_PK PRIMARY KEY (ID)
)
 BINLOG ON ;

COMMENT ON COLUMN SYS_ACT_URGE_TASK.ID IS '主键' ;
COMMENT ON COLUMN SYS_ACT_URGE_TASK.TASK_ID IS '任务ID' ;
COMMENT ON COLUMN SYS_ACT_URGE_TASK.PROC_INST_ID IS '实例ID' ;
COMMENT ON COLUMN SYS_ACT_URGE_TASK.PROC_NAME IS '流程名称' ;
COMMENT ON COLUMN SYS_ACT_URGE_TASK.TASK_NAME IS '任务名称' ;
COMMENT ON COLUMN SYS_ACT_URGE_TASK.SEND_USER IS '发送人' ;
COMMENT ON COLUMN SYS_ACT_URGE_TASK.RECEIVE_USER IS '接收人' ;
COMMENT ON COLUMN SYS_ACT_URGE_TASK.TEXT IS '待办配置' ;

DROP TABLE IF EXISTS SYS_ACT_FUNCTION;
CREATE TABLE SYS_ACT_FUNCTION
(
    FUNCTION_ID character varying(72) NOT NULL,
    FUNCTION_NAME character varying(510) ,
    FUNCTION_BEAN character varying(510) ,
    CREATE_TIME timestamp without time zone ,
    UPDATE_TIME timestamp without time zone ,
    CONSTRAINT SYS_ACT_FUNCTION_PK PRIMARY KEY (FUNCTION_ID)
)
 BINLOG ON ;

COMMENT ON COLUMN SYS_ACT_FUNCTION.FUNCTION_ID IS '主键' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION.FUNCTION_NAME IS '函数名称' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION.FUNCTION_BEAN IS '函数BEANID' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION.CREATE_TIME IS '创建时间' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION.UPDATE_TIME IS '修改时间' ;

DROP TABLE IF EXISTS SYS_ACT_FUNCTION_PARM;
CREATE TABLE SYS_ACT_FUNCTION_PARM
(
    PARM_ID character varying(72) NOT NULL,
    FUNCTION_ID character varying(72) NOT NULL,
    PARM_NAME character varying(510) ,
    PARM_KEY character varying(510) ,
    CREATE_TIME timestamp without time zone ,
    UPDATE_TIME timestamp without time zone ,
    CONSTRAINT SYS_ACT_FUNCTION_PARM_PK PRIMARY KEY (PARM_ID)
)
 BINLOG ON ;

COMMENT ON COLUMN SYS_ACT_FUNCTION_PARM.PARM_ID IS '主键' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION_PARM.FUNCTION_ID IS '函数主键' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION_PARM.PARM_NAME IS '参数名称' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION_PARM.PARM_KEY IS '参数标识' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION_PARM.CREATE_TIME IS '创建时间' ;
COMMENT ON COLUMN SYS_ACT_FUNCTION_PARM.UPDATE_TIME IS '修改时间' ;

DROP TABLE IF EXISTS SYS_ACT_TIMEOUT_ACTIVITY;
CREATE TABLE SYS_ACT_TIMEOUT_ACTIVITY
(
    TASK_ID character varying(64) NOT NULL,
    ASSIGNEE character varying(255),
    DUE_TIME timestamp without time zone ,
    CREATE_TIME timestamp without time zone ,
    TIME_OUT_TYPE character varying(255) ,
    TENANT_ID character varying(255) ,
    MAP character varying(2000) ,
    CONSTRAINT SYS_ACT_TIMEOUT_ACTIVITY_PK PRIMARY KEY (TASK_ID)
)
BINLOG ON ;

COMMENT ON COLUMN SYS_ACT_TIMEOUT_ACTIVITY.TASK_ID IS '任务id';
COMMENT ON COLUMN SYS_ACT_TIMEOUT_ACTIVITY.ASSIGNEE IS '参与者';
COMMENT ON COLUMN SYS_ACT_TIMEOUT_ACTIVITY.CREATE_TIME IS '开始时间';
COMMENT ON COLUMN SYS_ACT_TIMEOUT_ACTIVITY.DUE_TIME IS '到期时间';
COMMENT ON COLUMN SYS_ACT_TIMEOUT_ACTIVITY.TIME_OUT_TYPE IS '超时处理类型';
COMMENT ON COLUMN SYS_ACT_TIMEOUT_ACTIVITY.TENANT_ID IS '租户id';
COMMENT ON COLUMN SYS_ACT_TIMEOUT_ACTIVITY.MAP IS '接口类型额外参数';


INSERT INTO ACT_GE_PROPERTY (NAME_,VALUE_,REV_) VALUES
('next.dbid','447501',180)
,('schema.history','create(5.22.0.0)',1)
,('schema.version','5.22.0.0',1)
;

COMMENT ON TABLE ACT_EVT_LOG IS '事件日志表';
COMMENT ON TABLE ACT_GE_BYTEARRAY IS '二进制数据表';
COMMENT ON TABLE ACT_GE_PROPERTY IS '属性数据表';
COMMENT ON TABLE ACT_HI_ACTINST IS '历史节点表';
COMMENT ON TABLE ACT_HI_ATTACHMENT IS '历史附件表';
COMMENT ON TABLE ACT_HI_COMMENT IS '历史意见表';
COMMENT ON TABLE ACT_HI_DETAIL IS '历史详情表';
COMMENT ON TABLE ACT_HI_IDENTITYLINK IS '历史流程人员表';
COMMENT ON TABLE ACT_HI_PROCINST IS '历史流程实例表';
COMMENT ON TABLE ACT_HI_TASKINST IS '历史任务实例表';
COMMENT ON TABLE ACT_HI_VARINST IS '历史变量表';
COMMENT ON TABLE ACT_ID_GROUP IS '用户组信息表';
COMMENT ON TABLE ACT_ID_INFO IS '用户扩展信息表';
COMMENT ON TABLE ACT_ID_MEMBERSHIP IS '用户与分组对应信息表';
COMMENT ON TABLE ACT_ID_USER IS '用户信息表';
COMMENT ON TABLE ACT_PROCDEF_INFO IS '流程定义信息表';
COMMENT ON TABLE ACT_RE_DEPLOYMENT IS '部署信息表';
COMMENT ON TABLE ACT_RE_MODEL IS '流程设计模型部署表';
COMMENT ON TABLE ACT_RE_PROCDEF IS '流程定义数据表';
COMMENT ON TABLE ACT_RU_EVENT_SUBSCR IS '运行实例表';
COMMENT ON TABLE ACT_RU_EXECUTION IS '运行时流程执行实例表';
COMMENT ON TABLE ACT_RU_IDENTITYLINK IS '运行时流程人员表';
COMMENT ON TABLE ACT_RU_JOB IS '运行时定时任务数据表';
COMMENT ON TABLE ACT_RU_TASK IS '运行时任务节点表';
COMMENT ON TABLE ACT_RU_VARIABLE IS '运行时流程变量数据表';
COMMENT ON TABLE SYS_ACT_CC_TASK IS '抄送表';
COMMENT ON TABLE SYS_ACT_CONFIG IS '配置表';
COMMENT ON TABLE SYS_ACT_ENTRUST IS '委托表';
COMMENT ON TABLE SYS_ACT_EXTEND_PROPERTIES IS '流程拓展信息表';
COMMENT ON TABLE SYS_ACT_FUNCTION IS '函数表';
COMMENT ON TABLE SYS_ACT_FUNCTION_PARM IS '函数参数表';
COMMENT ON TABLE SYS_ACT_HI_LINE IS '历史线表';
COMMENT ON TABLE SYS_ACT_INTERFACE_LOG IS '接口日志表';
COMMENT ON TABLE SYS_ACT_MANAGE_LOG IS '操作日志表';
COMMENT ON TABLE SYS_ACT_PROCESS_FILE IS '工作流文件表';
COMMENT ON TABLE SYS_ACT_TIMEOUT_ACTIVITY IS '超时信息表';
COMMENT ON TABLE SYS_ACT_URGE_TASK IS '催办表';