/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.util;

import com.jxdinfo.hussar.bsp.datasource.model.BpmSysDataSource;
import com.jxdinfo.hussar.constant.DatabaseType;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"springContextHolder"})
public class InitTableUtil {
    private static final Map<String, String> DATABASE_DRIVER = new HashMap<String, String>();

    public static void createTable(BpmSysDataSource bpmSysDataSource, String url) throws SQLException, ClassNotFoundException, IOException {
        Connection conn = null;
        InputStream in = null;
        InputStreamReader isr = null;
        if (bpmSysDataSource == null) {
            return;
        }
        try {
            conn = InitTableUtil.getMySqlConnection(bpmSysDataSource);
            ScriptRunner runner = new ScriptRunner(conn);
            Resources.setCharset((Charset)StandardCharsets.UTF_8);
            runner.setLogWriter(null);
            in = InitTableUtil.class.getClassLoader().getResourceAsStream(url.split(":")[1] + ".sql");
            if (in == null) {
                return;
            }
            isr = new InputStreamReader(in, StandardCharsets.UTF_8);
            runner.runScript((Reader)isr);
            runner.closeConnection();
            isr.close();
            in.close();
            conn.close();
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw e;
        }
        finally {
            if (isr != null) {
                isr.close();
            }
            if (in != null) {
                in.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static Connection getMySqlConnection(BpmSysDataSource bpmSysDataSource) throws SQLException, ClassNotFoundException {
        String decryptUrl = bpmSysDataSource.getJdbcUrl();
        String dbType = decryptUrl.split(":")[1];
        Class.forName(DATABASE_DRIVER.get(dbType));
        String name = bpmSysDataSource.getUserName();
        String pass = bpmSysDataSource.getPassword();
        if ("mysql".equals(dbType) || "oracle".equals(dbType) || "dm".equals(dbType) || "oscar".equals(dbType)) {
            return DriverManager.getConnection(decryptUrl, name, pass);
        }
        return null;
    }

    public static String getUrlByIpAndPort(String ip, String port, String dbName, String dbType) throws SQLException, ClassNotFoundException {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{ip, port})) {
            return null;
        }
        if ("Mysql".equals(dbType)) {
            return DatabaseType.MYSQL.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.MYSQL.getSuffix();
        }
        if ("Oracle".equals(dbType)) {
            return DatabaseType.ORACLE.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.ORACLE.getSuffix();
        }
        if ("Dm".equals(dbType)) {
            return DatabaseType.DM.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.DM.getSuffix();
        }
        if ("Oscar".equals(dbType)) {
            return DatabaseType.OSCAR.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.OSCAR.getSuffix();
        }
        return null;
    }

    public static String getDriverByDbType(String dbType) {
        return DATABASE_DRIVER.get(dbType);
    }

    static {
        DATABASE_DRIVER.put("mysql", "com.mysql.cj.jdbc.Driver");
        DATABASE_DRIVER.put("oracle", "oracle.jdbc.OracleDriver");
        DATABASE_DRIVER.put("dm", "dm.jdbc.driver.DmDriver");
        DATABASE_DRIVER.put("oscar", "com.oscar.Driver");
    }
}

