/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.mutidatasource;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.datasource.model.BpmSysDataSource;
import com.jxdinfo.hussar.bsp.datasource.service.BpmSysDataSourceService;
import com.jxdinfo.hussar.common.annotion.DynamicDS;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class DynamicDataSourceInterceptor
implements MethodInterceptor {
    private static final DruidProperties druidProperties = (DruidProperties)SpringContextHolder.getBean(DruidProperties.class);
    private static final BpmSysDataSourceService bpmSysDataSourceService = (BpmSysDataSourceService)SpringContextHolder.getBean(BpmSysDataSourceService.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        DynamicDS dynamicDS = methodInvocation.getMethod().getAnnotation(DynamicDS.class);
        if (dynamicDS != null) {
            if (!dynamicDS.isIntercept()) {
                return methodInvocation.proceed();
            }
            String connName = dynamicDS.value();
            if (ToolUtil.isEmpty((Object)connName)) {
                return this.invokeByCurrentTenant(methodInvocation);
            }
            return this.changeDataSource(methodInvocation, connName);
        }
        return this.invokeByCurrentTenant(methodInvocation);
    }

    private Object invokeByCurrentTenant(MethodInvocation methodInvocation) throws Throwable {
        ShiroUser shiroUser;
        try {
            shiroUser = BaseShiroKit.getUser();
        }
        catch (Exception e) {
            shiroUser = null;
        }
        if (ToolUtil.isEmpty((Object)shiroUser)) {
            return methodInvocation.proceed();
        }
        if ("superadmin".equals(shiroUser.getId())) {
            return methodInvocation.proceed();
        }
        return this.changeDataSource(methodInvocation, shiroUser.getConnName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object changeDataSource(MethodInvocation methodInvocation, String connName) throws Throwable {
        boolean flag = true;
        try {
            if (ToolUtil.isEmpty((Object)DataSourceUtil.getDataSource((String)connName))) {
                flag = false;
            }
        }
        catch (RuntimeException e) {
            flag = false;
        }
        if (!flag) {
            BpmSysDataSource bpmSysDataSource = (BpmSysDataSource)bpmSysDataSourceService.getOne((Wrapper)new QueryWrapper().eq((Object)"CONN_NAME", (Object)connName));
            DataSourceProperty property = new DataSourceProperty();
            property.setDruid(druidProperties.getDruid());
            property.setPoolName(connName);
            property.setDriverClassName(bpmSysDataSource.getDriverClass());
            property.setUrl(bpmSysDataSource.getJdbcUrl());
            property.setUsername(bpmSysDataSource.getUserName());
            property.setPassword(bpmSysDataSource.getPassword());
            DataSourceUtil.addDataSource((DataSourceProperty)property);
        }
        try {
            DataSourceUtil.changeTempDs((String)connName);
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            DataSourceUtil.poll();
        }
    }
}

