/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.mutidatasource;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.YmlDynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.jxdinfo.hussar.common.annotion.DynamicDS;
import com.jxdinfo.hussar.core.mutidatasource.DynamicDataSourceInterceptor;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@DependsOn(value={"springContextHolder"})
public class DataSourceConfig {
    @Resource
    private DynamicDataSourceProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        Map datasourceMap = this.properties.getDatasource();
        return new YmlDynamicDataSourceProvider(datasourceMap);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource(DynamicDataSourceProvider dynamicDataSourceProvider) {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(this.properties.getPrimary());
        dataSource.setStrict(Boolean.valueOf(true));
        dataSource.setStrategy(this.properties.getStrategy());
        dataSource.setProvider(dynamicDataSourceProvider);
        dataSource.setP6spy(this.properties.getP6spy());
        dataSource.setSeata(this.properties.getSeata());
        return dataSource;
    }

    @Bean
    public DefaultPointcutAdvisor defaultPointcutAdvisor() {
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("com.jxdinfo.hussar.bpm.*.controller.*Controller.*");
        patterns.add("com.jxdinfo.hussar.bsp.*.controller.*Controller.*");
        patterns.add("com.jxdinfo.hussar.system.controller.*Controller.*");
        patterns.add("com.jxdinfo.hussar.engine.*Controller.*");
        patterns.add("com.jxdinfo.hussar.core.license.controller.LicenseController.*");
        JdkRegexpMethodPointcut pointcut = new JdkRegexpMethodPointcut();
        if (patterns.size() > 0) {
            pointcut.setPatterns(patterns.toArray(new String[0]));
        }
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)new DynamicDataSourceInterceptor());
        return advisor;
    }

    @Bean
    public DefaultPointcutAdvisor defaultPointcutAdvisorWithAnnotation() {
        AnnotationMatchingPointcut pointcut = new AnnotationMatchingPointcut(null, DynamicDS.class);
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)new DynamicDataSourceInterceptor());
        return advisor;
    }
}

