/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config;

import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement(order=2)
@MapperScan(value={"com.jxdinfo.hussar.**.dao"})
public class MybatisPlusConfig {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bean
    public PaginationInterceptor paginationInterceptor(DataSource dataSource) {
        PaginationInterceptor interceptor = new PaginationInterceptor();
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String url = connection.getMetaData().getURL();
            if (url.startsWith("jdbc:oscar")) {
                interceptor.setDialectClazz("com.baomidou.mybatisplus.extension.plugins.pagination.dialects.OracleDialect");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return interceptor;
    }
}

