/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.tenant.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bsp.datasource.model.BpmSysDataSource;
import com.jxdinfo.hussar.bsp.datasource.service.BpmSysDataSourceService;
import com.jxdinfo.hussar.bsp.loginuser.model.BpmSysUserTenant;
import com.jxdinfo.hussar.bsp.loginuser.service.IBpmSysUserTenantService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.bsp.permit.model.BpmSysUsers;
import com.jxdinfo.hussar.bsp.permit.service.IBpmSysUsersService;
import com.jxdinfo.hussar.bsp.tenant.model.BpmSysTenant;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.IBpmSysTenantService;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.common.utils.CryptoUtil;
import com.jxdinfo.hussar.config.datasource.BpmDataSourceUtil;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.constant.BpmEnum;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.encrypt.SM4Encrypt;
import com.jxdinfo.hussar.core.util.HussarBpmSM4Util;
import com.jxdinfo.hussar.core.util.InitTableUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.response.ApiResponse;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
public class TenantController {
    @Autowired
    ISysUserService sysUserService;
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    ITenantConfigService tenantConfigService;
    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private IBpmSysUsersService sysUsersService;
    @Autowired
    private IBpmSysTenantService sysTenantService;
    @Autowired
    private IBpmSysUserTenantService sysUserTenantService;
    @Autowired
    private BpmSysDataSourceService bpmSysDataSourceService;
    private final String SYNCHRONIZATION_MODEL = "allDataSynchronization.xls";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/tenantQuery"})
    @ManageBusinessLog(key="/tenant/tenantQuery", value="\u67e5\u8be2\u79df\u6237\u7ba1\u7406\u5217\u8868", type="\u67e5\u8be2")
    public ApiResponse<Map<String, Object>> queryTenantList(@RequestParam(required=false) String userName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            Map map = this.sysUserService.queryTenantList(userName, page, limit);
            ApiResponse apiResponse = ApiResponse.data((Object)map);
            return apiResponse;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/tenantUpdate"})
    @ManageBusinessLog(key="/tenant/tenantUpdate", value="\u4fee\u6539\u8d26\u53f7\u548c\u540d\u79f0", type="\u4fee\u6539")
    public ApiResponse<?> tenantUpdate(BpmSysUsers sysUser) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"USER_ACCOUNT", (Object)sysUser.getUserAccount());
            queryWrapper.ne((Object)"USER_NAME", (Object)sysUser.getUserName());
            queryWrapper.ne((Object)"ACCOUNT_STATUS", (Object)"2");
            ((QueryWrapper)queryWrapper.or()).and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"USER_NAME", (Object)sysUser.getUserName())).ne((Object)"USER_ACCOUNT", (Object)sysUser.getUserAccount())).ne((Object)"ACCOUNT_STATUS", (Object)"2");
            });
            List bpmSysUsersList = this.sysUsersService.list((Wrapper)queryWrapper);
            for (BpmSysUsers bpmSysUsers : bpmSysUsersList) {
                if (sysUser.getUserAccount().equals(bpmSysUsers.getUserAccount())) {
                    ApiResponse apiResponse = ApiResponse.fail((int)BpmEnum.ERROR_EXIST_USER_ACCOUNT.getCode(), (String)BpmEnum.ERROR_EXIST_USER_ACCOUNT.getMessage());
                    return apiResponse;
                }
                if (!sysUser.getUserName().equals(bpmSysUsers.getUserName())) continue;
                ApiResponse apiResponse = ApiResponse.fail((int)BpmEnum.ERROR_EXIST_USERNAME.getCode(), (String)BpmEnum.ERROR_EXIST_USERNAME.getMessage());
                return apiResponse;
            }
            this.sysUsersService.saveOrUpdate((Object)sysUser);
            ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/tenantGetInf"})
    @ManageBusinessLog(key="/tenant/tenantGetInf", value="\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f", type="\u67e5\u8be2")
    public ApiResponse<SysUser> tenantGetInf(SysUser sysUser) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            String url = this.druidProperties.getUrl();
            String dbType = url.split(":")[1];
            dbType = dbType.substring(0, 1).toUpperCase() + dbType.substring(1);
            sysUser.setDbType(HussarBpmSM4Util.encrypt((String)dbType, (String)"frontkey"));
            if ("Oscar".equals(dbType) || "Dm".equals(dbType)) {
                sysUser.setDbName(HussarBpmSM4Util.encrypt((String)url.split("/")[3], (String)"frontkey"));
                sysUser.setConnectionIp(HussarBpmSM4Util.encrypt((String)url.split("/")[2].split(":")[0], (String)"frontkey"));
                sysUser.setConnectionPort(HussarBpmSM4Util.encrypt((String)url.split("/")[2].split(":")[1], (String)"frontkey"));
            } else if ("Oracle".equals(dbType)) {
                sysUser.setDbName(HussarBpmSM4Util.encrypt((String)url.split("/")[1], (String)"frontkey"));
                sysUser.setConnectionIp(HussarBpmSM4Util.encrypt((String)url.split(":")[3].split("@")[1], (String)"frontkey"));
                sysUser.setConnectionPort(HussarBpmSM4Util.encrypt((String)url.split(":")[4].split("/")[0], (String)"frontkey"));
            } else {
                sysUser.setDbName(HussarBpmSM4Util.encrypt((String)"", (String)"frontkey"));
                sysUser.setConnectionIp(HussarBpmSM4Util.encrypt((String)url.split("/")[2].split(":")[0], (String)"frontkey"));
                sysUser.setConnectionPort(HussarBpmSM4Util.encrypt((String)url.split("/")[2].split(":")[1], (String)"frontkey"));
            }
            ApiResponse apiResponse = ApiResponse.data((Object)sysUser);
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.fail((int)BpmEnum.CONNECTION_FAIL.getCode(), (String)BpmEnum.CONNECTION_FAIL.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/tenantInsert"})
    @ManageBusinessLog(key="/tenant/tenantInsert", value="\u65b0\u589e\u79df\u6237", type="\u65b0\u589e")
    public ApiResponse<?> tenantInsert(SysUser sysUser) {
        BpmSysUsers bpmSysUsers = new BpmSysUsers();
        BpmSysDataSource bpmSysDataSource = new BpmSysDataSource();
        BpmSysTenant bpmSysTenant = new BpmSysTenant();
        BpmSysUserTenant bpmSysUserTenant = new BpmSysUserTenant();
        try {
            BpmSysUsers selectSysUser2;
            DataSourceUtil.changeTempDs((String)"master");
            String decryptDbName = HussarBpmSM4Util.decrypt((String)sysUser.getDbName(), (String)"frontkey");
            String decryptConnectionIp = HussarBpmSM4Util.decrypt((String)sysUser.getConnectionIp(), (String)"frontkey");
            String decryptConnectionPort = HussarBpmSM4Util.decrypt((String)sysUser.getConnectionPort(), (String)"frontkey");
            String decryptConnectionName = HussarBpmSM4Util.decrypt((String)sysUser.getConnectionName(), (String)"frontkey");
            String decryptConnectionPass = HussarBpmSM4Util.decrypt((String)sysUser.getConnectionPass(), (String)"frontkey");
            bpmSysDataSource.setDbName(decryptDbName);
            bpmSysDataSource.setUserName(decryptConnectionName);
            bpmSysDataSource.setPassword(decryptConnectionPass);
            bpmSysUsers.setUserId(sysUser.getUserId());
            bpmSysUsers.setUserAccount(sysUser.getUserAccount());
            bpmSysUsers.setUserName(sysUser.getUserName());
            if ("Mysql".equals(sysUser.getDbType())) {
                bpmSysDataSource.setDbName(decryptDbName.toLowerCase());
            } else if ("Oracle".equals(sysUser.getDbType()) || "Dm".equals(sysUser.getDbType()) || "Oscar".equals(sysUser.getDbType())) {
                bpmSysDataSource.setUserName(decryptConnectionName.toUpperCase());
                bpmSysDataSource.setPassword(decryptConnectionPass.toUpperCase());
            }
            String jdbcUrl = InitTableUtil.getUrlByIpAndPort(decryptConnectionIp, decryptConnectionPort, bpmSysDataSource.getDbName(), sysUser.getDbType());
            bpmSysDataSource.setJdbcUrl(jdbcUrl);
            boolean userExist = false;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"USER_ACCOUNT", (Object)bpmSysUsers.getUserAccount());
            queryWrapper.ne((Object)"ACCOUNT_STATUS", (Object)"2");
            ((QueryWrapper)((QueryWrapper)queryWrapper.or()).eq((Object)"USER_NAME", (Object)bpmSysUsers.getUserName())).ne((Object)"ACCOUNT_STATUS", (Object)"2");
            List sysUserList = this.sysUsersService.list((Wrapper)queryWrapper);
            for (BpmSysUsers selectSysUser2 : sysUserList) {
                if (bpmSysUsers.getUserAccount().equals(selectSysUser2.getUserAccount())) {
                    ApiResponse apiResponse = ApiResponse.fail((int)BpmEnum.ERROR_EXIST_USER_ACCOUNT.getCode(), (String)BpmEnum.ERROR_EXIST_USER_ACCOUNT.getMessage());
                    return apiResponse;
                }
                if (!bpmSysUsers.getUserName().equals(selectSysUser2.getUserName())) continue;
                ApiResponse apiResponse = ApiResponse.fail((int)BpmEnum.ERROR_EXIST_USERNAME.getCode(), (String)BpmEnum.ERROR_EXIST_USERNAME.getMessage());
                return apiResponse;
            }
            if ("Mysql".equals(sysUser.getDbType())) {
                if (this.sysUserService.getMysqlUser(decryptConnectionName)) {
                    userExist = true;
                }
            } else if (this.sysUserService.getOracleUser(decryptConnectionName.toUpperCase())) {
                userExist = true;
            }
            DataSourceUtil.poll();
            bpmSysUsers.setUserId(IdWorker.get32UUID());
            bpmSysUsers.setAccountStatus("1");
            bpmSysUsers.setPassword(SM4Encrypt.encode16((byte[])String.valueOf(this.lcdpBpmProperties.getDefaultPass()).getBytes()));
            bpmSysUsers.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            bpmSysTenant.setTenantId(IdWorker.get32UUID());
            bpmSysTenant.setTenantCipher(IdWorker.get32UUID());
            bpmSysTenant.setTenantCode(bpmSysUsers.getUserAccount());
            bpmSysTenant.setTenantName(bpmSysUsers.getUserName());
            bpmSysUserTenant.setUserId(bpmSysUsers.getUserId());
            bpmSysUserTenant.setTenantCode(bpmSysTenant.getTenantCode());
            bpmSysDataSource.setConnName("tenant" + bpmSysTenant.getTenantCode());
            bpmSysDataSource.setDriverClass(InitTableUtil.getDriverByDbType(sysUser.getDbType().toLowerCase()));
            if ("1".equals(sysUser.getUseOutside())) {
                BpmDataSourceUtil.addDataSourceByDataSource((BpmSysDataSource)bpmSysDataSource);
                try {
                    DataSourceUtil.changeTempDs((String)bpmSysDataSource.getConnName());
                    boolean state = this.sysUserService.testConn(bpmSysDataSource.getConnName());
                    if (!state) {
                        selectSysUser2 = ApiResponse.fail((int)BpmEnum.OUTSIDE_CONNECTION_FAIL.getCode(), (String)BpmEnum.OUTSIDE_CONNECTION_FAIL.getMessage());
                        return selectSysUser2;
                    }
                    InitTableUtil.createTable(bpmSysDataSource, this.druidProperties.getUrl());
                }
                finally {
                    DataSourceUtil.poll();
                }
            }
            if (userExist) {
                try {
                    BpmDataSourceUtil.addDataSourceByDataSource((BpmSysDataSource)bpmSysDataSource);
                    DataSourceUtil.changeTempDs((String)bpmSysDataSource.getConnName());
                    boolean state = this.sysUserService.testConn(bpmSysDataSource.getConnName());
                    if (!state) {
                        selectSysUser2 = ApiResponse.fail((int)BpmEnum.USER_CONNECTION_FAIL.getCode(), (String)BpmEnum.USER_CONNECTION_FAIL.getMessage());
                        return selectSysUser2;
                    }
                    ApiResponse str = this.sysUserService.createDatabase(decryptDbName, decryptConnectionName, decryptConnectionPass, userExist, this.druidProperties.getUrl());
                    if (str != null) {
                        ApiResponse apiResponse = str;
                        return apiResponse;
                    }
                    InitTableUtil.createTable(bpmSysDataSource, this.druidProperties.getUrl());
                }
                finally {
                    DataSourceUtil.poll();
                }
            }
            DataSourceUtil.changeTempDs((String)"master");
            this.bpmSysDataSourceService.save((Object)bpmSysDataSource);
            this.sysUsersService.save((Object)bpmSysUsers);
            bpmSysTenant.setDbId(bpmSysDataSource.getDbId());
            this.sysTenantService.save((Object)bpmSysTenant);
            this.sysUserTenantService.save((Object)bpmSysUserTenant);
            ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.SUCCESS_INSERT.getCode(), (String)BpmEnum.SUCCESS_INSERT.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            ApiResponse apiResponse = ApiResponse.fail((int)BpmEnum.ERROR_INSERT.getCode(), (String)BpmEnum.ERROR_INSERT.getMessage());
            return apiResponse;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    @RequestMapping(value={"/tenantDelete"})
    @ManageBusinessLog(key="/tenant/tenantDelete", value="\u5220\u9664\u79df\u6237", type="\u5220\u9664")
    public ApiResponse<?> tenantDelete(String userId) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            this.sysUsersService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"USER_ID", (Object)userId)).set((Object)"ACCOUNT_STATUS", (Object)"2"));
            ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.DELETE_SUCCESS.getCode(), (String)BpmEnum.DELETE_SUCCESS.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.fail((int)BpmEnum.DELETE_FAIL.getCode(), (String)BpmEnum.DELETE_FAIL.getMessage());
    }

    @RequestMapping(value={"/tenantReset"})
    @ManageBusinessLog(key="/tenant/tenantReset", value="\u91cd\u7f6e\u5bc6\u7801", type="\u4fee\u6539")
    public ApiResponse<?> tenantReset(SysUser sysUser) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            this.sysUsersService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"USER_ID", (Object)sysUser.getUserId())).set((Object)"PASSWORD", (Object)SM4Encrypt.encode16((byte[])String.valueOf(CryptoUtil.decode(sysUser.getPassword())).getBytes())));
            ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.SUCCESS_RESET.getCode(), (String)BpmEnum.SUCCESS_RESET.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_RESET.getCode(), (String)BpmEnum.ERROR_RESET.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/editPwd"})
    @ManageBusinessLog(key="/tenant/editPwd", value="\u4fee\u6539\u767b\u5f55\u8d26\u6237\u7684\u5bc6\u7801", type="\u4fee\u6539")
    public ApiResponse<?> editPwd(@RequestParam(value="oldPwd", required=false) String oldPwd, @RequestParam(value="newPwd") String newPwd) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            BpmSysUsers bpmSysUsers = (BpmSysUsers)this.sysUsersService.getOne((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)BaseShiroKit.getUser().getId()));
            if (!bpmSysUsers.getPassword().equals(SM4Encrypt.encode16((byte[])String.valueOf(CryptoUtil.decode(oldPwd)).getBytes()))) {
                ApiResponse apiResponse = ApiResponse.fail((int)BpmEnum.ERROR_OLD_PASSWORD.getCode(), (String)BpmEnum.ERROR_OLD_PASSWORD.getMessage());
                return apiResponse;
            }
            bpmSysUsers.setPassword(SM4Encrypt.encode16((byte[])String.valueOf(CryptoUtil.decode(newPwd)).getBytes()));
            this.sysUsersService.saveOrUpdate((Object)bpmSysUsers);
            ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
    }

    @RequestMapping(value={"/editUserConfig"})
    @ManageBusinessLog(key="/tenant/editUserConfig", value="\u4fee\u6539\u767b\u5f55\u8d26\u6237\u7684\u9879\u76ee\u914d\u7f6e", type="\u4fee\u6539")
    public ApiResponse<?> editUserConfig(String isMqUse, String address, String isGodAxe, String isMultiTenant) {
        try {
            TenantConfig tenantConfig = new TenantConfig();
            tenantConfig.setProjectAddress(address);
            tenantConfig.setIsMultiTenant(isMultiTenant);
            tenantConfig.setIsMqUse(isMqUse);
            tenantConfig.setIsGodAxe(isGodAxe);
            ShiroUser shiroUser = BaseShiroKit.getUser();
            tenantConfig.setTenantId(shiroUser.getTenantId());
            this.tenantConfigService.editTenantConfig(tenantConfig);
            return ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
        }
    }

    @RequestMapping(value={"/getUserAddress"})
    @ManageBusinessLog(key="/tenant/getUserAddress", value="\u67e5\u8be2\u5bf9\u5e94\u8d26\u53f7\u7684\u9879\u76ee\u5730\u5740", type="\u67e5\u8be2")
    public ApiResponse<?> getUserAddress() {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(BaseShiroKit.getUser().getTenantId());
        if (tenantConfig == null) {
            return ApiResponse.data(null);
        }
        return ApiResponse.data((Object)tenantConfig.getProjectAddress());
    }

    @RequestMapping(value={"/getUserConfig"})
    @ManageBusinessLog(key="/tenant/getUserConfig", value="\u67e5\u8be2\u5bf9\u5e94\u8d26\u53f7\u7684\u914d\u7f6e\u4fe1\u606f", type="\u67e5\u8be2")
    public ApiResponse<?> getUserConfig() {
        ShiroUser shiroUser = BaseShiroKit.getUser();
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(shiroUser.getTenantId());
        return ApiResponse.data((Object)tenantConfig);
    }

    @RequestMapping(value={"/startUsing"})
    @ManageBusinessLog(key="/tenant/startUsing", value="\u542f\u7528", type="\u542f\u7528")
    public ApiResponse<?> startUsing(BpmSysUsers bpmSysUsers) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            bpmSysUsers.setAccountStatus("1");
            this.sysUsersService.updateById((Object)bpmSysUsers);
            ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.SUCCESS_START.getCode(), (String)BpmEnum.SUCCESS_START.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_START.getCode(), (String)BpmEnum.ERROR_START.getMessage());
    }

    @RequestMapping(value={"/stopUsing"})
    @ManageBusinessLog(key="/tenant/stopUsing", value="\u7981\u7528", type="\u7981\u7528")
    public ApiResponse<?> stopUsing(BpmSysUsers bpmSysUsers) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            bpmSysUsers.setAccountStatus("0");
            this.sysUsersService.updateById((Object)bpmSysUsers);
            ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.SUCCESS_STOP.getCode(), (String)BpmEnum.SUCCESS_STOP.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_STOP.getCode(), (String)BpmEnum.ERROR_STOP.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/personalQuery"})
    @ManageBusinessLog(key="/tenant/personalQuery", value="\u67e5\u8be2", type="\u67e5\u8be2")
    public ApiResponse<SysUser> getPersonalMsg() {
        if (BaseShiroKit.getUser() == null) {
            return ApiResponse.fail((int)BpmEnum.ERROR_LOGIN.getCode(), (String)BpmEnum.ERROR_LOGIN.getMessage());
        }
        try {
            DataSourceUtil.changeTempDs((String)"master");
            String userId = BaseShiroKit.getUser().getId();
            SysUser sysUser = this.sysUserService.querySysUserByUserId(userId);
            String jdbcUrl = sysUser.getJdbcUrl();
            sysUser.setDbType(jdbcUrl.split(":")[1]);
            sysUser.setJdbcUrl(HussarBpmSM4Util.encrypt((String)jdbcUrl, (String)"frontkey"));
            sysUser.setConnectionName(HussarBpmSM4Util.encrypt((String)sysUser.getConnectionName(), (String)"frontkey"));
            sysUser.setConnectionPass(HussarBpmSM4Util.encrypt((String)sysUser.getConnectionPass(), (String)"frontkey"));
            ApiResponse apiResponse = ApiResponse.data((Object)sysUser);
            return apiResponse;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/resetCipher"})
    @ManageBusinessLog(key="/tenant/resetCipher", value="\u91cd\u7f6e\u79d8\u94a5", type="\u91cd\u7f6e\u5bc6\u7801")
    public ApiResponse<BpmSysTenant> resetCipher(BpmSysTenant sysTenant) {
        if (BaseShiroKit.getUser() == null) {
            return ApiResponse.fail((int)BpmEnum.ERROR_LOGIN.getCode(), (String)BpmEnum.ERROR_LOGIN.getMessage());
        }
        try {
            DataSourceUtil.changeTempDs((String)"master");
            ShiroUser shiroUser = BaseShiroKit.getUser();
            sysTenant.setTenantId(shiroUser.getTenantId());
            sysTenant.setTenantCipher(IdWorker.get32UUID());
            this.sysTenantService.saveOrUpdate((Object)sysTenant);
            ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.SUCCESS_RESET.getCode(), (String)BpmEnum.SUCCESS_RESET.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_RESET.getCode(), (String)BpmEnum.ERROR_RESET.getMessage());
    }

    @RequestMapping(value={"/getModel"})
    @ManageBusinessLog(key="/tenant/getModel", value="\u4e0b\u8f7d\u5168\u91cf\u6570\u636e\u540c\u6b65\u6a21\u677f", type="\u4e0b\u8f7d")
    public void getModel(HttpServletResponse response) {
        try {
            InputStream in = TenantController.class.getClassLoader().getResourceAsStream("allDataSynchronization.xls");
            this.sysUserService.getModel(in, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/editDbMessage"})
    @ManageBusinessLog(key="/tenant/editDbMessage", value="\u4fee\u6539\u6570\u636e\u5e93\u4fe1\u606f", type="\u4fee\u6539")
    public ApiResponse<SysUser> editDbMessage(SysUser sysUser) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            BpmSysDataSource bpmSysDataSource = this.sysUserService.querySysDataSourceByUserId(sysUser.getUserId());
            bpmSysDataSource.setUserName(HussarBpmSM4Util.decrypt((String)sysUser.getConnectionName(), (String)"frontkey"));
            bpmSysDataSource.setPassword(HussarBpmSM4Util.decrypt((String)sysUser.getConnectionPass(), (String)"frontkey"));
            bpmSysDataSource.setJdbcUrl(HussarBpmSM4Util.decrypt((String)sysUser.getJdbcUrl(), (String)"frontkey"));
            if (ToolUtil.isNotEmpty((Object)sysUser.getDbName())) {
                bpmSysDataSource.setDbName(HussarBpmSM4Util.decrypt((String)sysUser.getDbName(), (String)"frontkey"));
            }
            if (this.sysUserService.updateDbMessage(bpmSysDataSource)) {
                ApiResponse apiResponse = ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
                return apiResponse;
            }
            ApiResponse apiResponse = ApiResponse.fail((int)BpmEnum.CONNECTION_FAIL.getCode(), (String)BpmEnum.CONNECTION_FAIL.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            ApiResponse apiResponse = ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
            return apiResponse;
        }
        finally {
            DataSourceUtil.poll();
        }
    }
}

