/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.mutidatasource.interceptor;

import com.jxdinfo.hussar.bsp.exception.BpmTenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TenantDataSourceInterceptor
implements HandlerInterceptor {
    ISysUserService iSysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String tenantId = request.getParameter("tenantId");
        String tenantCipher = request.getParameter("tenantCipher");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{tenantId, tenantCipher})) {
            throw new TenantLackInfoException();
        }
        SysUser sysUser = this.iSysUserService.querySysUserByTenantId(tenantId, tenantCipher);
        if (sysUser == null) {
            throw new BpmTenantException();
        }
        if ("0".equals(sysUser.getAccountStatus())) {
            throw new TenantLockException();
        }
        DataSourceUtil.changeTempDs((String)sysUser.getConnName());
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) {
        DataSourceUtil.poll();
    }
}

