/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.response.BpmResponseResult;
import com.jxdinfo.hussar.tenant.dao.SysActConfigMapper;
import com.jxdinfo.hussar.tenant.model.SysActConfig;
import com.jxdinfo.hussar.util.BpmConfigReadService;
import com.jxdinfo.hussar.util.BpmSpringContextHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TenantService {
    private static final String TENANT = "/tenant/";
    private static final SysActConfigMapper sysActConfigMapper = BpmSpringContextHolder.getBean(SysActConfigMapper.class);
    private static final BpmConfigReadService bpmConfigReadService = BpmSpringContextHolder.getBean(BpmConfigReadService.class);

    public static BpmResponseResult tenantInsertReturnInfo(String userAccount, String userName, String dbType, String dbName, String connectionIp, String connectionPort, String connectionName, String connectionPass) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userAccount", userAccount);
        map.put("userName", userName);
        map.put("dbType", dbType);
        map.put("dbName", dbName);
        map.put("connectionIp", connectionIp);
        map.put("connectionPort", connectionPort);
        map.put("connectionName", connectionName);
        map.put("connectionPass", connectionPass);
        return TenantService.execute(map, "tenantInsertReturnInfo");
    }

    public static BpmResponseResult deleteTenantList(List<Map<String, String>> tenantList) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("tenant", JSONObject.toJSONString(tenantList));
        return TenantService.execute(map, "deleteTenantList");
    }

    public static int insertSysActConfig(String tenantId, String address) {
        SysActConfig sysActConfig = new SysActConfig();
        sysActConfig.setTenantId(tenantId);
        sysActConfig.setIsGodAxe("1");
        sysActConfig.setIsMqUse("0");
        sysActConfig.setIsMultiTenant("1");
        sysActConfig.setProjectAddress(address);
        return sysActConfigMapper.insert((Object)sysActConfig);
    }

    private static BpmResponseResult execute(Map<String, Object> map, String url) {
        String tenantId = bpmConfigReadService.getTempTenantId();
        String tenantCipher = bpmConfigReadService.getTempTenantCipher();
        if ("master".equals(tenantId)) {
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            if (map != null) {
                newMap.putAll(map);
            }
            newMap.put("tenantId", tenantId);
            newMap.put("tenantCipher", tenantCipher);
            String finalUrl = bpmConfigReadService.getUrl() + TENANT + url;
            String result = HttpUtil.get((String)finalUrl, newMap);
            return (BpmResponseResult)JSON.parseObject((String)result, BpmResponseResult.class);
        }
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        bpmResponseResult.setCode("0");
        bpmResponseResult.setMsg("\u5f53\u524d\u79df\u6237\u6743\u9650\u4e0d\u8db3\uff01");
        return bpmResponseResult;
    }
}

