/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.processdiagram;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.util.BpmConfigRead;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hussarBpmDiagram"})
public class HussarBpmDiagramController {
    private static final String HUSSAR_BPM_DIAGRAM = "/flowChart/";
    private static Logger LOGGER = LogManager.getLogger(HussarBpmDiagramController.class);

    @RequestMapping(value={"/processdisplay"})
    public String processpicTab(Model model, HttpServletRequest request) {
        model.addAttribute("processId", (Object)request.getParameter("processInstId"));
        model.addAttribute("contextPath", (Object)request.getContextPath());
        return "/hussar/bpm/processdisplay.html";
    }

    @RequestMapping(value={"/subProcessDisplay"})
    public String subProcessDisplay(Model model, HttpServletRequest request) {
        model.addAttribute("processId", (Object)request.getParameter("processInstId"));
        model.addAttribute("contextPath", (Object)request.getContextPath());
        return "/hussar/bpm/subProcessDisplay.html";
    }

    @RequestMapping(value={"/historyList"})
    @ResponseBody
    public Map<String, Object> historyList(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("processInstanceId", processInstanceId);
        return (Map)JSON.parseObject((String)HussarBpmDiagramController.execute(map, "historyList"), Map.class);
    }

    @RequestMapping(value={"/getProcessDetail"})
    @ResponseBody
    public Map<String, Object> getProcessDetail(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("processInstanceId", processInstanceId);
        return (Map)JSON.parseObject((String)HussarBpmDiagramController.execute(map, "getProcessDetail"), Map.class);
    }

    @RequestMapping(value={"/getProcessCompleteDetail"})
    @ResponseBody
    public JSONArray getProcessCompleteDetail(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("processInstanceId", processInstanceId);
        return JSON.parseArray((String)HussarBpmDiagramController.execute(map, "getProcessCompleteDetail"));
    }

    @RequestMapping(value={"/subProcessList"})
    @ResponseBody
    public Map<String, Object> subProcessList(String supProcessInstId, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="9999") Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supProcessInstId", supProcessInstId);
        map.put("page", page);
        map.put("limit", limit);
        return (Map)JSON.parseObject((String)HussarBpmDiagramController.execute(map, "subProcessList"), Map.class);
    }

    private static String execute(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + HUSSAR_BPM_DIAGRAM + url;
        LOGGER.info("flowChart\u529f\u80fd\u5f00\u59cb");
        System.out.println("flowChart\u529f\u80fd\u5f00\u59cb");
        LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + finalUrl);
        LOGGER.info("\u53c2\u6570\u4fe1\u606f\uff1a" + JSON.toJSONString(map));
        System.out.println("\u8def\u5f84\u4fe1\u606f" + finalUrl);
        Long start = System.currentTimeMillis();
        String result = HttpUtil.get((String)finalUrl, map, (int)bpmConfigRead.getHttpClientTimeOut());
        Long end = System.currentTimeMillis();
        LOGGER.info("flowChart\u529f\u80fd\u7ed3\u675f");
        System.out.println("flowChart\u529f\u80fd\u7ed3\u675f");
        LOGGER.info("flowChart\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        System.out.println("flowChart\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        return result;
    }
}

