/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.concern;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.response.BpmResponseResult;
import com.jxdinfo.hussar.util.BpmConfigRead;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/concern"})
public class ConcernController {
    private static final String CONCERN = "/concern/";
    private static Logger LOGGER = LogManager.getLogger(ConcernController.class);

    @RequestMapping(value={"/save"})
    public Object addConcern(@RequestBody Map<String, Object> body) {
        BpmResponseResult result;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("procInstId", body.get("processInsId"));
        map.put("follower", body.get("userId"));
        try {
            result = ConcernController.execute(map, "saveConcern");
        }
        catch (IORuntimeException c) {
            BpmResponseResult bpmResponseResult = new BpmResponseResult();
            bpmResponseResult.setCode("-1");
            return bpmResponseResult;
        }
        return result;
    }

    @RequestMapping(value={"/delete"})
    public Object deleteConcern(@RequestBody Map<String, Object> body) {
        BpmResponseResult result;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("procInstId", body.get("processInsId"));
        map.put("userId", body.get("userId"));
        try {
            result = ConcernController.execute(map, "deleteConcern");
        }
        catch (IORuntimeException c) {
            BpmResponseResult bpmResponseResult = new BpmResponseResult();
            bpmResponseResult.setCode("-1");
            return bpmResponseResult;
        }
        return result;
    }

    @RequestMapping(value={"/queryConcern"})
    public Object queryConcern(@RequestBody Map<String, Object> body) {
        BpmResponseResult result;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        String definitionKey = body.get("definitionKey") == null ? null : body.get("definitionKey").toString();
        String userId = body.get("userId") == null ? null : body.get("userId").toString();
        String type = body.get("type") == null ? null : body.get("type").toString();
        String startTime = body.get("startTime") == null ? null : body.get("startTime").toString();
        String endTime = body.get("endTime") == null ? null : body.get("endTime").toString();
        String page = body.get("page") == null ? "1" : body.get("page").toString();
        String rows = body.get("size") == null ? "10" : body.get("size").toString();
        map.put("definitionKey", definitionKey);
        map.put("userId", userId);
        map.put("type", type);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("page", page);
        map.put("rows", rows);
        try {
            result = ConcernController.execute(map, "queryConcernList");
        }
        catch (IORuntimeException c) {
            BpmResponseResult bpmResponseResult = new BpmResponseResult();
            bpmResponseResult.setCode("-1");
            return bpmResponseResult;
        }
        return result;
    }

    @RequestMapping(value={"/addBottom"})
    public Object addBottom(@RequestBody Map<String, Object> body) {
        BpmResponseResult result;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("bottomType", body.get("bottomType"));
        map.put("taskId", body.get("taskId"));
        try {
            result = ConcernController.execute(map, "addBottomById");
        }
        catch (IORuntimeException c) {
            BpmResponseResult bpmResponseResult = new BpmResponseResult();
            bpmResponseResult.setCode("-1");
            return bpmResponseResult;
        }
        return result;
    }

    @RequestMapping(value={"/deleteBottom"})
    public Object deleteBottom(@RequestBody Map<String, Object> body) {
        BpmResponseResult result;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("bottomType", body.get("bottomType"));
        map.put("taskId", body.get("taskId"));
        try {
            result = ConcernController.execute(map, "deleteBottomById");
        }
        catch (IORuntimeException c) {
            BpmResponseResult bpmResponseResult = new BpmResponseResult();
            bpmResponseResult.setCode("-1");
            return bpmResponseResult;
        }
        return result;
    }

    private static BpmResponseResult execute(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + CONCERN + url;
        LOGGER.info("\u5173\u6ce8\u76f8\u5173\u529f\u80fd\u5f00\u59cb");
        System.out.println("\u5173\u6ce8\u76f8\u5173\u529f\u80fd\u5f00\u59cb");
        LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + finalUrl);
        LOGGER.info("\u53c2\u6570\u4fe1\u606f\uff1a" + JSON.toJSONString(map));
        System.out.println("\u8def\u5f84\u4fe1\u606f" + finalUrl);
        Long start = System.currentTimeMillis();
        String result = HttpUtil.get((String)finalUrl, map, (int)bpmConfigRead.getHttpClientTimeOut());
        Long end = System.currentTimeMillis();
        LOGGER.info("\u5173\u6ce8\u76f8\u5173\u529f\u80fd\u7ed3\u675f");
        System.out.println("\u5173\u6ce8\u76f8\u5173\u529f\u80fd\u7ed3\u675f");
        LOGGER.info("\u5173\u6ce8\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        System.out.println("\u5173\u6ce8\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        return (BpmResponseResult)JSON.parseObject((String)result, BpmResponseResult.class);
    }
}

