const definitionId = $("#processId").val();
const contextPath = getContextPath();
const svgcontainer = document.getElementById("svg");
const list = document.getElementById("processpicListTable");
let num = 1;
let user = [],
    start = [],
    end = [],
    path = [],
    parallel = [],
    inclusive = [],
    exclusive = [],
    call = [];
const dataRequest = function () {
    $.ajax({
        type: "POST",
        url: contextPath+"/hussarBpmDiagram/getProcessDetail",
        dataType: "json",
        data: {
            processInstanceId: definitionId
        },
        success: function (res) {
            res.data.forEach(function (value, index, array) {
                if (value.type === 'sequenceFlow') {
                    path.push(value);
                } else if (value.type === 'startEvent') {
                    start.push(value)
                } else if (value.type === 'endEvent') {
                    end.push(value)
                } else if (value.type === 'parallelGateway') {
                    parallel.push(value);
                } else if (value.type === 'inclusiveGateway') {
                    inclusive.push(value);
                } else if (value.type === 'exclusiveGateway') {
                    exclusive.push(value);
                } else if (value.type === 'callActivity') {
                    call.push(value);
                } else {
                    user.push(value)
                }
            });
            svgcontainer.style.height = document.documentElement.clientHeight - 400 + 'px';
            drawPath(path, res.width, res.height);
            drawStart(start);
            drawEnd(end);
            drawParallel(parallel);
            drawInclusive(inclusive);
            drawExclusive(exclusive);
            drawCall(call);
            $.ajax({
                type: "POST",
                url: contextPath+"/hussarBpmDiagram/getProcessCompleteDetail",
                dataType: "json",
                data: {
                    processInstanceId: definitionId
                },
                success: function (res) {
                    for (let i = 0; i < user.length; i++) {
                        for (let j = 0; j < res.length; j++) {
                            if (user[i].id === res[j].id) {
                                user[i].pop = res[j];
                            }
                        }
                    }
                    drawUser(user);
                }
            });
        }
    })
};
// 绘制开始
function drawStart(data) {
    data.forEach(function (value, index, array) {
        const startDiv = document.createElement("div");
        startDiv.setAttribute("id", value.id);
        startDiv.setAttribute("class", 'svgDiv');
        startDiv.style.top = value.y + 'px';
        startDiv.style.left = value.x + 'px';
        const startP = document.createElement("p");
        startP.setAttribute("class", 'svgText');
        startP.innerHTML = value.name;
        startP.style.top = value.width + 'px';
        startP.style.left = (value.width / 2 - value.name.length * 6) + 'px';
        const startDivsvgns = "http://www.w3.org/2000/svg";
        const startDivsvger = document.createElementNS(startDivsvgns, "svg");
        startDivsvger.setAttribute("width", value.width);
        startDivsvger.setAttribute("height", value.height);
        startDivsvger.setAttribute("viewBox", "0 0 " + value.width + " " + value.height);
        const startDivg = document.createElementNS(startDivsvgns, "g");
        startDivg.setAttribute("pointer-events", 'fill');
        startDivg.setAttribute("title", value.name);
        startDivg.setAttribute("transform", 'translate(2, 2)');
        const startDivcircle = document.createElementNS(startDivsvgns, "circle");
        startDivcircle.setAttribute("cx", (value.width - 4) / 2);
        startDivcircle.setAttribute("cy", (value.height - 4) / 2);
        startDivcircle.setAttribute("r", (value.width - 4) / 2);
        startDivcircle.setAttribute("stroke", '#27C3B0');
        startDivcircle.setAttribute("fill", '#27C3B0');
        startDivcircle.setAttribute("stroke-width", 2);
        const startDivtriangle = document.createElementNS(startDivsvgns, "path");
        startDivtriangle.setAttribute("d", 'M' + (value.width / 3 + 2) + ' ' + (value.width / 3 - 3) + ' L' + (value
                .width / 3 + 2) +
            ' ' + (value.width / 3 * 2) + ' L' + (value.width / 3 * 2 - 2) + ' ' + (value.width / 2 - 2) + ' z');
        startDivtriangle.setAttribute("stroke", 'none');
        startDivtriangle.setAttribute("fill", '#fff');
        svgcontainer.appendChild(startDiv);
        startDiv.appendChild(startDivsvger);
        startDiv.appendChild(startP);
        startDivsvger.appendChild(startDivg);
        startDivg.appendChild(startDivcircle);
        startDivg.appendChild(startDivtriangle);
    })
}

// 绘制结束
function drawEnd(data) {
    data.forEach(function (value, index, array) {
        const endDiv = document.createElement("div");
        endDiv.setAttribute("id", value.id);
        endDiv.setAttribute("class", 'svgDiv');
        endDiv.style.top = value.y + 'px';
        endDiv.style.left = value.x + 'px';
        const endP = document.createElement("p");
        endP.setAttribute("class", 'svgText');
        endP.innerHTML = value.name;
        endP.style.top = value.width + 'px';
        endP.style.left = (value.width / 2 - value.name.length * 6) + 'px';
        const endDivsvgns = "http://www.w3.org/2000/svg";
        const endDivsvger = document.createElementNS(endDivsvgns, "svg");
        endDivsvger.setAttribute("width", value.width);
        endDivsvger.setAttribute("height", value.height);
        endDivsvger.setAttribute("viewBox", "0 0 " + value.width + " " + value.height);
        const endDivg = document.createElementNS(endDivsvgns, "g");
        endDivg.setAttribute("pointer-events", 'fill');
        endDivg.setAttribute("title", value.name);
        endDivg.setAttribute("transform", 'translate(2, 2)');
        const endDivcircle = document.createElementNS(endDivsvgns, "circle");
        endDivcircle.setAttribute("cx", (value.width - 4) / 2);
        endDivcircle.setAttribute("cy", (value.height - 4) / 2);
        endDivcircle.setAttribute("r", (value.width - 4) / 2);
        endDivcircle.setAttribute("stroke", '#D8D8D8');
        endDivcircle.setAttribute("fill", '#D8D8D8');
        endDivcircle.setAttribute("stroke-width", 2);
        const endDivrect = document.createElementNS(endDivsvgns, "rect");
        endDivrect.setAttribute("x", (value.width - 4) / 3);
        endDivrect.setAttribute("y", (value.height - 4) / 3);
        endDivrect.setAttribute("width", (value.width - 4) / 3);
        endDivrect.setAttribute("height", (value.height - 4) / 3);
        endDivrect.setAttribute("stroke", 'none');
        endDivrect.setAttribute("fill", '#F77E5C');
        svgcontainer.appendChild(endDiv);
        endDiv.appendChild(endDivsvger);
        endDiv.appendChild(endP);
        endDivsvger.appendChild(endDivg);
        endDivg.appendChild(endDivcircle);
        endDivg.appendChild(endDivrect);
    })
}

// 绘制人员
function drawUser(data) {
    data.forEach(function (value, index, array) {
        const userDiv = document.createElement("div");
        userDiv.onclick = function (e) {
            e.stopPropagation();
            dataFilter(this.id);
        };
        if (value.pop) {
            // 显示在下方的详情(down)
            const popDivdown = document.createElement("div");
            popDivdown.setAttribute("class", 'pop-win');
            // 显示在上方的详情(up)
            const popDivup = document.createElement("div");
            popDivup.setAttribute("class", 'pop-win');
            const pop = function(){
                let scrollT = $('#svg').scrollTop();
                const cxd = svgcontainer.getBoundingClientRect().x + value.x - svgcontainer.scrollLeft - value.width / 2;
                const clientWidth = document.documentElement.clientWidth;
                const clientHeight = document.documentElement.clientHeight;
                if (cxd > 0 && cxd < clientWidth) {
                    popDivdown.style.top = svgcontainer.getBoundingClientRect().y + value.y - scrollT +
                        value.height + 10 + 'px';
                    popDivdown.style.left = cxd + 'px';
                    popDivup.style.bottom = clientHeight - svgcontainer.getBoundingClientRect().y - value.y + scrollT +
                        10 + 'px';
                    popDivup.style.left = cxd + 'px';
                } else if (cxd >= clientWidth) {
                    popDivdown.style.bottom = clientHeight - svgcontainer.getBoundingClientRect().y - value.y + scrollT
                        + 10 + 'px';
                    popDivdown.style.left = clientWidth + 'px';
                } else {
                    popDivdown.style.top = svgcontainer.getBoundingClientRect().y + value.y - scrollT + value
                        .height + 10 + 'px';
                    popDivdown.style.left = '225px'
                }
                // 下方显示三角
                const triangleDown = document.createElement("div");
                triangleDown.setAttribute("class", 'triangle-up');
                const listDownTop = svgcontainer.getBoundingClientRect().y + value.y - scrollT + value.height;
                const listLeft = svgcontainer.getBoundingClientRect().x + value.x - svgcontainer.scrollLeft + 10;
                triangleDown.style.top = listDownTop + 'px';
                triangleDown.style.left = listLeft + 'px';
                const triangleDownInside = document.createElement("div");
                triangleDownInside.setAttribute("class", 'triangelup-inside');
                triangleDownInside.style.top = listDownTop + 1 + 'px';
                triangleDownInside.style.left = listLeft + 'px';
                // 上方显示三角
                const triangleUp = document.createElement("div");
                triangleUp.setAttribute("class", 'triangle-down');
                const listUpBottom = clientHeight - svgcontainer.getBoundingClientRect().y - value.y + scrollT;
                triangleUp.style.bottom = listUpBottom + 'px';
                triangleUp.style.left = listLeft + 'px';
                const triangleUpInside = document.createElement("div");
                triangleUpInside.setAttribute("class", 'triangeldown-inside');
                triangleUpInside.style.bottom = listUpBottom + 1 + 'px';
                triangleUpInside.style.left = listLeft + 'px';
                if (value.state === 'finish' && value.pop.completeInfo) {
                    // 非当前状态
                    let inner = '';
                    for (let n = 0; n < value.pop.completeInfo.length; n++) {
                        inner +=
                            "<div class='ul-info'><ul class='ul-body'>" +
                            "<li><span class='list-name'>开始时间：</span><span>" + value.pop.completeInfo[n].startTime +
                            "</span></li>" +
                            "<li><span class='list-name'>结束时间：</span><span>" + value.pop.completeInfo[n].endTime +
                            "</span></li>" +
                            "<li><span class='list-name'>处理人：</span><span>" + value.pop.completeInfo[n].assignee +
                            "</span></li>" +
                            "<li><span class='list-name'>办理意见：</span><span>" + value.pop.completeInfo[n].comments +
                            "</span></li></ul></div>"
                    }
                    popDivdown.innerHTML = inner;
                    popDivdown.appendChild(triangleDown);
                    popDivdown.appendChild(triangleDownInside);
                    popDivup.innerHTML = inner;
                    popDivup.appendChild(triangleUp);
                    popDivup.appendChild(triangleUpInside);
                    userDiv.appendChild(popDivdown);
                    userDiv.appendChild(popDivup);
                } else if (value.state === 'complete') {
                    // 当前状态
                    let inner =
                        "<div class='ul-info'><ul class='ul-body'>" +
                        "<li><span class='list-name'>开始时间：</span><span>" + value.pop.startTime + "</span></li>" +
                        "<li><span class='list-name'>接收人：</span><span>" + value.pop.assignee + "</span></li>" +
                        "</ul>";
                    if (value.pop.completeInfo) {
                        for (let n = 0; n < value.pop.completeInfo.length; n++) {
                            inner +=
                                "<div class='ul-info'><ul class='ul-body'>" +
                                "<li><span class='list-name'>开始时间：</span><span>" + value.pop.completeInfo[n].startTime +
                                "</span></li>" +
                                "<li><span class='list-name'>结束时间：</span><span>" + value.pop.completeInfo[n].endTime +
                                "</span></li>" +
                                "<li><span class='list-name'>处理人：</span><span>" + value.pop.completeInfo[n].assignee +
                                "</span></li>" +
                                "<li><span class='list-name'>办理意见：</span><span>" + value.pop.completeInfo[n].comments +
                                "</span></li></ul></div>"
                        }
                        inner += "</div>";
                    }
                    popDivdown.innerHTML = inner;
                    popDivdown.appendChild(triangleDown);
                    popDivdown.appendChild(triangleDownInside);
                    popDivup.innerHTML = inner;
                    popDivup.appendChild(triangleUp);
                    popDivup.appendChild(triangleUpInside);
                    userDiv.appendChild(popDivdown);
                    userDiv.appendChild(popDivup);
                }
            };
            pop();
            $('#svg').scroll(pop);
            userDiv.onmouseover = function (e) {
                const scroll = $('#svg').scrollTop();
                if (e.y + scroll < (value.y + value.height / 3)) {
                    popDivdown.style.display = 'none';
                    popDivup.style.display = 'block';
                } else {
                    popDivdown.style.display = 'block';
                    popDivup.style.display = 'none';
                }
            };
            userDiv.onmouseleave = function (e) {
                popDivdown.style.display = 'none';
                popDivup.style.display = 'none';
            }
        }
        userDiv.setAttribute("id", value.id);
        userDiv.setAttribute("class", 'svgDiv');
        userDiv.style.top = value.y + 'px';
        userDiv.style.left = value.x + 'px';
        userDiv.style.width = value.width + 'px';
        userDiv.style.height = value.height + 'px';
        const userP = document.createElement("p");
        userP.setAttribute("class", 'svgText');
        userP.innerHTML = value.name;
        userP.style.top = value.height + 2 + 'px';
        userP.style.left = (value.width / 2 - value.name.length *
            6 - 2) + 'px';
        const userDivsvgns = "http://www.w3.org/2000/svg";
        const userDivsvger = document.createElementNS(userDivsvgns, "svg");
        userDivsvger.setAttribute("width", value
            .width);
        userDivsvger.setAttribute("height", value.height);
        userDivsvger.setAttribute("viewBox", "0 0 " +
            value.width + " " + value.height);
        const userDivg = document.createElementNS(userDivsvgns, "g");
        userDivg.setAttribute("pointer-events",
            'fill');
        userDivg.setAttribute("title", value.name);
        userDivg.setAttribute("transform", 'translate(1,1)');
        const userDivrect = document.createElementNS(userDivsvgns, "rect");
        userDivrect.setAttribute("rx",
            5);
        userDivrect.setAttribute("ry", 5);
        userDivrect.setAttribute("width", value.width - 2);
        userDivrect
            .setAttribute("height", value.height - 2);
        userDivrect.setAttribute("stroke-width", 2);
        const userDivimage = document.createElement("img");
        if (value.state === 'finish') {
            userDivimage.setAttribute("src", '/static/hussar/bpm/img/finish.svg');
            userDivimage.setAttribute("class", 'svgImg2');
            userDivrect.setAttribute("stroke", '#27C3B0');
            userDivrect.setAttribute("fill", '#E9F9F7');
        } else if (value.state === 'complete') {
            const userDivimage2 = document.createElement("img");
            const userDivimage3 = document.createElement("img");
            const userDivimage4 = document.createElement("img");
            const userDivimage5 = document.createElement("img");
            const img = [userDivimage, userDivimage2, userDivimage3, userDivimage4, userDivimage5];
            userDivimage.setAttribute("src", '/static/hussar/bpm/img/now1.svg');
            userDivimage2.setAttribute("src", '/static/hussar/bpm/img/now2.svg');
            userDivimage3.setAttribute("src", '/static/hussar/bpm/img/now3.svg');
            userDivimage4.setAttribute("src", '/static/hussar/bpm/img/now4.svg');
            userDivimage5.setAttribute("src", '/static/hussar/bpm/img/now5.svg');
            const ani = setInterval(() => {
                drawAnimation();
            }, 100);
            // 动画
            function drawAnimation() {
                if (num === 5) {
                    num = 0;
                }
                num++;
                for (let i = 0; i < 5; i++) {
                    if (i + 1 === num) {
                        img[i].style.display = 'block';
                    } else {
                        img[i].style.display = 'none';
                    }
                }
            }
            userDivimage.setAttribute("class", 'svgImg1');
            userDivimage2.setAttribute("class", 'svgImg1');
            userDivimage3.setAttribute("class", 'svgImg1');
            userDivimage4.setAttribute("class", 'svgImg1');
            userDivimage5.setAttribute("class", 'svgImg1');
            userDivrect.setAttribute("stroke", '#2794F8');
            userDivrect.setAttribute("fill", 'rgba(39, 148, 248, 0.1)');
            userDiv.appendChild(userDivimage2);
            userDiv.appendChild(userDivimage3);
            userDiv.appendChild(userDivimage4);
            userDiv.appendChild(userDivimage5);
        } else if (value.state === 'revoke') {
            const revokeIcon = document.createElementNS(userDivsvgns, "path");
            revokeIcon.setAttribute("style", "transform: translate(48px, 8px)");
            revokeIcon.setAttribute("fill", "#FFC35D");
            revokeIcon.setAttribute("fill-rule", "nonzero");
            revokeIcon.setAttribute("d",
                "M0.0522114594,2.37243637 C0.0706849244,2.4078658 0.0938951789,2.4435238 0.126342155,2.47026729 L1.96895187,4.23488107 C2.13592358,4.3948849 2.4097098,4.39945645 2.58141829,4.23488107 C2.66371326,4.15793963 2.71016858,4.05208362 2.71016858,3.9415026 C2.71016858,3.83092159 2.66371326,3.72506558 2.58141829,3.64812414 L1.48153661,2.59461313 L5.74677546,2.59461313 C7.06478613,2.59461313 8.13222083,3.61703767 8.13222083,4.87946797 C8.13222083,6.14189826 7.06478613,7.1643228 5.74677546,7.1643228 L1.4074059,7.1643228 C1.29210447,7.163776 1.18131407,7.20752021 1.09947224,7.28590658 C1.01763041,7.36429294 0.971461044,7.47088145 0.971147918,7.5821614 C0.971147918,7.81325266 1.16606665,8 1.4074059,8 L5.74677546,8 C7.54272782,8 9,6.60430937 9,4.88403951 C9,3.16376965 7.54272782,1.76785044 5.74677546,1.76785044 L1.48153661,1.76785044 L2.58141829,0.709996479 C2.74862683,0.549992643 2.75312678,0.287586342 2.58141829,0.123239537 C2.50046727,0.0443708522 2.39021183,0 2.27518508,0 C2.16015833,0 2.0499029,0.0443708522 1.96895187,0.123239537 L0.126342155,1.88328178 C-0.00864871221,2.01212474 -0.0388907751,2.21167829 0.0522114594,2.37243637 Z"
            );
            userDivg.appendChild(revokeIcon);
            userDivimage.setAttribute("src", '/static/hussar/bpm/img/revoke.svg');
            userDivimage.setAttribute("class", 'svgImg2');
            userDivrect.setAttribute("stroke", '#D8D8D8');
            userDivrect.setAttribute("fill", 'rgba(216, 216, 216, 0.1)');
        } else if (value.state === 'suspend') {
            const suspendIcon = document.createElementNS(userDivsvgns, "g");
            suspendIcon.setAttribute("style", "transform: translate(48px, 8px)");
            suspendIcon.setAttribute("fill", "#F77E5C");
            suspendIcon.setAttribute("fill-rule", "nonzero");
            suspendIcon.innerHTML =
                '<path d="M5,9.99421742 C7.75823012,9.99421742 9.99421742,7.75823012 9.99421742,5 C9.99421742,2.24176988 7.75823012,0.00578257812 5,0.00578257812 C2.24176988,0.00578257812 0.00578257813,2.24176988 0.00578257813,5 C0.00578257813,7.75823012 2.24176988,9.99421742 5,9.99421742 L5,9.99421742 Z M5,9.2540478 C2.65105728,9.25191917 0.748389257,7.34637555 0.749807229,4.9974323 C0.751226787,2.64848904 2.65619532,0.745245237 5.0051389,0.74595394 C7.35408248,0.746663038 9.25790285,2.65105632 9.25790285,5 C9.25713629,6.12849931 8.80810639,7.21047369 8.00959466,8.00790098 C7.21108292,8.80532827 6.12849931,9.25288735 5,9.25212027 L5,9.2540478 Z"></path><polygon points="2.18774094 4.61545875 7.81129529 4.61545875 7.81129529 5.38357749 2.18774094 5.38357749"></polygon>'
            userDivg.appendChild(suspendIcon);
            userDivimage.setAttribute("src", '/static/hussar/bpm/img/suspend.svg');
            userDivimage.setAttribute("class", 'svgImg2');
            userDivrect.setAttribute("stroke", '#D8D8D8');
            userDivrect.setAttribute("fill", 'rgba(216, 216, 216, 0.1)');
        } else if (value.state === 'next') {
            userDivimage.setAttribute("src", '/static/hussar/bpm/img/other.svg');
            userDivimage.setAttribute("class", 'svgImg2');
            userDivrect.setAttribute("stroke", '#D8D8D8');
            userDivrect.setAttribute("fill", 'rgba(216, 216, 216, 0.1)');
        } else if (value.state === 'reject') {
            const rejectIcon = document.createElementNS(userDivsvgns, "g");
            rejectIcon.setAttribute("style", "transform: translate(48px, 8px)");
            rejectIcon.setAttribute("fill", "#F77E5C");
            rejectIcon.setAttribute("fill-rule", "nonzero");
            rejectIcon.innerHTML =
                '<path d="M0.139003716,0.810120843 L8.18987916,8.86099628 C8.30976269,8.98087981 8.48449673,9.02769966 8.64826068,8.98381924 C8.81202462,8.93993883 8.93993883,8.81202462 8.98381924,8.64826068 C9.02769966,8.48449673 8.98087981,8.30976269 8.86099628,8.18987916 L0.810120843,0.139003716 C0.690237315,0.0191201884 0.515503266,-0.0276996589 0.351739321,0.0161807579 C0.187975376,0.0600611746 0.0600611746,0.187975376 0.0161807579,0.351739321 C-0.0276996589,0.515503266 0.0191201884,0.690237315 0.139003716,0.810120843 Z"></path><path d="M8.18988803,0.138993229 L0.138993229,8.18988803 C-0.0463310815,8.37521236 -0.0463310755,8.67568244 0.138993242,8.86100676 C0.32431756,9.04633108 0.624787644,9.04633108 0.810111969,8.86100677 L8.86100677,0.810111969 C9.04633108,0.624787644 9.04633108,0.32431756 8.86100676,0.138993242 C8.67568244,-0.0463310755 8.37521236,-0.0463310815 8.18988803,0.138993229 Z"></path>'
            userDivg.appendChild(rejectIcon);
            userDivimage.setAttribute("src", '/static/hussar/bpm/img/reject.svg');
            userDivimage.setAttribute("class", 'svgImg2');
            userDivrect.setAttribute("stroke", '#D8D8D8');
            userDivrect.setAttribute("fill", 'rgba(216, 216, 216, 0.1)');
        }
        userDiv.appendChild(userDivimage);
        svgcontainer.appendChild(userDiv);
        userDiv.appendChild(userDivsvger);
        userDivsvger.appendChild(userDivg);
        userDivg.appendChild(userDivrect);
        userDiv.appendChild(userP);
    })
}

// 绘制连接线
function drawPath(data, width, height) {
    const pathDiv = document.createElement("div");
    pathDiv.setAttribute("id", 'pathSvg');
    pathDiv.setAttribute("class", 'svgDiv');
    pathDiv.style.width = width + 'px';
    pathDiv.style.height = height + 'px';
    pathDiv.style.top = 0;
    pathDiv.style.left = 0;
    const pathDivsvgns = "http://www.w3.org/2000/svg";
    const pathDivsvger = document.createElementNS(pathDivsvgns, "svg");
    pathDivsvger.style.width = width + 'px';
    pathDivsvger.style.height = height + 'px';
    const pathDivdefsActive = document.createElementNS(pathDivsvgns, "defs");
    const markerActive = document.createElementNS(pathDivsvgns, "marker");
    markerActive.setAttribute("id", 'arrowActive');
    markerActive.setAttribute("refX", '8');
    markerActive.setAttribute("refY", '4');
    markerActive.setAttribute("markerUnits", 'userSpaceOnUse');
    markerActive.setAttribute("markerWidth", '8');
    markerActive.setAttribute("markerHeight", '8');
    markerActive.setAttribute("orient", 'auto');
    const pathActive = document.createElementNS(pathDivsvgns, "path");
    pathActive.setAttribute("d", "M 0 1 L 8 4 L 0 7z");
    pathActive.setAttribute("fill", "#27C3B0");
    pathActive.setAttribute("stroke", "#27C3B0");
    pathActive.setAttribute("stroke-linejoin", "round");
    markerActive.appendChild(pathActive);
    pathDivdefsActive.appendChild(markerActive);
    pathDivsvger.appendChild(pathDivdefsActive);
    const pathDivdefsComplete = document.createElementNS(pathDivsvgns, "defs");
    const markerComplete = document.createElementNS(pathDivsvgns, "marker");
    markerComplete.setAttribute("id", 'arrowComplete');
    markerComplete.setAttribute("refX", '8');
    markerComplete.setAttribute("refY", '4');
    markerComplete.setAttribute("markerUnits", 'userSpaceOnUse');
    markerComplete.setAttribute("markerWidth", '8');
    markerComplete.setAttribute("markerHeight", '8');
    markerComplete.setAttribute("orient", 'auto');
    const pathComplete = document.createElementNS(pathDivsvgns, "path");
    pathComplete.setAttribute("d", "M 0 1 L 8 4 L 0 7z");
    pathComplete.setAttribute("fill", "#2794F8");
    pathComplete.setAttribute("stroke", "#2794F8");
    pathComplete.setAttribute("stroke-linejoin", "round");
    markerComplete.appendChild(pathComplete);
    pathDivdefsComplete.appendChild(markerComplete);
    pathDivsvger.appendChild(pathDivdefsComplete);
    const pathDivdefsNormal = document.createElementNS(pathDivsvgns, "defs");
    const markerNormal = document.createElementNS(pathDivsvgns, "marker");
    markerNormal.setAttribute("id", 'arrowNormal');
    markerNormal.setAttribute("refX", '8');
    markerNormal.setAttribute("refY", '4');
    markerNormal.setAttribute("markerUnits", 'userSpaceOnUse');
    markerNormal.setAttribute("markerWidth", '8');
    markerNormal.setAttribute("markerHeight", '8');
    markerNormal.setAttribute("orient", 'auto');
    const pathNormal = document.createElementNS(pathDivsvgns, "path");
    pathNormal.setAttribute("d", "M 0 1 L 8 4 L 0 7z");
    pathNormal.setAttribute("fill", "#E8E8E8");
    pathNormal.setAttribute("stroke", "#E8E8E8");
    pathNormal.setAttribute("stroke-linejoin", "round");
    markerNormal.appendChild(pathNormal);
    pathDivdefsNormal.appendChild(markerNormal);
    pathDivsvger.appendChild(pathDivdefsNormal);
    pathDiv.appendChild(pathDivsvger);
    data.forEach(function (value, index, array) {
        const pathDivg = document.createElementNS(pathDivsvgns, "g");
        const pathDivtext = document.createElementNS(pathDivsvgns, "text");
        pathDivtext.setAttribute("text-anchor", 'start');
        if (value.dx) {
            pathDivtext.setAttribute("dx", value.dx);
        }
        pathDivtext.setAttribute("dy", -10);
        const pathDivtextPath = document.createElementNS(pathDivsvgns, "textPath");
        pathDivtext.setAttribute(":xlink:href", '#' + value.id + '-tp');
        pathDivtext.setAttribute("class", 'svgLine');
        if (value.rotate === 0) {
            pathDivtext.innerHTML = value.name;
        } else {
            pathDivtext.innerHTML = value.name.split('').reverse().join('');
        }
        let line = '';
        for (let i = 0; i < value.xPoints.length; i++) {
            if (i === 0) {
                line = 'M' + value.xPoints[0] + ' ' + value.yPoints[0] + ' ';
            } else {
                line += 'L' + value.xPoints[i] + ' ' + value.yPoints[i] + ' ';
            }
        }
        const pathDivPath = document.createElementNS(pathDivsvgns, "path");
        pathDivPath.setAttribute("class", 'svgLine');
        pathDivPath.setAttribute("d", line);
        if (value.state === 'finish') {
            pathDivPath.setAttribute("marker-end", "url(#arrowActive)");
            pathDivPath.setAttribute("fill", 'none');
            pathDivPath.setAttribute("stroke", '#27C3B0');
            pathDivPath.setAttribute("style", 'fill:none');
        } else if (value.state === 'next') {
            pathDivPath.setAttribute("marker-end", "url(#arrowNormal)");
            pathDivPath.setAttribute("fill", 'none');
            pathDivPath.setAttribute("stroke", '#E8E8E8');
            pathDivPath.setAttribute("style", 'fill:none');
        }
        pathDivg.appendChild(pathDivPath);
        pathDivsvger.appendChild(pathDivg);
        pathDivg.appendChild(pathDivtext);
        pathDivtext.appendChild(pathDivtextPath);
        pathDivg.appendChild(pathDivPath);
    });
    svgcontainer.appendChild(pathDiv);
    pathDiv.appendChild(pathDivsvger);
}

// 绘制并行网关
function drawParallel(data) {
    data.forEach(function (value, index, array) {
        const parallelDiv = document.createElement("div");
        parallelDiv.setAttribute("id", value.id);
        parallelDiv.setAttribute("class", 'svgDiv');
        parallelDiv.style.top = value.y + 'px';
        parallelDiv.style.left = value.x + 'px';
        const parallelP = document.createElement("p");
        parallelP.setAttribute("class", 'svgText');
        parallelP.innerHTML = value.name;
        parallelP.style.top = value.width + 'px';
        parallelP.style.left = (value.width / 2 - value.name.length * 6) + 'px';
        const parallelDivsvgns = "http://www.w3.org/2000/svg";
        const parallelDivsvger = document.createElementNS(parallelDivsvgns, "svg");
        parallelDivsvger.setAttribute("width", value.width);
        parallelDivsvger.setAttribute("height", value.height);
        parallelDivsvger.setAttribute("viewBox", "0 0 " + value.width + " " + value.height);
        const parallelDivg = document.createElementNS(parallelDivsvgns, "g");
        parallelDivg.setAttribute("pointer-events", 'fill');
        parallelDivg.setAttribute("title", value.name);
        parallelDivg.setAttribute("transform", 'translate(0.2, 0.2)');
        const parallelDivPath1 = document.createElementNS(parallelDivsvgns, "path");
        const path1 = 'M1 ' + value.width / 2 + ' L' + value.width / 2 + ' 0  L' + value.width + ' ' + value.width /
            2 + ' L' + value.width / 2 + ' ' + value.width + '  z';
        parallelDivPath1.setAttribute("id", value.id + 'bg_frame');
        parallelDivPath1.setAttribute("d", path1);
        parallelDivPath1.setAttribute("stroke-width", 1);
        const parallelDivPath2 = document.createElementNS(parallelDivsvgns, "path");
        const path2 = 'M' + (value.width) / 4 + ' ' + value.width / 2 + ' L' + (value.width) / 4 * 3 + ' ' + value
            .width / 2 + ' M' + value.width / 2 + ' ' + (value.width) / 4 + '  L' + value.width / 2 + ' ' + (value
            .width) / 4 * 3;
        parallelDivPath2.setAttribute("id", value.id + 'path');
        parallelDivPath2.setAttribute("d", path2);
        parallelDivPath2.setAttribute("stroke-width", 3);
        if (value.state === 'finish') {
            parallelDivPath1.setAttribute("fill", 'rgba(233, 249, 247, 1)');
            parallelDivPath1.setAttribute("stroke", '#27C3B0');
            parallelDivPath2.setAttribute("stroke", '#27C3B0');
        } else if (value.state === 'complete') {
            parallelDivPath1.setAttribute("fill", 'rgba(39, 148, 248, 0.1)');
            parallelDivPath1.setAttribute("stroke", '#2794F8');
            parallelDivPath2.setAttribute("stroke", '#2794F8');
        } else if (value.state === 'reject') {
            parallelDivPath1.setAttribute("fill", 'rgba(247, 126, 92, 0.1)');
            parallelDivPath1.setAttribute("stroke", '#F77E5C');
            parallelDivPath2.setAttribute("stroke", '#F77E5C');
        } else if (value.state === 'revoke') {
            parallelDivPath1.setAttribute("fill", 'rgba(255, 195, 93, 0.1)');
            parallelDivPath1.setAttribute("stroke", '#FFC35D');
            parallelDivPath2.setAttribute("stroke", '#FFC35D');
        } else if (value.state === 'suspend') {
            parallelDivPath1.setAttribute("fill", 'rgba(115, 208, 255, 0.1)');
            parallelDivPath1.setAttribute("stroke", '#73D0FF');
            parallelDivPath2.setAttribute("stroke", '#73D0FF');
        } else {
            parallelDivPath1.setAttribute("fill", 'rgba(216, 216, 216, 0.1)');
            parallelDivPath1.setAttribute("stroke", '#D8D8D8');
            parallelDivPath2.setAttribute("stroke", '#D8D8D8');
        }
        svgcontainer.appendChild(parallelDiv);
        parallelDiv.appendChild(parallelDivsvger);
        parallelDiv.appendChild(parallelP);
        parallelDivsvger.appendChild(parallelDivg);
        parallelDivg.appendChild(parallelDivPath1);
        parallelDivg.appendChild(parallelDivPath2);
    })
}

// 绘制单一网关
function drawExclusive(data) {
    data.forEach(function (value, index, array) {
        const exclusiveDiv = document.createElement("div");
        exclusiveDiv.setAttribute("id", value.id);
        exclusiveDiv.setAttribute("class", 'svgDiv');
        exclusiveDiv.style.top = value.y + 'px';
        exclusiveDiv.style.left = value.x + 'px';
        const exclusiveP = document.createElement("p");
        exclusiveP.setAttribute("class", 'svgText');
        exclusiveP.innerHTML = value.name;
        exclusiveP.style.top = value.width + 'px';
        exclusiveP.style.left = (value.width / 2 - value.name.length * 6) + 'px';
        const exclusiveDivsvgns = "http://www.w3.org/2000/svg";
        const exclusiveDivsvger = document.createElementNS(exclusiveDivsvgns, "svg");
        exclusiveDivsvger.setAttribute("width", value.width);
        exclusiveDivsvger.setAttribute("height", value.height);
        exclusiveDivsvger.setAttribute("viewBox", "0 0 " + value.width + " " + value.height);
        const exclusiveDivg1 = document.createElementNS(exclusiveDivsvgns, "g");
        exclusiveDivg1.setAttribute("pointer-events", 'fill');
        exclusiveDivg1.setAttribute("title", value.name);
        exclusiveDivg1.setAttribute("transform", 'translate(0.2, 0.2)');
        const exclusiveDivPath1 = document.createElementNS(exclusiveDivsvgns, "path");
        const path1 = 'M1 ' + value.width / 2 + ' L' + value.width / 2 + ' 0  L' + value.width + ' ' + value.width /
            2 + ' L' + value.width / 2 + ' ' + value.width + '  z';
        exclusiveDivPath1.setAttribute("id", value.id + 'bg_frame');
        exclusiveDivPath1.setAttribute("d", path1);
        exclusiveDivPath1.setAttribute("stroke-width", 1);
        const exclusiveDivg2 = document.createElementNS(exclusiveDivsvgns, "g");
        exclusiveDivg2.setAttribute("id", value.id + 'cross');
        const exclusiveDivPath2 = document.createElementNS(exclusiveDivsvgns, "path");
        const path2 = 'M' + (value.width - value.width / 2.85) / 2 + ' ' + (value.width - value.width / 2.5) / 2 +
            ' L' + ((value.width - value.width / 2.85) / 2 + 4) + ' ' + (value.width - value.width / 2.5) / 2 + ' L' +
            ((value.width - value.width / 2.85) / 2 + value.width / 2.85) + ' ' + ((value.width - value.width / 2.5) /
                2 + value.width / 2.5) + ' L' + (((value.width - value.width / 2.85) / 2 + value.width / 2.85) - 4) +
            ' ' + ((value.width - value.width / 2.5) / 2 + value.width / 2.5) + ' z';
        exclusiveDivPath2.setAttribute("id", value.id + 'crosspath');
        exclusiveDivPath2.setAttribute("d", path2);
        exclusiveDivPath2.setAttribute("stroke-width", 0.2);
        const exclusiveDivPath3 = document.createElementNS(exclusiveDivsvgns, "path");
        const path3 = 'M' + (value.width - value.width / 2.85) / 2 + ' ' + ((value.width - value.width / 2.5) / 2 +
            value.width / 2.5) + ' L' + (((value.width - value.width / 2.85) / 2 + value.width / 2.85) - 4) + ' ' +
            (value.width - value.width / 2.5) / 2 + '  L' + ((value.width - value.width / 2.85) / 2 + value.width /
                2.85) + ' ' + (value.width - value.width / 2.5) / 2 + ' L' + ((value.width - value.width / 2.85) / 2 +
                4) + ' ' + ((value.width - value.width / 2.5) / 2 + value.width / 2.5) + '  z';
        exclusiveDivPath3.setAttribute("id", value.id + 'crosspath');
        exclusiveDivPath3.setAttribute("d", path3);
        exclusiveDivPath3.setAttribute("stroke-width", 0.2);
        if (value.state === 'finish') {
            exclusiveDivPath1.setAttribute("fill", 'rgba(233, 249, 247, 1)');
            exclusiveDivPath1.setAttribute("stroke", '#27C3B0');
            exclusiveDivPath2.setAttribute("stroke", '#27C3B0');
            exclusiveDivPath2.setAttribute("stroke", '#27C3B0');
            exclusiveDivPath3.setAttribute("stroke", '#27C3B0');
            exclusiveDivPath3.setAttribute("stroke", '#27C3B0');
        } else if (value.state === 'complete') {
            exclusiveDivPath1.setAttribute("fill", 'rgba(39, 148, 248, 0.1)');
            exclusiveDivPath1.setAttribute("stroke", '#2794F8');
            exclusiveDivPath2.setAttribute("stroke", '#2794F8');
            exclusiveDivPath2.setAttribute("stroke", '#2794F8');
            exclusiveDivPath3.setAttribute("stroke", '#2794F8');
            exclusiveDivPath3.setAttribute("stroke", '#2794F8');
        } else if (value.state === 'reject') {
            exclusiveDivPath1.setAttribute("fill", 'rgba(247, 126, 92, 0.1)');
            exclusiveDivPath1.setAttribute("stroke", '#F77E5C');
            exclusiveDivPath2.setAttribute("stroke", '#F77E5C');
            exclusiveDivPath2.setAttribute("stroke", '#F77E5C');
            exclusiveDivPath3.setAttribute("stroke", '#F77E5C');
            exclusiveDivPath3.setAttribute("stroke", '#F77E5C');
        } else if (value.state === 'revoke') {
            exclusiveDivPath1.setAttribute("fill", 'rgba(255, 195, 93, 0.1)');
            exclusiveDivPath1.setAttribute("stroke", '#FFC35D');
            exclusiveDivPath2.setAttribute("stroke", '#FFC35D');
            exclusiveDivPath2.setAttribute("stroke", '#FFC35D');
            exclusiveDivPath3.setAttribute("stroke", '#FFC35D');
            exclusiveDivPath3.setAttribute("stroke", '#FFC35D');
        } else if (value.state === 'suspend') {
            exclusiveDivPath1.setAttribute("fill", 'rgba(115, 208, 255, 0.1)');
            exclusiveDivPath1.setAttribute("stroke", '#73D0FF');
            exclusiveDivPath2.setAttribute("fill", '#73D0FF');
            exclusiveDivPath2.setAttribute("stroke", '#73D0FF');
            exclusiveDivPath3.setAttribute("fill", '#73D0FF');
            exclusiveDivPath3.setAttribute("stroke", '#73D0FF');
        } else {
            exclusiveDivPath1.setAttribute("fill", 'rgba(216, 216, 216, 0.1)');
            exclusiveDivPath1.setAttribute("stroke", '#D8D8D8');
            exclusiveDivPath2.setAttribute("fill", '#D8D8D8');
            exclusiveDivPath2.setAttribute("stroke", '#D8D8D8');
            exclusiveDivPath3.setAttribute("fill", '#D8D8D8');
            exclusiveDivPath3.setAttribute("stroke", '#D8D8D8');
        }
        svgcontainer.appendChild(exclusiveDiv);
        exclusiveDiv.appendChild(exclusiveDivsvger);
        exclusiveDiv.appendChild(exclusiveP);
        exclusiveDivsvger.appendChild(exclusiveDivg1);
        exclusiveDivg1.appendChild(exclusiveDivPath1);
        exclusiveDivg1.appendChild(exclusiveDivg2);
        exclusiveDivg2.appendChild(exclusiveDivPath2);
        exclusiveDivg2.appendChild(exclusiveDivPath3);
    })
}

// 绘制多路网关
function drawInclusive(data) {
    data.forEach(function (value, index, array) {
        const inclusiveDiv = document.createElement("div");
        inclusiveDiv.setAttribute("id", value.id);
        inclusiveDiv.setAttribute("class", 'svgDiv');
        inclusiveDiv.style.top = value.y + 'px';
        inclusiveDiv.style.left = value.x + 'px';
        const inclusiveP = document.createElement("p");
        inclusiveP.setAttribute("class", 'svgText');
        inclusiveP.innerHTML = value.name;
        inclusiveP.style.top = value.width + 'px';
        inclusiveP.style.left = (value.width / 2 - value.name.length * 6) + 'px';
        const inclusiveDivsvgns = "http://www.w3.org/2000/svg";
        const inclusiveDivsvger = document.createElementNS(inclusiveDivsvgns, "svg");
        inclusiveDivsvger.setAttribute("width", value.width);
        inclusiveDivsvger.setAttribute("height", value.height);
        inclusiveDivsvger.setAttribute("viewBox", "0 0 " + value.width + " " + value.height);
        const inclusiveDivg = document.createElementNS(inclusiveDivsvgns, "g");
        inclusiveDivg.setAttribute("pointer-events", 'fill');
        inclusiveDivg.setAttribute("title", value.name);
        inclusiveDivg.setAttribute("transform", 'translate(0.2, 0.2)');
        const inclusiveDivPath = document.createElementNS(inclusiveDivsvgns, "path");
        const path = 'M1 ' + value.width / 2 + ' L' + value.width / 2 + ' 0  L' + value.width + ' ' + value.width /
            2 + ' L' + value.width / 2 + ' ' + value.width + '  z';
        inclusiveDivPath.setAttribute("id", value.id + 'bg_frame');
        inclusiveDivPath.setAttribute("d", path);
        inclusiveDivPath.setAttribute("stroke-width", 1);
        const inclusiveDivCircle = document.createElementNS(inclusiveDivsvgns, "circle");
        inclusiveDivCircle.setAttribute("id", value.id + 'circle');
        inclusiveDivCircle.setAttribute("cx", value.width / 2);
        inclusiveDivCircle.setAttribute("cy", value.width / 2);
        inclusiveDivCircle.setAttribute("r", value.width / 3.5);
        inclusiveDivCircle.setAttribute("fill", 'none');
        inclusiveDivCircle.setAttribute("stroke-width", 2.5);
        if (value.state === 'finish') {
            inclusiveDivPath.setAttribute("fill", 'rgba(233, 249, 247, 1)');
            inclusiveDivPath.setAttribute("stroke", '#27C3B0');
            inclusiveDivCircle.setAttribute("stroke", '#27C3B0');
        } else if (value.state === 'complete') {
            inclusiveDivPath.setAttribute("fill", 'rgba(39, 148, 248, 0.1)');
            inclusiveDivPath.setAttribute("stroke", '#2794F8');
            inclusiveDivCircle.setAttribute("stroke", '#2794F8');
        } else if (value.state === 'reject') {
            inclusiveDivPath.setAttribute("fill", 'rgba(247, 126, 92, 0.1)');
            inclusiveDivPath.setAttribute("stroke", '#F77E5C');
            inclusiveDivCircle.setAttribute("stroke", '#F77E5C');
        } else if (value.state === 'revoke') {
            inclusiveDivPath.setAttribute("fill", 'rgba(255, 195, 93, 0.1)');
            inclusiveDivPath.setAttribute("stroke", '#FFC35D');
            inclusiveDivCircle.setAttribute("stroke", '#FFC35D');
        } else if (value.state === 'suspend') {
            inclusiveDivPath.setAttribute("fill", 'rgba(115, 208, 255, 0.1)');
            inclusiveDivPath.setAttribute("stroke", '#73D0FF');
            inclusiveDivCircle.setAttribute("stroke", '#73D0FF');
        } else {
            inclusiveDivPath.setAttribute("fill", 'rgba(216, 216, 216, 0.1)');
            inclusiveDivPath.setAttribute("stroke", '#D8D8D8');
            inclusiveDivCircle.setAttribute("stroke", '#D8D8D8');
        }
        svgcontainer.appendChild(inclusiveDiv);
        inclusiveDiv.appendChild(inclusiveDivsvger);
        inclusiveDiv.appendChild(inclusiveP);
        inclusiveDivsvger.appendChild(inclusiveDivg);
        inclusiveDivg.appendChild(inclusiveDivPath);
        inclusiveDivg.appendChild(inclusiveDivCircle);
    })
}

const oIframe = document.getElementById('outFlow');
// 绘制外部子流程
function drawCall(data) {
    data.forEach(function (value) {
        const callDiv = document.createElement("div");
        callDiv.onclick = function() {
            oIframe.setAttribute("src", getContextPath() +'/hussarBpmDiagram/subProcessDisplay?processInstId='+value.processInstanceId);
            oIframe.style.display = 'block';
            oIframe.style.width = document.documentElement.clientWidth +'px';
            oIframe.style.height = document.documentElement.clientHeight + 'px';
        };
        callDiv.setAttribute("id", value.id);
        callDiv.setAttribute("class", 'svgDiv');
        callDiv.style.top = value.y + 'px';
        callDiv.style.left = value.x + 'px';
        callDiv.style.width = value.width + 'px';
        callDiv.style.height = value.height + 'px';
        const callP = document.createElement("p");
        callP.setAttribute("class", 'svgText');
        callP.innerHTML = value.name;
        callP.style.top = value.height + 2 + 'px';
        callP.style.left = (value.width / 2 - value.name.length * 6 - 2) + 'px';
        const callDivsvgns = "http://www.w3.org/2000/svg";
        const callDivsvger = document.createElementNS(callDivsvgns, "svg");
        callDivsvger.setAttribute("width", value.width);
        callDivsvger.setAttribute("height", value.height);
        callDivsvger.setAttribute("viewBox", "0 0 " + value.width + " " + value.height);
        const callDivg = document.createElementNS(callDivsvgns, "g");
        callDivg.setAttribute("pointer-events", 'fill');
        callDivg.setAttribute("title", value.name);
        callDivg.setAttribute("transform", 'translate(2,2)');
        const callDivrect = document.createElementNS(callDivsvgns, "rect");
        callDivrect.setAttribute("rx", 10);
        callDivrect.setAttribute("ry", 10);
        callDivrect.setAttribute("width", value.width - 4);
        callDivrect.setAttribute("height", value.height - 4);
        callDivrect.setAttribute("stroke-width", 4);
        if (value.state === 'finish') {
            callDivrect.setAttribute("stroke", '#27C3B0');
            callDivrect.setAttribute("fill", '#E9F9F7');
        } else if (value.state === 'complete') {
            callDivrect.setAttribute("stroke", '#2794F8');
            callDivrect.setAttribute("fill", 'rgba(39, 148, 248, 0.1)');
        } else if (value.state === 'next') {
            callDivrect.setAttribute("stroke", '#D8D8D8');
            callDivrect.setAttribute("fill", 'rgba(216, 216, 216, 0.1)');
        }
        svgcontainer.appendChild(callDiv);
        callDiv.appendChild(callDivsvger);
        callDivsvger.appendChild(callDivg);
        callDivg.appendChild(callDivrect);
        callDiv.appendChild(callP);
    })
}

let fullScreen = false;
// 控制是否全屏
function toFullScreen(data) {
    if(fullScreen){
        fullScreen = false;
        svgcontainer.style.height = document.documentElement.clientHeight - 400 + 'px';
        data.classList.remove('fullScreen2');
        data.classList.add('fullScreen1');
    }else {
        fullScreen = true;
        svgcontainer.style.height = document.documentElement.clientHeight + 'px';
        data.classList.remove('fullScreen1');
        data.classList.add('fullScreen2');
    }
}

// 关闭当前窗口
function closeFlow() {
    // const browserName = navigator.appName;
    // if (browserName=="Netscape"){
    //     window.opener = null;
    //     window.open('','_self','');
    //     window.close();
    //     // window.open('about:blank','_self').close();
    //     // window.close();
    // }
    // if (browserName=="Microsoft Internet Explorer") {
    //     window.parent.opener = "whocares";
    //     window.parent.close();
    // }
    // window.close();splice
    $('#outFlow').hide();
}

// 列表加载
let listData = [];
const initTable = function () {
    const processId = $("#processId").val();
    $.ajax({
        url: contextPath+'/hussarBpmDiagram/historyList?processInstanceId='+ processId,
        success: function (res) {
            listData = res.data;
            if(listData === 0) {
                document.getElementById("listNoData").style.display = 'block';
            } else {
                document.getElementById("listNoData").style.display = 'none';
                tbodyRender(listData, list);
            }
        }
    });
};

// 渲染列表
function tbodyRender(data, container) {
    data.forEach(function (value, index, array) {
        if (value.variables.complete_type === 'complete' || value.variables.complete_type === 'skip') {
            value.variables.complete_type = '办理';
        } else if (value.variables.complete_type === 'revoke') {
            value.variables.complete_type = '撤回';
        } else if (value.variables.complete_type === 'reject') {
            value.variables.complete_type = '驳回';
        } else if (value.variables.complete_type === 'freejump') {
            value.variables.complete_type = '自由跳转';
        } else {
            value.variables.complete_type = '';
        }
        const tr = document.createElement("tr");
        const tdNum = document.createElement("td");
        tdNum.innerHTML = "<div>" + (index + 1) + "</div>";
        tr.appendChild(tdNum);
        const tdActivityName = document.createElement("td");
        tdActivityName.innerHTML = "<div>" + value.activityName + "</div>";
        tr.appendChild(tdActivityName);
        const tdAssignee = document.createElement("td");
        tdAssignee.innerHTML = "<div>" + value.assignee + "</div>";
        tr.appendChild(tdAssignee);
        const tdStartTime = document.createElement("td");
        tdStartTime.innerHTML = "<div>" + value.startTime + "</div>";
        tr.appendChild(tdStartTime);
        const tdEndTime = document.createElement("td");
        tdEndTime.innerHTML = "<div>" + value.endTime + "</div>";
        tr.appendChild(tdEndTime);
        const tdTaskSourceFlag = document.createElement("td");
        tdTaskSourceFlag.innerHTML = "<div>" + value.variables.complete_type + "</div>";
        tr.appendChild(tdTaskSourceFlag);
        const tdComments = document.createElement("td");
        tdComments.innerHTML = "<div>" + value.comments + "</div>";
        tr.appendChild(tdComments);
        container.appendChild(tr);
    });
}

// 列表数据过滤
function dataFilter(id) {
    const noDataList = document.getElementById("listNoData");
    if(id === 'all' && listData.length !== 0) {
        noDataList.style.display = 'none';
        list.innerHTML = '';
        tbodyRender(listData, list);
    } else {
        let filterList = [];
        listData.forEach(function (value) {
            if(value.taskDefinitionKey === id) {
                filterList.push(value);
            }
        });
        list.innerHTML = '';
        if(filterList.length === 0) {
            noDataList.style.display = 'block';
        } else {
            noDataList.style.display = 'none';
            tbodyRender(filterList, list);
        }
    }
}

$(function () {
    const closeBtn = document.getElementById('closeFlow');
    if(self.frameElement && self.frameElement.tagName == "IFRAME"){
        closeBtn.style.display = 'block';
    } else {
        closeBtn.style.display = 'none';
    }
    dataRequest();
    initTable();
    $('#svg').click(function () {
        dataFilter('all');
    });
});
