const processId = $("#processId").val();
const contextPath = getContextPath();
const list = document.getElementById("processTable");

// 列表加载
let listData = [];
const initTable = function () {
    $.ajax({
        url: contextPath+'/hussarBpmDiagram/subProcessList?processInstanceId='+ processId,
        success: function (res) {
            listData = res.data;
            if(listData === 0) {
                document.getElementById("listNoData").style.display = 'block';
            } else {
                document.getElementById("listNoData").style.display = 'none';
                tbodyRender(listData, list);
            }
        }
    });
};

// 渲染列表
function tbodyRender(data, container) {
    data.forEach(function (value, index, array) {
        const tr = document.createElement("tr");
        const tdNum = document.createElement("td");
        tdNum.innerHTML = "<div>" + (index + 1) + "</div>";
        tr.appendChild(tdNum);
        const tdprocessDefinitionName = document.createElement("td");
        tdprocessDefinitionName.innerHTML = "<div>" + value.processDefinitionName + "</div>";
        tr.appendChild(tdprocessDefinitionName);
        const tdbusinessKey = document.createElement("td");
        tdbusinessKey.innerHTML = "<div>" + value.businessKey + "</div>";
        tr.appendChild(tdbusinessKey);
        const tdStartTime = document.createElement("td");
        tdStartTime.innerHTML = "<div>" + value.startTime.substr(0,19) + "</div>";
        tr.appendChild(tdStartTime);
        const tdEndTime = document.createElement("td");
        tdEndTime.innerHTML = "<div>" + value.endTime.substr(0,19) + "</div>";
        tr.appendChild(tdEndTime);
        const tdDuration = document.createElement("td");
        tdDuration.innerHTML = "<div>" + getTimes(value.startTime,value.endTime) + "</div>";
        tr.appendChild(tdDuration);
        if(value.endTime != null && value.endTime !== '') {
            const tdEnd1 = document.createElement("td");
            tdEnd1.innerHTML = "<div>结束</div>";
            tr.appendChild(tdEnd1);
        }
        if(value.suspension == 2 || value.suspension == 1) {
            const tdEnd2 = document.createElement("td");
            tdEnd2.innerHTML = "<div>"+setNames(value.names) +"</div>";
            tr.appendChild(tdEnd2);
        }
        const tdStatus = document.createElement("td");
        let status = '';
        if(value.suspension == 1) {
            status = '运行中';
        } else if(value.suspension == 2) {
            status = '已挂起';
        } else if(value.endTime != null && value.endTime !== '') {
            status = '已完成';
        }
        tdStatus.innerHTML = "<div>" + status + "</div>";
        tr.appendChild(tdStatus);
        const tdOperating = document.createElement("td");
        tdOperating.innerHTML = "<div><button class='blueBtn' onclick=showFlow('" + value.processInstanceId + "')>流程图</button></div>";
        tr.appendChild(tdOperating);
        container.appendChild(tr);
    });
}

// 获取时间差
function getTimes(start, end) {
    let time1 = new Date(start);
    let time2 = new Date(end);
    if (end === '' | end == null) {
        time2 = new Date();
    }
    let times = time2 - time1;
    let day = Math.floor(times / (24 * 3600 * 1000));
    times = times % (24 * 3600 * 1000);
    let hour = Math.floor(times / (3600 * 1000));
    times = times % (3600 * 1000);
    let min = Math.floor(times / (60 * 1000));
    times = times % (60 * 1000);
    let s = Math.floor((times / 1000));
    let str = day + '天' + hour + '小时' + min + '分' + s + '秒';
    return str;
}

// 设置环节的输出数据
function setNames(data) {
    var num = data.length;
    if (num === 0) {
        return '结束';
    }
    var str = data[0];
    for (var i = 1; i < num; i++) {
        str = str + ' , ' + data[i];
    }
    return str;
}

function showFlow(id){
    const oIframe = document.getElementById('processPic');
    oIframe.setAttribute("src", getContextPath() +'/hussarBpmDiagram/processdisplay?processInstId=' + id);
    oIframe.style.display='block';
    oIframe.style.width = document.documentElement.clientWidth +'px';
    oIframe.style.height = document.documentElement.clientHeight + 'px';
}

// 关闭当前窗口
function closeFlow() {
    $('#processPic').hide();
}

$(function () {
    const closeBtn = document.getElementById('closeFlow');
    if(self.frameElement && self.frameElement.tagName == "IFRAME"){
        closeBtn.style.display = 'block';
    } else {
        closeBtn.style.display = 'none';
    }
    initTable();
});
