/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.flowchar;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.util.BpmConfigRead;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowChart"})
public class FlowChartController {
    private static final String FLOW_CHART = "/flowChart/";
    private static Logger LOGGER = LogManager.getLogger(FlowChartController.class);

    @RequestMapping(value={"/historyList"})
    public Map<String, Object> historyList(String processInstanceId, String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        String result = FlowChartController.execute(map, "historyList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @RequestMapping(value={"/historyMicroList"})
    public Map<String, Object> historyMicroList(String processInstanceId, String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        String result = FlowChartController.execute(map, "historyMicroList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @RequestMapping(value={"/getProcessDetail"})
    public JSONObject getProcessDetail(String processInstanceId, String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        String result = FlowChartController.execute(map, "getProcessDetail");
        return (JSONObject)JSON.parseObject((String)result, JSONObject.class);
    }

    @RequestMapping(value={"/getProcessCompleteDetail"})
    public JSONArray getProcessCompleteDetail(String processInstanceId, String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        String result = FlowChartController.execute(map, "getProcessCompleteDetail");
        return (JSONArray)JSON.parseObject((String)result, JSONArray.class);
    }

    @RequestMapping(value={"/subProcessList"})
    public Map<String, Object> subProcessList(String supProcessInstId, String businessKey, String taskDefinitionKey, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="9999") Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supProcessInstId", supProcessInstId);
        map.put("businessKey", businessKey);
        map.put("taskDefinitionKey", taskDefinitionKey);
        map.put("page", page);
        map.put("limit", limit);
        String result = FlowChartController.execute(map, "subProcessList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @RequestMapping(value={"/getProcessInfoByFile"})
    public JSONObject getProcessInfoByFile(String processIdentityKey, String processDefKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processIdentityKey", processIdentityKey);
        map.put("processDefKey", processDefKey);
        String result = FlowChartController.execute(map, "getProcessInfoByFile");
        return (JSONObject)JSON.parseObject((String)result, JSONObject.class);
    }

    private static String execute(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + FLOW_CHART + url;
        LOGGER.info("\u6d41\u7a0b\u56fe\u76f8\u5173\u529f\u80fd\u5f00\u59cb");
        System.out.println("\u6d41\u7a0b\u56fe\u76f8\u5173\u529f\u80fd\u5f00\u59cb");
        LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + finalUrl);
        System.out.println("\u8def\u5f84\u4fe1\u606f" + finalUrl);
        Long start = System.currentTimeMillis();
        String result = HttpUtil.get((String)finalUrl, map, (int)bpmConfigRead.getDataPushTimeOut());
        Long end = System.currentTimeMillis();
        LOGGER.info("\u6d41\u7a0b\u56fe\u76f8\u5173\u529f\u80fd\u7ed3\u675f");
        System.out.println("\u6d41\u7a0b\u56fe\u76f8\u5173\u529f\u80fd\u7ed3\u675f");
        LOGGER.info("\u6d41\u7a0b\u56fe\u76f8\u5173\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        System.out.println("\u6d41\u7a0b\u56fe\u76f8\u5173\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        return result;
    }
}

