/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.response.BpmResponseResult;
import com.jxdinfo.hussar.util.BpmConfigRead;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskEngineService {
    private static final String TASK = "/task/";
    private static Logger LOGGER = LogManager.getLogger(TaskEngineService.class);

    public static BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("userId", userId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("definitionKey", definitionKey);
        return TaskEngineService.execute(map, "queryToDoTaskList");
    }

    public static BpmResponseResult isAddParallel(String taskId) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("taskId", taskId);
        return TaskEngineService.executeFramework(maps, "isAddParallel");
    }

    public static BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("userId", userId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("definitionKey", definitionKey);
        map.put("page", page);
        map.put("rows", rows);
        return TaskEngineService.execute(map, "queryToDoTaskListByPage");
    }

    public static BpmResponseResult queryToDoTaskList(String userId, List<String> businessIds) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("userId", userId);
        map.put("businessIds", businessIds);
        return TaskEngineService.execute(map, "queryToDoTaskListByBusinessIds");
    }

    public static BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("userId", userId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("definitionKey", definitionKey);
        return TaskEngineService.execute(map, "queryFinishedTaskList");
    }

    public static BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("userId", userId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("definitionKey", definitionKey);
        map.put("page", page);
        map.put("rows", rows);
        return TaskEngineService.execute(map, "queryFinishedTaskListByPage");
    }

    public static BpmResponseResult queryUserTaskCount(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("userId", userId);
        return TaskEngineService.execute(map, "queryUserTaskCount");
    }

    public static BpmResponseResult queryUserTaskCountByNode(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("userId", userId);
        return TaskEngineService.execute(map, "queryUserTaskCountByNode");
    }

    public static BpmResponseResult claimTask(String taskId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("taskId", taskId);
        map.put("userId", userId);
        return TaskEngineService.execute(map, "claimTask");
    }

    public static BpmResponseResult unClaimTask(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "unClaimTask");
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(7);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask1");
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask2");
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(10);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask3");
    }

    public static BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask4");
    }

    public static BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(10);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("subProcesses", subProcesses);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask5");
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("users", JSON.toJSONString(users));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask6");
    }

    public static BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(10);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeLeapTask");
    }

    public static BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("users", JSON.toJSONString(users));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeLeapTask1");
    }

    public static BpmResponseResult startAndCompleteTask(String processDefinitionKey, String userId, String businessKey, Map<String, Object> variables, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("processDefinitionKey", processDefinitionKey);
        maps.put("userId", userId);
        maps.put("businessKey", businessKey);
        maps.put("variables", JSON.toJSONString(variables));
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("users", JSON.toJSONString(users));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "startAndCompleteTask");
    }

    @Deprecated
    public static BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("assignees", "");
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToLastTask");
    }

    public static BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("assignees", assignees);
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToLastTask");
    }

    public static BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assignees", assignees);
        maps.put("isSubmit", isSubmit);
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToFirstTask");
    }

    @Deprecated
    public static BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assignees", "");
        maps.put("isSubmit", isSubmit);
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToFirstTask");
    }

    public static BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(12);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("backActivityId", backActivityId);
        maps.put("comment", comment);
        maps.put("assignees", assignees);
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToAnyTask");
    }

    @Deprecated
    public static BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(12);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("backActivityId", backActivityId);
        maps.put("comment", comment);
        maps.put("assignees", "");
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToAnyTask");
    }

    public static BpmResponseResult queryRejectNode(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryRejectNode");
    }

    public static BpmResponseResult delegateTask(String taskId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("taskId", taskId);
        map.put("userId", userId);
        return TaskEngineService.execute(map, "delegateTask");
    }

    public static BpmResponseResult entrustTask(String taskId, String userId, String consignee) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("taskId", taskId);
        map.put("userId", userId);
        map.put("consignee", consignee);
        return TaskEngineService.execute(map, "entrustTask");
    }

    public static BpmResponseResult entrustTask(String taskId, String userId, String consignee, String comment) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("taskId", taskId);
        map.put("userId", userId);
        map.put("consignee", consignee);
        map.put("comment", comment);
        return TaskEngineService.execute(map, "entrustTask");
    }

    public static BpmResponseResult entrustTask(String taskId, String consignee) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("taskId", taskId);
        map.put("consignee", consignee);
        return TaskEngineService.execute(map, "entrustTaskByTaskId");
    }

    public static BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(12);
        maps.put("taskId", taskId);
        maps.put("activitiId", activitiId);
        maps.put("userId", userId);
        maps.put("assignees", assignees);
        maps.put("isSubmit", isSubmit);
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "freeJump");
    }

    public static BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        HashMap<String, Object> maps = new HashMap<String, Object>(6);
        maps.put("taskId", taskId);
        maps.put("assigneeList", JSON.toJSONString(assigneeList));
        return TaskEngineService.execute(maps, "multiInstanceAddAssignee");
    }

    public static BpmResponseResult queryAssigneeByTaskId(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryAssigneeByTaskId");
    }

    public static BpmResponseResult addAssignees(String taskId, String businessKey, String users) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("taskId", taskId);
        map.put("businessKey", businessKey);
        map.put("users", users);
        return TaskEngineService.execute(map, "addAssignees");
    }

    public static BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        HashMap<String, Object> maps = new HashMap<String, Object>(4);
        maps.put("taskId", taskId);
        return TaskEngineService.execute(maps, "queryProcessNodeByTaskId");
    }

    public static BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(7);
        maps.put("taskId", taskId);
        maps.put("nodeId", nodeId);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "queryNextAssigneeByTaskIdAndNodeId");
    }

    public static BpmResponseResult queryNextAssignee(String processDefinitionKey, String taskId, String nodeId, String userId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(7);
        maps.put("processDefinitionKey", processDefinitionKey);
        maps.put("taskId", taskId);
        maps.put("nodeId", nodeId);
        maps.put("userId", userId);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "queryNextAssignee");
    }

    public static BpmResponseResult queryNextAssignee(String processDefinitionKey, String taskId, String nodeId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(7);
        maps.put("processDefinitionKey", processDefinitionKey);
        maps.put("taskId", taskId);
        maps.put("nodeId", nodeId);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "queryNextAssignee");
    }

    public static BpmResponseResult queryHistoryActByTaskId(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryHistoryActByTaskId");
    }

    public static BpmResponseResult getProcessDefinitionIdAndNodeId(String processDefinitionKey, String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "getProcessDefinitionIdAndNodeId");
    }

    public static BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessId", businessId);
        return TaskEngineService.execute(map, "queryTaskIdByBusinessKey");
    }

    public static BpmResponseResult queryNextNode(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryNextNodeByTaskId");
    }

    public static BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryNextNode");
    }

    public static BpmResponseResult withdrawState(String historicTaskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("historicTaskId", historicTaskId);
        return TaskEngineService.execute(map, "withdrawState");
    }

    @Deprecated
    public static BpmResponseResult withdrawStateByBusinessKey(String businessKey, String userId, String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("businessKey", businessKey);
        map.put("userId", userId);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "withdrawStateByBusinessKey");
    }

    public static BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("historicTaskId", historicTaskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "revokeTask");
    }

    public static BpmResponseResult getPreviousNodeAssignee(String taskId) {
        HashMap<String, Object> maps = new HashMap<String, Object>(4);
        maps.put("taskId", taskId);
        return TaskEngineService.execute(maps, "getPreviousNodeAssignee");
    }

    public static BpmResponseResult getTaskNodeAssignee(String taskId) {
        HashMap<String, Object> maps = new HashMap<String, Object>(6);
        maps.put("taskId", taskId);
        return TaskEngineService.execute(maps, "getTaskNodeAssignee");
    }

    public static BpmResponseResult getPreviousDefaultOrConditionAssignee(String taskId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(6);
        maps.put("taskId", taskId);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "getPreviousDefaultOrConditionAssignee");
    }

    private static BpmResponseResult execute(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + TASK + url;
        LOGGER.info("task\u76f8\u5173\u529f\u80fd\u5f00\u59cb");
        System.out.println("task\u76f8\u5173\u529f\u80fd\u5f00\u59cb");
        LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + finalUrl);
        System.out.println("\u8def\u5f84\u4fe1\u606f" + finalUrl);
        Long start = System.currentTimeMillis();
        String result = HttpUtil.get((String)finalUrl, map, (int)bpmConfigRead.getDataPushTimeOut());
        Long end = System.currentTimeMillis();
        LOGGER.info("task\u76f8\u5173\u529f\u80fd\u7ed3\u675f");
        System.out.println("task\u76f8\u5173\u529f\u80fd\u7ed3\u675f");
        LOGGER.info("task\u76f8\u5173\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        System.out.println("task\u76f8\u5173\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        return (BpmResponseResult)JSON.parseObject((String)result, BpmResponseResult.class);
    }

    private static BpmResponseResult executeFramework(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + "/addCustomNode/" + url;
        LOGGER.info("\u6dfb\u52a0\u610f\u89c1\u529f\u80fd\u5f00\u59cb");
        System.out.println("\u6dfb\u52a0\u610f\u89c1\u529f\u80fd\u5f00\u59cb");
        LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + finalUrl);
        System.out.println("\u8def\u5f84\u4fe1\u606f" + finalUrl);
        Long start = System.currentTimeMillis();
        String result = HttpUtil.get((String)finalUrl, map, (int)bpmConfigRead.getDataPushTimeOut());
        Long end = System.currentTimeMillis();
        LOGGER.info("\u6dfb\u52a0\u610f\u89c1\u529f\u80fd\u7ed3\u675f");
        System.out.println("\u6dfb\u52a0\u610f\u89c1\u529f\u80fd\u7ed3\u675f");
        LOGGER.info("\u6dfb\u52a0\u610f\u89c1\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        System.out.println("\u6dfb\u52a0\u610f\u89c1\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        return (BpmResponseResult)JSON.parseObject((String)result, BpmResponseResult.class);
    }

    public static BpmResponseResult addCustomNode(String taskId, List<Map<String, Object>> list, String parallel) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("taskId", taskId);
        maps.put("addList", JSON.toJSONString(list));
        maps.put("parallel", parallel);
        return TaskEngineService.executeFramework(maps, "add");
    }
}

