/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.response.BpmResponseResult;
import com.jxdinfo.hussar.util.BpmConfigRead;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SysActEntrustService {
    private static final String ENTRUST = "/sysActEntrust/";
    private static Logger LOGGER = LogManager.getLogger(SysActEntrustService.class);

    public static BpmResponseResult list(String userId, String processId, String state, Integer page, Integer size) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processId", processId);
        map.put("userId", userId);
        map.put("state", state);
        map.put("page", page);
        map.put("size", size);
        return SysActEntrustService.execute(map, "list");
    }

    public static BpmResponseResult getEntrustHistory(String userId, Integer pageNum, Integer limitNum) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("userId", userId);
        map.put("page", pageNum);
        map.put("limit", limitNum);
        return SysActEntrustService.execute(map, "entrustHistoryList");
    }

    public static BpmResponseResult add(String processId, String processName, String consignor, String consignorName, String consignee, String consigneeName, String state, String startTime, String endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        map.put("processId", processId);
        map.put("processName", processName);
        map.put("consignor", consignor);
        map.put("consignorName", consignorName);
        map.put("consignee", consignee);
        map.put("consigneeName", consigneeName);
        map.put("state", state);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return SysActEntrustService.execute(map, "add");
    }

    public static BpmResponseResult addBatch(List<String> processId, List<String> processName, String consignor, String consignorName, String consignee, String consigneeName, String state, String startTime, String endTime) {
        String processIds = "";
        for (int i = 0; i < processId.size(); ++i) {
            processIds = processIds + processId.get(i) + ",";
        }
        String processNames = "";
        for (int i = 0; i < processName.size(); ++i) {
            processNames = processNames + processName.get(i) + ",";
        }
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        map.put("processId", processIds);
        map.put("processName", processNames);
        map.put("consignor", consignor);
        map.put("consignorName", consignorName);
        map.put("consignee", consignee);
        map.put("consigneeName", consigneeName);
        map.put("state", state);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return SysActEntrustService.execute(map, "addBatch");
    }

    public static BpmResponseResult delete(String tEntrustId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("tEntrustId", tEntrustId);
        return SysActEntrustService.execute(map, "delete");
    }

    public static BpmResponseResult update(String id, String consignee, String consigneeName, String startTime, String endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("id", id);
        map.put("consignee", consignee);
        map.put("consigneeName", consigneeName);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return SysActEntrustService.execute(map, "update");
    }

    public static BpmResponseResult detail(String tEntrustId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("tEntrustId", tEntrustId);
        return SysActEntrustService.execute(map, "detail");
    }

    public static BpmResponseResult updateState(String tEntrustId, String state) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("tEntrustId", tEntrustId);
        map.put("state", state);
        return SysActEntrustService.execute(map, "updateState");
    }

    private static BpmResponseResult execute(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + ENTRUST + url;
        LOGGER.info("\u59d4\u6258\u529f\u80fd\u5f00\u59cb");
        System.out.println("\u59d4\u6258\u529f\u80fd\u5f00\u59cb");
        LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + finalUrl);
        System.out.println("\u8def\u5f84\u4fe1\u606f" + finalUrl);
        Long start = System.currentTimeMillis();
        String result = HttpUtil.get((String)finalUrl, map, (int)bpmConfigRead.getDataPushTimeOut());
        Long end = System.currentTimeMillis();
        LOGGER.info("\u59d4\u6258\u529f\u80fd\u7ed3\u675f");
        System.out.println("\u59d4\u6258\u529f\u80fd\u7ed3\u675f");
        LOGGER.info("\u59d4\u6258\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        System.out.println("\u59d4\u6258\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        return (BpmResponseResult)JSON.parseObject((String)result, BpmResponseResult.class);
    }
}

