/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.util;

import java.util.Locale;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
public final class BpmSpringContextHolder
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmSpringContextHolder.class);
    private static ApplicationContext context;
    private static ServletContext servletContext;
    private static Environment environment;
    private static MessageSourceAccessor messages;

    private BpmSpringContextHolder() {
    }

    public static ApplicationContext getSpringContext() {
        return context;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static Object getBean(String name) {
        return context.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)context.getBean(requiredType);
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        return (T)context.getBean(name, requiredType);
    }

    public static String getProperty(String key) {
        return environment.getProperty(key);
    }

    public static String getRequiredProperty(String key) {
        return environment.getRequiredProperty(key);
    }

    public static void setServletContext(ServletContext sc) {
        servletContext = sc;
    }

    public static MessageSourceAccessor getMessageSourceAccessor() {
        return messages;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        BpmSpringContextHolder.init(applicationContext);
    }

    private static void init(ApplicationContext applicationContext) {
        context = applicationContext;
        environment = context.getEnvironment();
        if (context instanceof WebApplicationContext) {
            servletContext = ((WebApplicationContext)context).getServletContext();
        }
        messages = new MessageSourceAccessor((MessageSource)context, Locale.SIMPLIFIED_CHINESE);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        LOGGER.info("Spring context holder initialized successful");
    }
}

