/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.util;

import com.jxdinfo.hussar.util.BpmConfigReadService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="global", name={"tenant-open"}, havingValue="false", matchIfMissing=true)
public class BpmConfigRead
implements BpmConfigReadService {
    private static String url;
    private static String tenantId;
    private static String tenantCipher;
    @Value(value="${hussar-bpm.url:}")
    private String tempUrl;
    @Value(value="${hussar-bpm.tenant-id:}")
    private String tempTenantId;
    @Value(value="${hussar-bpm.tenant-cipher:}")
    private String tempTenantCipher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        if (this.tempUrl == null || "".equals(this.tempUrl)) {
            InputStream in = null;
            try {
                in = BpmConfigRead.class.getClassLoader().getResourceAsStream("bpm.properties");
                Properties p = new Properties();
                p.load(in);
                url = p.getProperty("bpm_url");
                tenantId = p.getProperty("tenant_id");
                tenantCipher = p.getProperty("tenant_cipher");
            }
            catch (IOException e) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != in) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            url = this.tempUrl;
            tenantId = this.tempTenantId;
            tenantCipher = this.tempTenantCipher;
        }
    }

    public void setTempUrl(String tempUrl) {
        this.tempUrl = tempUrl;
    }

    public void setTempTenantId(String tempTenantId) {
        this.tempTenantId = tempTenantId;
    }

    public void setTempTenantCipher(String tempTenantCipher) {
        this.tempTenantCipher = tempTenantCipher;
    }

    @Override
    public String getUrl() {
        return url;
    }

    @Override
    public String getTenantId() {
        return tenantId;
    }

    @Override
    public String getTenantCipher() {
        return tenantCipher;
    }

    @Override
    public String getTempTenantId() {
        return this.tempTenantId;
    }

    @Override
    public String getTempTenantCipher() {
        return tenantCipher;
    }
}

