/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.response.BpmResponseResult;
import com.jxdinfo.hussar.util.BpmConfigRead;
import java.util.HashMap;
import java.util.Map;

public class InstanceEngineService {
    private static final String INSTANCE = "/instance/";

    public static BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessKey, Map<String, Object> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessKey", businessKey);
        map.put("variables", JSON.toJSONString(variables));
        return InstanceEngineService.execute(map, "startProcessInstanceById");
    }

    public static BpmResponseResult startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, Map<String, Object> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("userId", userId);
        map.put("businessKey", businessKey);
        map.put("variables", JSON.toJSONString(variables));
        return InstanceEngineService.execute(map, "startProcessInstanceByKey");
    }

    public static BpmResponseResult startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, String processCode, Map<String, Object> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("userId", userId);
        map.put("businessKey", businessKey);
        map.put("processCode", processCode);
        map.put("variables", JSON.toJSONString(variables));
        return InstanceEngineService.execute(map, "startProcessInstanceByKey");
    }

    public static BpmResponseResult startProcessInstanceByKeyWithOutCheck(String processDefinitionKey, String userId, String businessKey, String processCode, Map<String, Object> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("userId", userId);
        map.put("businessKey", businessKey);
        map.put("processCode", processCode);
        map.put("variables", JSON.toJSONString(variables));
        return InstanceEngineService.execute(map, "startProcessInstanceByKeyWithOutCheck");
    }

    public static BpmResponseResult checkProcessInstByBusinessKey(String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessKey", businessKey);
        return InstanceEngineService.execute(map, "checkProcessInstByBusinessKey");
    }

    public static BpmResponseResult validateEditAuthority(String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessKey", businessKey);
        return InstanceEngineService.execute(map, "validateEditAuthority");
    }

    public static BpmResponseResult suspendProcessInstanceById(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInstanceId", processInstanceId);
        return InstanceEngineService.execute(map, "suspendProcessInstanceById");
    }

    public static BpmResponseResult activateProcessInstanceById(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInstanceId", processInstanceId);
        return InstanceEngineService.execute(map, "activateProcessInstanceById");
    }

    public static BpmResponseResult deleteProcessInstance(String processInstanceId, String reason) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInstanceId", processInstanceId);
        map.put("reason", reason);
        return InstanceEngineService.execute(map, "deleteProcessInstance");
    }

    public static BpmResponseResult deleteFinishedProcessInstance(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInstanceId", processInstanceId);
        return InstanceEngineService.execute(map, "deleteFinishedProcessInstance");
    }

    public static BpmResponseResult deleteProcessInstanceByBusinessKey(String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessKey", businessKey);
        return InstanceEngineService.execute(map, "deleteProcessInstanceByBusinessKey");
    }

    public static BpmResponseResult queryFinishedProcessInstance(String processDefinitionKey, String businessKey, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("businessKey", businessKey);
        map.put("page", page);
        map.put("rows", rows);
        return InstanceEngineService.execute(map, "queryFinishedProcessInstance");
    }

    public static BpmResponseResult queryProcessInstanceCompleteState(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInstanceId", processInstanceId);
        return InstanceEngineService.execute(map, "queryProcessInstanceCompleteState");
    }

    public static BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessKey", businessKey);
        return InstanceEngineService.execute(map, "queryProcessInstanceCompleteStateByBusinessKey");
    }

    public static BpmResponseResult getProcessTrace(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInstanceId", processInstanceId);
        return InstanceEngineService.execute(map, "getProcessTrace");
    }

    public static BpmResponseResult validateDeleteByBusinessKey(String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessKey", businessKey);
        return InstanceEngineService.execute(map, "validateDeleteByBusinessKey");
    }

    public static BpmResponseResult getAllProcessTrace(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInstanceId", processInstanceId);
        return InstanceEngineService.execute(map, "getAllProcessTrace");
    }

    public static BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, int page, int size) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessKey", businessKey);
        map.put("page", page);
        map.put("size", size);
        return InstanceEngineService.execute(map, "getAllProcessTraceByBusinessKey");
    }

    public static BpmResponseResult queryProcessDefinitionByInstanceId(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInstanceId", processInstanceId);
        return InstanceEngineService.execute(map, "queryProcessDefinitionByInstanceId");
    }

    public static BpmResponseResult endProcess(String taskId, String userId, String reason) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("taskId", taskId);
        map.put("userId", userId);
        map.put("reason", reason);
        return InstanceEngineService.execute(map, "endProcess");
    }

    public static BpmResponseResult getCommentMessages(String businessKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessKey", businessKey);
        return InstanceEngineService.execute(map, "getCommentMessages");
    }

    private static BpmResponseResult execute(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + INSTANCE + url;
        String result = HttpUtil.get((String)finalUrl, map);
        return (BpmResponseResult)JSON.parseObject((String)result, BpmResponseResult.class);
    }
}

