/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.assignee.service.AssigneeService;
import com.jxdinfo.hussar.mobile.feign.MobileFeignInterface;
import com.jxdinfo.hussar.response.ApiResponse;
import com.jxdinfo.hussar.response.BpmResponseResult;
import com.jxdinfo.hussar.util.BpmConfigReadService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile"})
public class MobileController {
    @Autowired
    AssigneeService assigneeService;
    @Autowired
    private BpmConfigReadService bpmConfigReadService;
    @Autowired
    private MobileFeignInterface mobileFeignInterface;

    @RequestMapping(value={"/todoList"})
    public ApiResponse<?> todoList(@RequestBody Map<String, Object> body) {
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.todoList(body, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(body, "todoList", "/flowEvents/");
        if ("1".equals(bpmResponseResult.getCode())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", bpmResponseResult.getResult().getJSONObject(0).get((Object)"data"));
            map.put("count", bpmResponseResult.getResult().getJSONObject(0).get((Object)"count"));
            return ApiResponse.data(map);
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/doneList"})
    @ResponseBody
    public ApiResponse<?> doneList(@RequestBody Map<String, Object> body) {
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.doneList(body, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(body, "doneList", "/flowEvents/");
        if ("1".equals(bpmResponseResult.getCode())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", bpmResponseResult.getResult().getJSONObject(0).get((Object)"data"));
            map.put("count", bpmResponseResult.getResult().getJSONObject(0).get((Object)"count"));
            return ApiResponse.data(map);
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/queryProcess"})
    public ApiResponse<?> queryProcess() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.queryProcess(this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(map, "flowType", "/flowEvents/");
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.data(bpmResponseResult.getResult());
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/entrustList"})
    public Object entrustList(@RequestBody Map<String, Object> body) {
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.entrustList(body, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(body, "list", "/sysActEntrust/");
        if ("1".equals(bpmResponseResult.getCode())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", bpmResponseResult.getResult().getJSONObject(0).get((Object)"data"));
            map.put("count", bpmResponseResult.getResult().getJSONObject(0).get((Object)"count"));
            return ApiResponse.data(map);
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/saveEntrust"})
    public ApiResponse<?> saveEntrust(@RequestBody Map<String, Object> body) {
        String processId = "";
        List keys = (List)body.get("processDefinitionKey");
        for (int i = 0; i < keys.size(); ++i) {
            processId = processId + (String)keys.get(i) + ",";
        }
        String processName = "";
        List names = (List)body.get("processName");
        for (int i = 0; i < names.size(); ++i) {
            processName = processName + (String)names.get(i) + ",";
        }
        String consignor = String.valueOf(body.get("consignor"));
        String consignee = String.valueOf(body.get("consignee"));
        String consigneeName = String.valueOf(body.get("consigneeName"));
        String startTime = String.valueOf(body.get("startTime")).concat(" 00:00:00");
        String endTime = String.valueOf(body.get("endTime")).concat(" 23:59:59");
        String state = "1";
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        map.put("processId", processId);
        map.put("processName", processName);
        map.put("consignor", consignor);
        map.put("consignee", consignee);
        map.put("consigneeName", consigneeName);
        map.put("state", state);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.entrustList(map, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(map, "addBatch", "/sysActEntrust/");
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success(bpmResponseResult.getMsg());
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/deleteEntrust"})
    public ApiResponse<?> deleteEntrust(@RequestBody Map<String, Object> body) {
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.deleteEntrust(body, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(body, "delete", "/sysActEntrust/");
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success(bpmResponseResult.getMsg());
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/detailEntrust"})
    public ApiResponse<?> detailEntrust(@RequestBody Map<String, Object> body) {
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.detailEntrust(body, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(body, "detail", "/sysActEntrust/");
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.data(bpmResponseResult.getResult().getJSONObject(0));
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/updateEntrust"})
    public ApiResponse<?> updateEntrust(@RequestBody Map<String, Object> body) {
        String id = String.valueOf(body.get("id"));
        String consignee = String.valueOf(body.get("consignee"));
        String consigneeName = String.valueOf(body.get("consigneeName"));
        String startTime = String.valueOf(body.get("startTime")).length() > 10 ? String.valueOf(body.get("startTime")) : String.valueOf(body.get("startTime")).concat(" 00:00:00");
        String endTime = String.valueOf(body.get("endTime")).length() > 10 ? String.valueOf(body.get("endTime")) : String.valueOf(body.get("endTime")).concat(" 23:59:59");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("id", id);
        map.put("consignee", consignee);
        map.put("consigneeName", consigneeName);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.updateEntrust(map, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(map, "update", "/sysActEntrust/");
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success(bpmResponseResult.getMsg());
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/updateStateEntrust"})
    public ApiResponse<?> updateStateEntrust(@RequestBody Map<String, Object> body) {
        String tEntrustId = String.valueOf(body.get("id"));
        String state = "";
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        if ("1".equals(String.valueOf(body.get("state")))) {
            state = "0";
            map.put("state", state);
        } else {
            state = "1";
            map.put("state", state);
        }
        map.put("tEntrustId", tEntrustId);
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.updateStateEntrust(map, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(map, "updateState", "/sysActEntrust/");
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success(bpmResponseResult.getMsg());
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/urgeList"})
    public ApiResponse<?> urgeList(@RequestBody Map<String, Object> body) {
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.urgeList(body, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(body, "list", "/sysActEntrust/");
        if ("1".equals(bpmResponseResult.getCode())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", bpmResponseResult.getResult().getJSONObject(0).get((Object)"data"));
            map.put("count", bpmResponseResult.getResult().getJSONObject(0).get((Object)"count"));
            return ApiResponse.data(map);
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/urge"})
    public ApiResponse<?> urge(@RequestBody Map<String, String> body) {
        String processInsId = body.get("processInsId");
        String userId = body.get("userId");
        if (processInsId == null || userId == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("processInsId", processInsId);
        map.put("userId", userId);
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.urge(map, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(map, "urgeTask", "/flowEvents/");
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success(bpmResponseResult.getMsg());
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/revoke"})
    public ApiResponse<?> revoke(@RequestBody Map<String, String> body) {
        String taskId = body.get("taskId");
        String userId = body.get("userId");
        if (taskId == null || userId == null) {
            return ApiResponse.fail("\u64a4\u56de\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("historicTaskId", taskId);
        map.put("userId", userId);
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.entrustList(map, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(map, "revoke", "/flowEvents/");
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success(bpmResponseResult.getMsg());
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/ccList"})
    public ApiResponse<?> ccList(@RequestBody Map<String, Object> body) {
        BpmResponseResult bpmResponseResult = "openFeign".equals(this.bpmConfigReadService.getRequestType()) ? this.mobileFeignInterface.ccList(body, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher()) : this.execute(body, "list", "/ccTask/");
        if ("1".equals(bpmResponseResult.getCode())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", bpmResponseResult.getResult().getJSONObject(0).get((Object)"data"));
            map.put("count", bpmResponseResult.getResult().getJSONObject(0).get((Object)"count"));
            return ApiResponse.data(map);
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/user"})
    public ApiResponse<List<BpmTreeModel>> userTree(@RequestBody Map<String, Object> body) {
        String id = String.valueOf(body.get("id"));
        return ApiResponse.data(this.assigneeService.userTree(id));
    }

    private BpmResponseResult execute(Map<String, Object> map, String url, String type) {
        map.put("tenantId", this.bpmConfigReadService.getTenantId());
        map.put("tenantCipher", this.bpmConfigReadService.getTenantCipher());
        String finalUrl = this.bpmConfigReadService.getUrl() + type + url;
        String result = HttpUtil.get((String)finalUrl, map);
        return (BpmResponseResult)JSON.parseObject((String)result, BpmResponseResult.class);
    }
}

