/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.process.controller;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.response.ApiResponse;
import com.jxdinfo.hussar.util.LoadPropertyUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"bpmModel"})
public class HussarBpmProcessController {
    private static final String GOD_AXE = "/godaxeModel/";

    @RequestMapping(value={"/save"})
    public ApiResponse<?> saveDataInfo(@RequestBody Map<String, Object> body) {
        JSONObject object = new JSONObject();
        object.put("id", body.get("id") == null ? null : body.get("id").toString());
        object.put("data", body.get("data") == null ? null : body.get("data").toString());
        object.put("desc", body.get("desc") == null ? null : body.get("desc").toString());
        object.put("name", body.get("name") == null ? null : body.get("name").toString());
        object.put("type", body.get("type") == null ? null : body.get("type").toString());
        object.put("modelId", body.get("modelId") == null ? null : body.get("modelId").toString());
        object.put("identity", body.get("identity") == null ? null : body.get("identity").toString());
        object.put("procDefId", body.get("procDefId") == null ? null : body.get("procDefId").toString());
        object.put("isCreate", body.get("isCreate") == null ? null : body.get("isCreate").toString());
        return HussarBpmProcessController.executeSave(object, "save");
    }

    @RequestMapping(value={"/publish"})
    public ApiResponse<?> genWorkFlowXml(@RequestBody String processIdentityKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processIdentityKey", processIdentityKey);
        return HussarBpmProcessController.execute(map, "publish");
    }

    @RequestMapping(value={"/update"})
    public ApiResponse<?> updateWorkFlow(String processIdentityKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processIdentityKey", processIdentityKey);
        return HussarBpmProcessController.execute(map, "update");
    }

    @RequestMapping(value={"/deleteModel"})
    public ApiResponse<?> deleteModel(String identity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identity", identity);
        return HussarBpmProcessController.execute(map, "deleteModel");
    }

    @RequestMapping(value={"/getAllModel"})
    public ApiResponse<?> getAllModel() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return HussarBpmProcessController.execute(map, "getAllModel");
    }

    private static ApiResponse<?> executeSave(JSONObject object, String url) {
        LoadPropertyUtils loadPropertyUtils = new LoadPropertyUtils();
        Map<String, String> bpmServerInfo = loadPropertyUtils.getBpmServerInfo();
        object.put("tenantId", (Object)bpmServerInfo.get("tenantId"));
        object.put("tenantCipher", (Object)bpmServerInfo.get("tenantCipher"));
        String finalUrl = bpmServerInfo.get("url") + GOD_AXE + url;
        String result = HttpRequest.put((String)finalUrl).form((Map)object).execute().body();
        return (ApiResponse)JSON.parseObject((String)result, ApiResponse.class);
    }

    private static ApiResponse<?> execute(Map<String, Object> map, String url) {
        LoadPropertyUtils loadPropertyUtils = new LoadPropertyUtils();
        Map<String, String> bpmServerInfo = loadPropertyUtils.getBpmServerInfo();
        map.put("tenantId", bpmServerInfo.get("tenantId"));
        map.put("tenantCipher", bpmServerInfo.get("tenantCipher"));
        String finalUrl = bpmServerInfo.get("url") + GOD_AXE + url;
        String result = HttpUtil.get((String)finalUrl, map);
        return (ApiResponse)JSON.parseObject((String)result, ApiResponse.class);
    }
}

