/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.flowchar;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.flowchar.feign.FlowChartFeignInterface;
import com.jxdinfo.hussar.util.BpmConfigReadService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowChart"})
public class FlowChartController {
    private static final String FLOW_CHART = "/flowChart/";
    @Autowired
    private BpmConfigReadService bpmConfigReadService;
    @Autowired
    private FlowChartFeignInterface flowChartFeignInterface;

    @RequestMapping(value={"/historyList"})
    public Map<String, Object> historyList(String processInstanceId, String businessKey) {
        if ("openFeign".equals(this.bpmConfigReadService.getRequestType())) {
            return this.flowChartFeignInterface.historyList(processInstanceId, businessKey, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        String result = this.execute(map, "historyList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @RequestMapping(value={"/historyMicroList"})
    public Map<String, Object> historyMicroList(String processInstanceId, String businessKey) {
        if ("openFeign".equals(this.bpmConfigReadService.getRequestType())) {
            return this.flowChartFeignInterface.historyMicroList(processInstanceId, businessKey, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        String result = this.execute(map, "historyMicroList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @RequestMapping(value={"/getProcessDetail"})
    public JSONObject getProcessDetail(String processInstanceId, String businessKey) {
        if ("openFeign".equals(this.bpmConfigReadService.getRequestType())) {
            return this.flowChartFeignInterface.getProcessDetail(processInstanceId, businessKey, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        String result = this.execute(map, "getProcessDetail");
        return (JSONObject)JSON.parseObject((String)result, JSONObject.class);
    }

    @RequestMapping(value={"/getProcessCompleteDetail"})
    public JSONArray getProcessCompleteDetail(String processInstanceId, String businessKey) {
        if ("openFeign".equals(this.bpmConfigReadService.getRequestType())) {
            return this.flowChartFeignInterface.getProcessCompleteDetail(processInstanceId, businessKey, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        String result = this.execute(map, "getProcessCompleteDetail");
        return (JSONArray)JSON.parseObject((String)result, JSONArray.class);
    }

    @RequestMapping(value={"/subProcessList"})
    public Map<String, Object> subProcessList(String supProcessInstId, String businessKey, String taskDefinitionKey, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="9999") Integer limit) {
        if ("openFeign".equals(this.bpmConfigReadService.getRequestType())) {
            return this.flowChartFeignInterface.subProcessList(supProcessInstId, businessKey, taskDefinitionKey, page, limit, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supProcessInstId", supProcessInstId);
        map.put("businessKey", businessKey);
        map.put("taskDefinitionKey", taskDefinitionKey);
        map.put("page", page);
        map.put("limit", limit);
        String result = this.execute(map, "subProcessList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @RequestMapping(value={"/getProcessInfoByFile"})
    public JSONObject getProcessInfoByFile(String processIdentityKey, String processDefKey) {
        if ("openFeign".equals(this.bpmConfigReadService.getRequestType())) {
            return this.flowChartFeignInterface.getProcessInfoByFile(processIdentityKey, processDefKey, this.bpmConfigReadService.getTenantId(), this.bpmConfigReadService.getTenantCipher());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processIdentityKey", processIdentityKey);
        map.put("processDefKey", processDefKey);
        String result = this.execute(map, "getProcessInfoByFile");
        return (JSONObject)JSON.parseObject((String)result, JSONObject.class);
    }

    private String execute(Map<String, Object> map, String url) {
        map.put("tenantId", this.bpmConfigReadService.getTenantId());
        map.put("tenantCipher", this.bpmConfigReadService.getTenantCipher());
        String finalUrl = this.bpmConfigReadService.getUrl() + FLOW_CHART + url;
        return HttpUtil.get((String)finalUrl, map);
    }
}

