/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.processdiagram;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.util.BpmConfigReadService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hussarBpmDiagram"})
public class HussarBpmDiagramController {
    private static final String HUSSAR_BPM_DIAGRAM = "/flowChart/";
    @Autowired
    private BpmConfigReadService bpmConfigReadService;

    @RequestMapping(value={"/processdisplay"})
    public String processpicTab(Model model, HttpServletRequest request) {
        model.addAttribute("processId", (Object)request.getParameter("processInstId"));
        model.addAttribute("contextPath", (Object)request.getContextPath());
        return "/hussar/bpm/processdisplay.html";
    }

    @RequestMapping(value={"/subProcessDisplay"})
    public String subProcessDisplay(Model model, HttpServletRequest request) {
        model.addAttribute("processId", (Object)request.getParameter("processInstId"));
        model.addAttribute("contextPath", (Object)request.getContextPath());
        return "/hussar/bpm/subProcessDisplay.html";
    }

    @RequestMapping(value={"/historyList"})
    @ResponseBody
    public Map<String, Object> historyList(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("processInstanceId", processInstanceId);
        return (Map)JSON.parseObject((String)this.execute(map, "historyList"), Map.class);
    }

    @RequestMapping(value={"/getProcessDetail"})
    @ResponseBody
    public Map<String, Object> getProcessDetail(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("processInstanceId", processInstanceId);
        return (Map)JSON.parseObject((String)this.execute(map, "getProcessDetail"), Map.class);
    }

    @RequestMapping(value={"/getProcessCompleteDetail"})
    @ResponseBody
    public JSONArray getProcessCompleteDetail(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("processInstanceId", processInstanceId);
        return JSON.parseArray((String)this.execute(map, "getProcessCompleteDetail"));
    }

    @RequestMapping(value={"/subProcessList"})
    @ResponseBody
    public Map<String, Object> subProcessList(String supProcessInstId, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="9999") Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supProcessInstId", supProcessInstId);
        map.put("page", page);
        map.put("limit", limit);
        return (Map)JSON.parseObject((String)this.execute(map, "subProcessList"), Map.class);
    }

    private String execute(Map<String, Object> map, String url) {
        map.put("tenantId", this.bpmConfigReadService.getTenantId());
        map.put("tenantCipher", this.bpmConfigReadService.getTenantCipher());
        String finalUrl = this.bpmConfigReadService.getUrl() + HUSSAR_BPM_DIAGRAM + url;
        return HttpUtil.get((String)finalUrl, map);
    }
}

