/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.assignee.controller;

import com.jxdinfo.hussar.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.assignee.service.AssigneeService;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assignee"})
public class AssigneeController {
    @Autowired
    AssigneeService assigneeService;

    @RequestMapping(value={"/user"})
    public List<BpmTreeModel> userTree(@RequestParam(value="id", defaultValue="11") String id) {
        return this.assigneeService.userTree(id);
    }

    @RequestMapping(value={"/dept"})
    public List<BpmTreeModel> deptTree(@RequestParam String id) {
        return this.assigneeService.deptTree(id);
    }

    @RequestMapping(value={"/role"})
    public List<BpmTreeModel> roleTree() {
        return this.assigneeService.roleTree();
    }

    @RequestMapping(value={"/userDetail"})
    public List<BpmTreeModel> userDetail(String userIds) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return null;
        }
        return this.assigneeService.userDetail(Arrays.asList(userIds.split(",")));
    }

    @RequestMapping(value={"/userDeptDetail"})
    public List<BpmTreeModel> userDeptDetail(String userId) {
        if (StringUtils.isEmpty((Object)userId)) {
            return null;
        }
        return this.assigneeService.userDeptDetail(userId);
    }

    @RequestMapping(value={"/getCandidateUser"})
    public List<String> getCandidateUser(String condition, Integer securityLevel) {
        return this.assigneeService.getCandidateUser(condition, securityLevel);
    }

    @RequestMapping(value={"/getRealCondition"})
    public String getRealCondition(String condition) {
        return this.assigneeService.getRealCondition(condition);
    }

    @RequestMapping(value={"/getSecurityLevel"})
    public String getSecurityLevel(String userId) {
        return String.valueOf(this.assigneeService.getSecurityLevel(userId));
    }
}

