/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.taskmanage;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.assignee.service.AssigneeService;
import com.jxdinfo.hussar.engine.DefinitionEngineService;
import com.jxdinfo.hussar.engine.SysActEntrustService;
import com.jxdinfo.hussar.response.ApiResponse;
import com.jxdinfo.hussar.response.BpmResponseResult;
import com.jxdinfo.hussar.util.BpmConfigRead;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/entrust"})
public class EntrustListController {
    private static final String ENTRUST = "/sysActEntrust/";
    @Autowired
    AssigneeService assigneeService;

    @RequestMapping(value={"/list"})
    public Object initList(@RequestBody Map<String, Object> body) {
        String userId = String.valueOf(body.get("userId"));
        String processId = String.valueOf(body.get("processDefinitionKey"));
        String state = String.valueOf(body.get("state"));
        String page = String.valueOf(body.get("curr"));
        String size = String.valueOf(body.get("nums"));
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processId", processId);
        map.put("userId", userId);
        map.put("state", state);
        map.put("page", page);
        map.put("size", size);
        return EntrustListController.execute(map, "list");
    }

    @RequestMapping(value={"/history"})
    public Object history(@RequestBody Map<String, Object> body) {
        String userId = String.valueOf(body.get("userId"));
        Integer page = (Integer)body.get("curr");
        Integer size = (Integer)body.get("nums");
        HashMap map = new HashMap(8);
        return SysActEntrustService.getEntrustHistory(userId, page, size);
    }

    @RequestMapping(value={"/save"})
    public Object saveEntrust(@RequestBody Map<String, Object> body) {
        String processId = "";
        List keys = (List)body.get("processDefinitionKey");
        for (int i = 0; i < keys.size(); ++i) {
            processId = processId + (String)keys.get(i) + ",";
        }
        String processName = "";
        List names = (List)body.get("processName");
        for (int i = 0; i < names.size(); ++i) {
            processName = processName + (String)names.get(i) + ",";
        }
        String consignor = String.valueOf(body.get("consignor"));
        String consignorName = String.valueOf(body.get("consignorName"));
        String consignee = String.valueOf(body.get("consignee"));
        String consigneeName = String.valueOf(body.get("consigneeName"));
        String startTime = String.valueOf(body.get("startTime")).concat(" 00:00:00");
        String endTime = String.valueOf(body.get("endTime")).concat(" 23:59:59");
        String companyCode = String.valueOf(body.get("companyCode"));
        String companyName = String.valueOf(body.get("companyName"));
        String state = "1";
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        map.put("processId", processId);
        map.put("processName", processName);
        map.put("consignor", consignor);
        map.put("consignorName", consignorName);
        map.put("consignee", consignee);
        map.put("consigneeName", consigneeName);
        map.put("state", state);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("companyCode", companyCode);
        map.put("companyName", companyName);
        return EntrustListController.execute(map, "addBatch");
    }

    @RequestMapping(value={"/delete"})
    public Object deleteEntrust(@RequestBody Map<String, Object> body) {
        String tEntrustId = String.valueOf(body.get("tEntrustId"));
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("tEntrustId", tEntrustId);
        return EntrustListController.execute(map, "delete");
    }

    @RequestMapping(value={"/detail"})
    public Object detailEntrust(@RequestBody Map<String, Object> body) {
        String tEntrustId = String.valueOf(body.get("tEntrustId"));
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("tEntrustId", tEntrustId);
        return EntrustListController.execute(map, "detail");
    }

    @RequestMapping(value={"/update"})
    public Object updateEntrust(@RequestBody Map<String, Object> body) {
        String id = String.valueOf(body.get("id"));
        String consignee = String.valueOf(body.get("consignee"));
        String consigneeName = String.valueOf(body.get("consigneeName"));
        String startTime = String.valueOf(body.get("startTime")).length() > 10 ? String.valueOf(body.get("startTime")) : String.valueOf(body.get("startTime")).concat(" 00:00:00");
        String endTime = String.valueOf(body.get("endTime")).length() > 10 ? String.valueOf(body.get("endTime")) : String.valueOf(body.get("endTime")).concat(" 23:59:59");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("id", id);
        map.put("consignee", consignee);
        map.put("consigneeName", consigneeName);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return EntrustListController.execute(map, "update");
    }

    @RequestMapping(value={"/updateState"})
    public Object updateStateEntrust(@RequestBody Map<String, Object> body) {
        String tEntrustId = String.valueOf(body.get("id"));
        String state = "";
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        if ("1".equals(String.valueOf(body.get("state")))) {
            state = "0";
            map.put("state", state);
        } else {
            state = "1";
            map.put("state", state);
        }
        map.put("tEntrustId", tEntrustId);
        return EntrustListController.execute(map, "updateState");
    }

    @RequestMapping(value={"/user"})
    public ApiResponse<List<BpmTreeModel>> userTree(@RequestBody Map<String, Object> body) {
        String id = String.valueOf(body.get("id"));
        return ApiResponse.data(this.assigneeService.userTree(id));
    }

    @RequestMapping(value={"/queryProcess"})
    public ApiResponse<?> queryProcess() {
        BpmResponseResult bpmResponseResult = DefinitionEngineService.queryProcess();
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.data(bpmResponseResult);
        }
        return ApiResponse.data("");
    }

    private static BpmResponseResult execute(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + ENTRUST + url;
        String result = HttpUtil.get((String)finalUrl, map);
        return (BpmResponseResult)JSON.parseObject((String)result, BpmResponseResult.class);
    }
}

