var definitionId = $("#processId").val();
// 全屏高度
var height = 400;
//1.获取canvas元素
var cnv = document.getElementById("canvas");

var contextPath = getContextPath();
// 绘制图片
function createImg(height) {
    cnv.width = $(window) .width();
    cnv.height = $(window).height() - height;
    //获取上下文环境对象
    var cxt = cnv.getContext("2d");
    $.ajax({
        type: "POST",
        url: contextPath+"/hussarBpmDiagram/getProcessDetail",
        dataType: "json",
        data: {
            processInstanceId: definitionId
        },
        success: function (data) {
            window.tools.createImg(cnv,data,null);
        }
    });
}
// 工作流全屏
function toFullScreen(data){
    if(height === 400){
        height = 0;
        data.classList.remove('fullScreen1');
        data.classList.add('fullScreen2');
    }else {
        height = 400;
        data.classList.remove('fullScreen2');
        data.classList.add('fullScreen1');
    }
    createImg(height);
}
function activeOrNot(data) {
    var self = data.parentNode;
    var className = self.className;
    if (className.indexOf('active-title') > -1) {
        self.classList.remove('active-title');
    } else {
        self.classList.add('active-title');
    }
}
$(function () {
    // 节点信息
    var dataPop = [];
    $.ajax({
        type: "POST",
        url: contextPath+"/hussarBpmDiagram/getProcessCompleteInfo",
        dataType: "json",
        data: {
            processInstanceId: definitionId
        },
        success: function (data) {
            dataPop =  data
        }
    });
    createImg(height);
    // 监听
    cnv.addEventListener("mousemove",function () {
        rectCheckMouse(window.tools.get_canvasMouse(event,cnv),dataPop);
    });

    var flag = 0;
    // 监听触发
    function rectCheckMouse(mouse,data) {
        var sub_top = $("#canvas").css("marginTop").replace('px', '');
        var sub_Left = $("#canvas").css("marginLeft").replace('px', '');
        for(var i = 0;i<data.length;i++){
            var item = data[i];
            if(mouse.x> item.x &&  mouse.x<(item.x + item.width ) && mouse.y> item.y&& mouse.y <(item.y + item.height + 10)){
                flag = 1;
                var inner="";
                if(item.state === "finish"){
                    inner += "<div class='ul-info'>"
                    for (var n = 0;n<item.completeInfo.length;n++){
                        if(n==0){
                            inner += "<div class='ul-title active-title'><span class='ul-icon'></span><span>审核详情</span><span class='ul-arrow' onclick='activeOrNot(this)'></span></div>" +
                                "<ul class='ul-body'>" +
                                "<li>开始时间：<span>" + item.completeInfo[n].startTime + "</span></li>" +
                                "<li>结束时间：<span>" + item.completeInfo[n].endTime + "</span></li>" +
                                "<li>处&nbsp;&nbsp;理&nbsp;&nbsp;人：<span>" + item.completeInfo[n].assignee + "</span></li>" +
                                "<li>" +
                                "办理意见：<span>" + item.completeInfo[n].comments + "</span>" +
                                "</li>" +
                                "</ul>"
                        } else {
                            inner += "<div class='ul-title'><span class='ul-icon'></span><span>审核详情</span><span class='ul-arrow' onclick='activeOrNot(this)'></span></div>" +
                                "<ul class='ul-body'>" +
                                "<li>开始时间：<span>" + item.completeInfo[n].startTime + "</span></li>" +
                                "<li>结束时间：<span>" + item.completeInfo[n].endTime + "</span></li>" +
                                "<li>处&nbsp;&nbsp;理&nbsp;&nbsp;人：<span>" + item.completeInfo[n].assignee + "</span></li>" +
                                "<li>" +
                                "办理意见：<span>" + item.completeInfo[n].comments + "</span>" +
                                "</li>" +
                                "</ul>"
                        }
                    }
                    inner += "</div>"
                }else if(item.state === "now"){
                    inner += "<div class='ul-title active-title'><span class='ul-icon'></span><span>审核详情</span><span class='ul-arrow' onclick='activeOrNot(this)'></span></div>" +
                        "<ul class='ul-body'>" +
                        "<li>创建时间：<span>" + item.startTime + "</span></li>" +
                        "<li>接&nbsp;&nbsp;收&nbsp;&nbsp;人：<span>" + item.assignee + "</span></li>" +
                        "</ul></div>";
                }
                var top = (item.y + item.height) + 10 + parseInt(sub_top)+cnv.offsetTop-
                    document.body.scrollTop - document.documentElement.scrollTop;
                var left = item.x + parseInt(sub_Left) + (item.width-260)/2 +cnv.offsetLeft-
                    document.body.scrollLeft- document.documentElement.scrollLeft;
                $(".pop-win").html(inner).css({"top":top < 0 ? 5: top,
                    "left": left < 0 ? 5 : left}).show();
                break;
            }else{
                flag = 0;
            }
        }
        if(flag===0){
            $(".pop-win").hide()
        }
    }
});
