/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.waterInstallation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.repository.WaterInstallationRepository;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.kgbase.waterInstallation.model.Neo4jWaterNode;
import com.jxdinfo.hussar.kgbase.waterInstallation.service.IWaterInstallationService;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WaterInstallationServiceImpl
implements IWaterInstallationService {
    @Resource
    private WaterInstallationRepository waterInstallationRepository;
    @Value(value="${water-installation.ip}")
    private String waterInstallationIp;
    @Value(value="${water-installation.port}")
    private String waterInstallationPort;

    public JSONObject getDefectHistoryByName(String name) {
        List<Map<String, Object>> resultList = this.waterInstallationRepository.getDefectHistoryByName(name);
        JSONObject resultObj = new JSONObject();
        List<Object> nodeList = new ArrayList();
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        for (Map<String, Object> map : resultList) {
            Object end = map.get("m");
            if (!(end instanceof NodeModel)) continue;
            nodes.add((NodeModel)end);
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        ArrayList<Neo4jWaterNode> nodeWaterList = new ArrayList<Neo4jWaterNode>();
        double smart = 0.3;
        double biger = 0.6;
        BigDecimal smartB = new BigDecimal(smart);
        BigDecimal bigerB = new BigDecimal(biger);
        for (Neo4jBasicNode neo4jBasicNode : nodeList) {
            Neo4jWaterNode node = new Neo4jWaterNode();
            node.setId(neo4jBasicNode.getId());
            node.setNodeType(neo4jBasicNode.getNodeType());
            double a = Math.random();
            BigDecimal aB = new BigDecimal(a);
            if (aB.compareTo(smartB) < 0) {
                node.setLabel(neo4jBasicNode.getLabel() + "\uff08\u5904\u7406\u4e2d\u3001\u4e09\u7c7b\u7f3a\u9677\uff09");
            } else if (aB.compareTo(smartB) >= 0 && aB.compareTo(bigerB) < 0) {
                node.setLabel(neo4jBasicNode.getLabel() + "\uff08\u5f85\u9a8c\u6536\u3001\u4e09\u7c7b\u7f3a\u9677\uff09");
            } else {
                node.setLabel(neo4jBasicNode.getLabel() + "\uff08\u5df2\u6d88\u7f3a\u3001\u4e09\u7c7b\u7f3a\u9677\uff09");
            }
            node.setProperties(neo4jBasicNode.getProperties());
            node.setUrl("http://" + this.waterInstallationIp + ":" + this.waterInstallationPort + "/#/kgApplication/kgViews?businessId=" + neo4jBasicNode.getId());
            nodeWaterList.add(node);
        }
        resultObj.put("nodes", nodeWaterList);
        return resultObj;
    }

    public JSONObject getSimilarDefectByDescription(String description) {
        JSONObject resultObj = new JSONObject();
        List<Map<String, Object>> resultList = this.waterInstallationRepository.getSimilarDefectByDescription(description);
        ArrayList<Neo4jBasicNode> nodeList = new ArrayList();
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        for (Map<String, Object> map : resultList) {
            Object end = map.get("n");
            if (!(end instanceof NodeModel)) continue;
            nodes.add((NodeModel)end);
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        List<Neo4jWaterNode> nodeWaterList = this.changeToNeo4jWaterNode(nodeList, true);
        resultObj.put("defectList", nodeWaterList);
        Integer[] idArr = new Integer[nodes.size()];
        int i = 0;
        for (NodeModel n : nodes) {
            idArr[i] = Integer.valueOf(n.getId().toString());
            ++i;
        }
        List<Map<String, Object>> defectClassificationList = this.waterInstallationRepository.getDefectClassificationByDefectId(idArr);
        ArrayList<Neo4jBasicNode> classificationList = new ArrayList();
        ArrayList<NodeModel> classifications = new ArrayList<NodeModel>();
        for (Map<String, Object> map : defectClassificationList) {
            Object end = map.get("m");
            if (!(end instanceof NodeModel)) continue;
            classifications.add((NodeModel)end);
        }
        classificationList = Neo4jUtil.changeToNeo4jBasicNode(classifications);
        List<Neo4jWaterNode> classificationWaterList = this.changeToNeo4jWaterNode(classificationList, false);
        resultObj.put("defectClassificationList", classificationWaterList);
        List<Map<String, Object>> defectCauseList = this.waterInstallationRepository.getDefectCauseByDefectId(idArr);
        ArrayList<Neo4jBasicNode> causeList = new ArrayList();
        ArrayList<NodeModel> causes = new ArrayList<NodeModel>();
        for (Map<String, Object> map : defectCauseList) {
            Object end = map.get("m");
            if (!(end instanceof NodeModel)) continue;
            causes.add((NodeModel)end);
        }
        causeList = Neo4jUtil.changeToNeo4jBasicNode(causes);
        List<Neo4jWaterNode> causeWaterList = this.changeToNeo4jWaterNode(causeList, false);
        resultObj.put("defectCauseList", causeWaterList);
        List<Map<String, Object>> defectSchemeList = this.waterInstallationRepository.getDefectSchemeByDefectId(idArr);
        ArrayList<Neo4jBasicNode> schemeList = new ArrayList();
        ArrayList<NodeModel> schemes = new ArrayList<NodeModel>();
        for (Map<String, Object> map : defectSchemeList) {
            Object end = map.get("m");
            if (!(end instanceof NodeModel)) continue;
            schemes.add((NodeModel)end);
        }
        schemeList = Neo4jUtil.changeToNeo4jBasicNode(schemes);
        List<Neo4jWaterNode> schemeWaterList = this.changeToNeo4jWaterNode(schemeList, false);
        resultObj.put("defectSchemeList", schemeWaterList);
        return resultObj;
    }

    public JSONObject totalQuery(String id) {
        if (id == null || StringUtil.isEmpty((Object)id)) {
            id = "3F73A1CC-4911-FB0F-BE6E-58EDA39791100B7606";
        }
        JSONObject resultObj = new JSONObject();
        List<Object> nodeList = new ArrayList();
        List<Object> relationShipList = new ArrayList();
        List<Map<String, Object>> resultList = this.waterInstallationRepository.getNodesAndRelationshipsWithId(Integer.valueOf(id));
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map<String, Object> map : resultList) {
            Object relationship;
            Object end;
            Object start = map.get("a");
            if (start instanceof NodeModel) {
                nodes.add((NodeModel)start);
            }
            if ((end = map.get("b")) instanceof NodeModel) {
                nodes.add((NodeModel)end);
            }
            if (!((relationship = map.get("r")) instanceof ArrayList)) continue;
            ArrayList relationshipModels = (ArrayList)relationship;
            for (Object model : relationshipModels) {
                if (!(model instanceof RelationshipModel)) continue;
                relationships.add((RelationshipModel)model);
            }
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        relationShipList = Neo4jUtil.changeToNeo4jQueryRelation(relationships);
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }

    private List<Neo4jWaterNode> changeToNeo4jWaterNode(List<Neo4jBasicNode> nodeList, boolean flag) {
        ArrayList<Neo4jWaterNode> nodeWaterList = new ArrayList<Neo4jWaterNode>();
        double smart = 0.3;
        double biger = 0.6;
        BigDecimal smartB = new BigDecimal(smart);
        BigDecimal bigerB = new BigDecimal(biger);
        for (Neo4jBasicNode i : nodeList) {
            Neo4jWaterNode node = new Neo4jWaterNode();
            node.setId(i.getId());
            node.setNodeType(i.getNodeType());
            if (flag) {
                double a = Math.random();
                BigDecimal aB = new BigDecimal(a);
                if (aB.compareTo(smartB) < 0) {
                    node.setLabel(i.getLabel() + "\uff08\u5904\u7406\u4e2d\uff09");
                } else if (aB.compareTo(smartB) >= 0 && aB.compareTo(bigerB) < 0) {
                    node.setLabel(i.getLabel() + "\uff08\u5f85\u9a8c\u6536\uff09");
                } else {
                    node.setLabel(i.getLabel() + "\uff08\u5df2\u6d88\u7f3a\uff09");
                }
            } else {
                node.setLabel(i.getLabel());
            }
            node.setProperties(i.getProperties());
            node.setUrl("http://" + this.waterInstallationIp + ":" + this.waterInstallationPort + "/#/kgApplication/kgViews?businessId=" + i.getId());
            nodeWaterList.add(node);
        }
        return nodeWaterList;
    }
}

