/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.labelingmanage.service.impl;

import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.changeToPdfThread;
import com.jxdinfo.hussar.kgbase.labelingmanage.service.IPreviewAttachmentManagerService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class PreviewAttachmentManagerServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements IPreviewAttachmentManagerService {
    private static Logger logger = LogManager.getLogger(PreviewAttachmentManagerServiceImpl.class);
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private AttachmentManagerService baseAttachmentManagerService;
    private static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 100, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());

    public AttachmentManagerModelVo getByFileId(String fileId) {
        if (ToolUtil.isEmpty((Object)fileId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById((Serializable)((Object)fileId));
        Long id = attachmentModel.getId();
        String fileName = attachmentModel.getAttachmentName();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        String path = this.hussarConfig.getFileUploadPath() + id + prefix;
        File file = new File(path);
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        attachmentManagerModelVo.setId(id);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(file.length()));
        return attachmentManagerModelVo;
    }

    public ApiResponse<AttachmentManagerModelVo> uploadfileWithDrag(MultipartHttpServletRequest multipartRequest) throws Exception {
        if (ToolUtil.isEmpty((Object)multipartRequest)) {
            throw new BaseException("\u4e0a\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        multipartRequest.setCharacterEncoding("UTF-8");
        new HashMap();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        Long businessId = 0L;
        if (ToolUtil.isNotEmpty((Object)multipartRequest.getParameter("businessId"))) {
            businessId = Long.valueOf(multipartRequest.getParameter("businessId"));
        }
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator var7 = map.values().iterator();
        while (var7.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)var7.next();
        }
        if (ToolUtil.isNotEmpty(multipartFile)) {
            String fileName = multipartFile.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            try {
                String fileSavePath = this.hussarConfig.getFileUploadPath();
                AttachmentManagerModel attachment = new AttachmentManagerModel();
                attachment.setBusinessId(businessId);
                attachment.setAttachmentName(fileName);
                attachment.setAttachmentType(suffix.replace(".", ""));
                SecurityUser user = BaseSecurityUtil.getUser();
                if (user != null) {
                    attachment.setUploadPer(user.getId());
                }
                attachment.setAttachmentDir(fileSavePath);
                attachment.setUploadDate(LocalDateTime.now());
                Long attachmentId = this.baseAttachmentManagerService.saveAttachment(attachment);
                multipartFile.transferTo(new File(fileSavePath + attachmentId + suffix));
                attachmentManagerModelVo.setId(attachmentId);
                attachmentManagerModelVo.setFileName(fileName);
                threadPoolExecutor.execute((Runnable)new changeToPdfThread(attachmentId.toString()));
            }
            catch (IOException var15) {
                logger.error("errorMessage:{}", (Object)var15.getMessage(), (Object)var15);
                throw new BaseException(BizExceptionEnum.UPLOAD_ERROR.getMessage());
            }
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }
}

