/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.kbqa.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.kbqa.dao.SynonymManagementMapper;
import com.jxdinfo.hussar.kgbase.kbqa.model.dto.SynonymManagementDTO;
import com.jxdinfo.hussar.kgbase.kbqa.model.po.SynonymManagement;
import com.jxdinfo.hussar.kgbase.kbqa.service.IKbqaService;
import com.jxdinfo.hussar.kgbase.kbqa.service.ISynonymManagementService;
import com.jxdinfo.hussar.kgbase.neo4j.repository.BluePrintRepository;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SynonymManagementServiceImpl
extends ServiceImpl<SynonymManagementMapper, SynonymManagement>
implements ISynonymManagementService {
    @Resource
    private SynonymManagementMapper synonymManagementMapper;
    @Resource
    private BluePrintRepository bluePrintRepository;
    @Resource
    private IKbqaService iKbqaService;

    public SynonymManagement addSynonym(SynonymManagement synonymManagement) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"SYNONYM_WORD", (Object)synonymManagement.getSynonymWord());
        qw.eq((Object)"DEL_FLAG", (Object)"0");
        if (CustomDictionary.get((String)synonymManagement.getSynonymWord()) != null) {
            throw new HussarException("\u6838\u5fc3\u8bcd\u5178\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
        }
        if (synonymManagement.getId() != null && !StringUtil.isEmpty((Object)synonymManagement.getId())) {
            SynonymManagement originSynonym;
            if (BaseSecurityUtil.getUser() != null) {
                synonymManagement.setLastEditor(BaseSecurityUtil.getUser().getUserId());
            }
            if ((originSynonym = (SynonymManagement)this.getById((Serializable)((Object)synonymManagement.getId()))).getSynonymWord().equals(synonymManagement.getSynonymWord())) {
                this.updateById(synonymManagement);
            } else {
                if (this.list((Wrapper)qw).size() > 0) {
                    throw new HussarException("\u540c\u4e49\u8bcd\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
                }
                this.updateById(synonymManagement);
            }
        } else {
            if (this.list((Wrapper)qw).size() > 0) {
                throw new HussarException("\u540c\u4e49\u8bcd\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
            }
            if (BaseSecurityUtil.getUser() != null) {
                synonymManagement.setCreator(BaseSecurityUtil.getUser().getUserId());
            }
            this.save(synonymManagement);
        }
        this.iKbqaService.dictUpdate();
        return synonymManagement;
    }

    public boolean deleteSynonym(String ids) {
        String[] idArr = ids.split(",");
        try {
            this.removeByIds(Arrays.asList(idArr));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return false;
        }
        this.iKbqaService.dictUpdate();
        return false;
    }

    public Page<SynonymManagement> list(SynonymManagementDTO dto) {
        Page page = new Page();
        if (dto.getCurrent() == null) {
            dto.setCurrent(Integer.valueOf(1));
        }
        if (dto.getSize() == null) {
            dto.setSize(Integer.valueOf(10));
        }
        page.setCurrent((long)dto.getCurrent().intValue());
        page.setSize((long)dto.getSize().intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (dto.getKeyword() != null && !StringUtil.isEmpty((Object)dto.getKeyword())) {
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"SYNONYM_WORD", (Object)dto.getKeyword())).or()).like((Object)"TARGET_WORD", (Object)dto.getKeyword());
            });
        }
        if (dto.getWordType() != null && !StringUtil.isEmpty((Object)dto.getWordType())) {
            queryWrapper.eq((Object)"WORD_TYPE", (Object)dto.getWordType());
        }
        queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        ((QueryWrapper)queryWrapper.orderByDesc((Object)"LAST_TIME")).orderByDesc((Object)"CREATE_TIME");
        page = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        return page;
    }

    public SynonymManagement getTargetBySynonym(String id, String synonym) {
        try {
            QueryWrapper qw = new QueryWrapper();
            if (id != null && !StringUtil.isEmpty((Object)id)) {
                qw.ne((Object)"ID", (Object)id);
            }
            qw.eq((Object)"SYNONYM_WORD", (Object)synonym);
            qw.eq((Object)"DEL_FLAG", (Object)"0");
            return (SynonymManagement)this.getOne((Wrapper)qw);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<SynonymManagement> getWordsFromVacab(String word, String wordType) {
        List<Object> synonymManagements = new ArrayList<SynonymManagement>();
        switch (wordType) {
            case "ent": {
                List<Map<String, Object>> labels = this.bluePrintRepository.getAllLables();
                for (Map<String, Object> map : labels) {
                    String label = String.valueOf(map.get("label"));
                    if (!label.contains(word) && !label.equals(word)) continue;
                    SynonymManagement synonym = new SynonymManagement();
                    synonym.setSynonymWord(word);
                    synonym.setTargetWord(label);
                    synonym.setWordType("ent");
                    synonymManagements.add(synonym);
                }
                break;
            }
            case "rel": {
                List<Map<String, Object>> relationships = this.bluePrintRepository.getAllRelationships();
                for (Map<String, Object> map : relationships) {
                    String relation = String.valueOf(map.get("relationship"));
                    if (!relation.contains(word) && !relation.equals(word)) continue;
                    SynonymManagement synonym = new SynonymManagement();
                    synonym.setSynonymWord(word);
                    synonym.setTargetWord(relation);
                    synonym.setWordType("rel");
                    synonymManagements.add(synonym);
                }
                break;
            }
            case "prop": {
                List<Map<String, Object>> properties = this.bluePrintRepository.getAllNodeProps();
                for (Map<String, Object> map : properties) {
                    String property = String.valueOf(map.get("property"));
                    if (!property.contains(word) && !property.equals(word)) continue;
                    SynonymManagement synonym = new SynonymManagement();
                    synonym.setSynonymWord(word);
                    synonym.setTargetWord(property);
                    synonym.setWordType("prop");
                    synonymManagements.add(synonym);
                }
                break;
            }
            case "inst": {
                List<Map<String, Object>> instanceNames = this.bluePrintRepository.getAllInstanceName();
                for (Map<String, Object> map : instanceNames) {
                    String instanceName = String.valueOf(map.get("name"));
                    if (!instanceName.contains(word) && !instanceName.equals(word)) continue;
                    SynonymManagement synonym = new SynonymManagement();
                    synonym.setSynonymWord(word);
                    synonym.setTargetWord(instanceName);
                    synonym.setWordType("inst");
                    synonymManagements.add(synonym);
                }
                break;
            }
        }
        Collections.sort(synonymManagements, new Comparator<SynonymManagement>(){

            @Override
            public int compare(SynonymManagement o1, SynonymManagement o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getTargetWord().length() > o2.getTargetWord().length()) {
                    return 1;
                }
                if (o1.getTargetWord().length() == o2.getTargetWord().length()) {
                    return 0;
                }
                if (o1.getTargetWord().length() < o2.getTargetWord().length()) {
                    return -1;
                }
                return 0;
            }
        });
        if (synonymManagements.size() > 5) {
            synonymManagements = synonymManagements.subList(0, 5);
        }
        return synonymManagements;
    }

    public List<SynonymManagement> getWordsFromVacabDistance(String word, String wordType) {
        List<Object> synonymManagements = new ArrayList<SynonymManagement>();
        double threshold = 0.5;
        switch (wordType) {
            case "ent": {
                List<Map<String, Object>> labels = this.bluePrintRepository.getAllLables();
                for (Map<String, Object> map : labels) {
                    String label = String.valueOf(map.get("label"));
                    double score = StrUtil.similar((String)word, (String)label);
                    if (!(score > threshold)) continue;
                    SynonymManagement synonym = new SynonymManagement();
                    synonym.setSynonymWord(word);
                    synonym.setTargetWord(label);
                    synonym.setWordType("ent");
                    synonym.setScore(Double.valueOf(score));
                    synonymManagements.add(synonym);
                }
                break;
            }
            case "rel": {
                List<Map<String, Object>> relationships = this.bluePrintRepository.getAllRelationships();
                for (Map<String, Object> map : relationships) {
                    String relation = String.valueOf(map.get("relationship"));
                    double score = StrUtil.similar((String)word, (String)relation);
                    if (!(score > threshold)) continue;
                    SynonymManagement synonym = new SynonymManagement();
                    synonym.setSynonymWord(word);
                    synonym.setTargetWord(relation);
                    synonym.setWordType("rel");
                    synonym.setScore(Double.valueOf(score));
                    synonymManagements.add(synonym);
                }
                break;
            }
            case "prop": {
                List<Map<String, Object>> properties = this.bluePrintRepository.getAllNodeProps();
                for (Map<String, Object> map : properties) {
                    String property = String.valueOf(map.get("property"));
                    double score = StrUtil.similar((String)word, (String)property);
                    if (!(score > threshold)) continue;
                    SynonymManagement synonym = new SynonymManagement();
                    synonym.setSynonymWord(word);
                    synonym.setTargetWord(property);
                    synonym.setWordType("prop");
                    synonym.setScore(Double.valueOf(score));
                    synonymManagements.add(synonym);
                }
                break;
            }
            case "inst": {
                List<Map<String, Object>> instanceNames = this.bluePrintRepository.getAllInstanceName();
                for (Map<String, Object> map : instanceNames) {
                    String instanceName = String.valueOf(map.get("name"));
                    double score = StrUtil.similar((String)word, (String)instanceName);
                    if (!(score > threshold)) continue;
                    SynonymManagement synonym = new SynonymManagement();
                    synonym.setSynonymWord(word);
                    synonym.setTargetWord(instanceName);
                    synonym.setWordType("inst");
                    synonym.setScore(Double.valueOf(score));
                    synonymManagements.add(synonym);
                }
                break;
            }
        }
        Collections.sort(synonymManagements, new Comparator<SynonymManagement>(){

            @Override
            public int compare(SynonymManagement o1, SynonymManagement o2) {
                if (o1.getScore() == null && o2.getScore() == null) {
                    return 0;
                }
                if (o1.getScore() == null) {
                    return -1;
                }
                if (o2.getScore() == null) {
                    return 1;
                }
                if (o1.getScore() > o2.getScore()) {
                    return 1;
                }
                if (o1.getScore() == o2.getScore()) {
                    return 0;
                }
                if (o1.getScore() < o2.getScore()) {
                    return -1;
                }
                return 0;
            }
        });
        List<SynonymManagement> containedWords = this.getWordsFromVacab(word, wordType);
        for (SynonymManagement containedSynonym : containedWords) {
            for (int i = 0; i < synonymManagements.size(); ++i) {
                if (!((SynonymManagement)synonymManagements.get(i)).getTargetWord().equals(containedSynonym.getTargetWord()) || !((SynonymManagement)synonymManagements.get(i)).getWordType().equals(containedSynonym.getWordType())) continue;
                synonymManagements.remove(i);
                --i;
            }
        }
        synonymManagements.addAll(containedWords);
        if (synonymManagements.size() > 10) {
            synonymManagements = synonymManagements.subList(0, 10);
        }
        return synonymManagements;
    }
}

