/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.kbqa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.common.util.NlpUtil;
import com.jxdinfo.hussar.kgbase.kbqa.model.QuestionParsePO;
import com.jxdinfo.hussar.kgbase.kbqa.model.QuestionParsePattern;
import com.jxdinfo.hussar.kgbase.kbqa.model.WordParsePO;
import com.jxdinfo.hussar.kgbase.kbqa.model.po.QuestionRecords;
import com.jxdinfo.hussar.kgbase.kbqa.model.po.SynonymManagement;
import com.jxdinfo.hussar.kgbase.kbqa.model.vo.KbqaAnswerVO;
import com.jxdinfo.hussar.kgbase.kbqa.service.IKbqaService;
import com.jxdinfo.hussar.kgbase.kbqa.service.IQuestionRecordsService;
import com.jxdinfo.hussar.kgbase.kbqa.service.ISynonymManagementService;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.repository.BluePrintRepository;
import com.jxdinfo.hussar.kgbase.neo4j.repository.KbqaRepository;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.rmi.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.springframework.stereotype.Service;

@Service
public class KbqaServiceImpl
implements IKbqaService {
    @Resource
    private KbqaRepository kbqaRepository;
    @Resource
    private BluePrintRepository bluePrintRepository;
    @Resource
    private IQuestionRecordsService iQuestionRecordsService;
    @Resource
    private ISynonymManagementService iSynonymManagementService;
    private String kbqaStr = "";

    public ApiResponse<KbqaAnswerVO> getAnswer(String question, Boolean flag) {
        QuestionRecords record = new QuestionRecords();
        record.setQueryContent(question);
        record.setCreateTime(new Date());
        record.setDelFlag("0");
        try {
            question = question.replaceAll(" ", "");
            question = question.replaceAll("\n", "");
            QuestionParsePO questionParsePO = NlpUtil.changeQuestionToPattern(question);
            KbqaAnswerVO vo = this.judgeQuestionPattern(questionParsePO.getPattern(), questionParsePO.getWordParsePOS());
            vo.setWordParsePOS(questionParsePO.getWordParsePOS());
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (WordParsePO wordParsePO : questionParsePO.getWordParsePOS()) {
                ++i;
                sb.append(wordParsePO.getPreContent());
                sb.append("(");
                sb.append(wordParsePO.getNature());
                sb.append(")");
                if (i >= questionParsePO.getWordParsePOS().length) continue;
                sb.append("-");
            }
            vo.setWordParseStr(sb.toString());
            if (flag.booleanValue()) {
                if (BaseSecurityUtil.getUser() != null) {
                    record.setCreator(BaseSecurityUtil.getUser().getId());
                    record.setCreatorName(BaseSecurityUtil.getUser().getUserName());
                }
                JSONObject job = new JSONObject();
                for (WordParsePO wordParsePO : questionParsePO.getWordParsePOS()) {
                    job.put(wordParsePO.getNature(), (Object)wordParsePO.getPreContent());
                }
                record.setSegment(job.toString());
                record.setTemplate(questionParsePO.getPattern());
                record.setGraphQl(this.kbqaStr);
                this.iQuestionRecordsService.save((Object)record);
                vo.setQuestionRecord(record);
            }
            return ApiResponse.success((Object)vo);
        }
        catch (HussarException e) {
            e.printStackTrace();
            if (flag.booleanValue()) {
                if (BaseSecurityUtil.getUser() != null) {
                    record.setCreator(BaseSecurityUtil.getUser().getId());
                    record.setCreatorName(BaseSecurityUtil.getUser().getUserName());
                }
                record.setIsUseful("0");
                this.iQuestionRecordsService.save((Object)record);
            }
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public KbqaAnswerVO judgeQuestionPattern(String questionPattern, WordParsePO[] arr) {
        KbqaAnswerVO answerVO = new KbqaAnswerVO();
        ArrayList<String> answers = new ArrayList<String>();
        List patternList = QuestionParsePattern.generateQuestionPatterns();
        String finalPattern = "";
        for (String parsePattern : patternList) {
            if (!questionPattern.startsWith(parsePattern)) continue;
            finalPattern = parsePattern;
        }
        List<Object> resultList = new ArrayList();
        switch (finalPattern) {
            case "inst-rel": 
            case "inst-p-rel": 
            case "inst-rel-v": {
                resultList = this.kbqaRepository.QUERY_INST_REL(arr[0].getContent(), arr[1].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and type(r)={rel} and r<>[] return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "inst-v-rel": {
                resultList = this.kbqaRepository.QUERY_INST_REL(arr[0].getContent(), arr[2].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and type(r)={rel} and r<>[] return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "inst-v-v-rel": {
                resultList = this.kbqaRepository.QUERY_INST_REL(arr[0].getContent(), arr[3].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and type(r)={rel} and r<>[] return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "inst-prop": {
                resultList = this.kbqaRepository.QUERY_INST_PROP(arr[0].getContent(), arr[1].getContent());
                this.kbqaStr = "match (n) where n.name={inst} return n,properties(n)[{prop}] as p limit 100";
                for (Object propMap : resultList) {
                    Object v = propMap.get("p");
                    if (!StringUtil.isNotBlank((CharSequence)String.valueOf(v))) continue;
                    answers.add(String.valueOf(v));
                }
                answerVO.setAnswer(StringUtil.join(answers, (String)","));
                break;
            }
            case "inst-v-prop": {
                resultList = this.kbqaRepository.QUERY_INST_PROP(arr[0].getContent(), arr[2].getContent());
                this.kbqaStr = "match (n) where n.name={inst} return n,properties(n)[{prop}] as p limit 100";
                for (Object propMap : resultList) {
                    Object v = propMap.get("p");
                    if (!StringUtil.isNotBlank((CharSequence)String.valueOf(v))) continue;
                    answers.add(String.valueOf(v));
                }
                answerVO.setAnswer(StringUtil.join(answers, (String)","));
                break;
            }
            case "inst-rel-prop": {
                resultList = this.kbqaRepository.QUERY_INST_REL(arr[0].getContent(), arr[1].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and type(r)={rel} and r<>[] return n1,n2,r,n2 as t limit 100";
                List<Map<String, Object>> propList = this.kbqaRepository.QUERY_INST_REL_PROP(arr[0].getContent(), arr[1].getContent(), arr[2].getContent());
                for (Map map : propList) {
                    Object p = map.get("p");
                    if (!StringUtil.isNotBlank((CharSequence)String.valueOf(p))) continue;
                    answers.add(String.valueOf(p));
                }
                answerVO.setAnswer(StringUtil.join(answers, (String)","));
                break;
            }
            case "inst-rel-rel": {
                resultList = this.kbqaRepository.QUERY_INST_REL_REL(arr[0].getContent(), arr[1].getContent(), arr[2].getContent());
                this.kbqaStr = "MATCH (n1)-[r1]-(n2) WHERE n1.name={inst} and type(r1)={rel1} with n1,r1,n2 MATCH (n2)-[r2]-(n3) WHERE type(r2)={rel2} return n1,r1,n2,r2,n3,n3 as t limit 100";
                break;
            }
            case "inst-rel-ent": 
            case "inst-rel-p-ent": {
                resultList = this.kbqaRepository.QUERY_INST_REL_ENT(arr[0].getContent(), arr[1].getContent(), arr[2].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and type(r)={rel} and {ent} in labels(n2) and r<>[] return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "inst-v-p-ent": 
            case "inst-v-ent": 
            case "inst-v-ent-v": {
                resultList = this.kbqaRepository.QUERY_INST_V_ENT(arr[0].getContent(), arr[2].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and {ent} in labels(n2) and r<>[] return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "inst-ent-v": 
            case "inst-ent": {
                resultList = this.kbqaRepository.QUERY_INST_V_ENT(arr[0].getContent(), arr[1].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and {ent} in labels(n2) and r<>[] return n1,n2,r,n2 as t limit 100 ";
                break;
            }
            case "ent-inst-rel": {
                resultList = this.kbqaRepository.QUERY_INST_REL_ENT(arr[1].getContent(), arr[2].getContent(), arr[0].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and type(r)={rel} and {ent} in labels(n2) and r<>[] return n1,n2,r,n2 as t limit 100 ";
                break;
            }
            case "inst-p-ent-rel": {
                resultList = this.kbqaRepository.QUERY_INST_REL_ENT(arr[0].getContent(), arr[2].getContent(), arr[1].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and type(r)={rel} and {ent} in labels(n2) and r<>[] return n1,n2,r,n2 as t limit 100 ";
                break;
            }
            case "inst-v-ent-rel": {
                resultList = this.kbqaRepository.QUERY_INST_REL_ENT(arr[0].getContent(), arr[3].getContent(), arr[2].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and type(r)={rel} and {ent} in labels(n2) and r<>[] return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "inst-p-ent-v": {
                resultList = this.kbqaRepository.QUERY_INST_V_ENT(arr[0].getContent(), arr[1].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and {ent} in labels(n2) and r<>[] return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "rel-p-inst-ent": 
            case "rel-p-inst-ent-v": {
                resultList = this.kbqaRepository.REL_P_INST_ENT(arr[0].getContent(), arr[1].getContent(), arr[2].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and {ent} in labels(n2) and r<>[] and type(r)={rel} return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "rel-v-inst-ent-v": {
                resultList = this.kbqaRepository.REL_P_INST_ENT(arr[0].getContent(), arr[2].getContent(), arr[3].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and {ent} in labels(n2) and r<>[] and type(r)={rel} return n1,n2,r,n2 as t limit 100";
                break;
            }
            case "v-inst-ent": 
            case "v-inst-ent-v": {
                resultList = this.kbqaRepository.QUERY_INST_V_ENT(arr[1].getContent(), arr[2].getContent());
                this.kbqaStr = "match (n1)-[r]-(n2) where n1.name={inst} and {ent} in labels(n2) and r<>[] return n1,n2,r,n2 as t limit 100";
            }
        }
        if (resultList.size() == 0) {
            answerVO.setAnswer("\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
            return answerVO;
        }
        List<Object> nodes = new ArrayList();
        ArrayList<NodeModel> nodeModels = new ArrayList<NodeModel>();
        List<Object> relationships = new ArrayList();
        ArrayList<RelationshipModel> relationShipModels = new ArrayList<RelationshipModel>();
        ArrayList arrayList = new ArrayList();
        ArrayList<NodeModel> targetNodeModels = new ArrayList<NodeModel>();
        for (Map map : resultList) {
            for (Map.Entry entry : map.entrySet()) {
                Object node;
                if (String.valueOf(entry.getKey()).contains("n")) {
                    node = entry.getValue();
                    if (!(node instanceof NodeModel)) continue;
                    nodeModels.add((NodeModel)node);
                    continue;
                }
                if (String.valueOf(entry.getKey()).contains("r")) {
                    Object relation = entry.getValue();
                    if (!(relation instanceof RelationshipModel)) continue;
                    relationShipModels.add((RelationshipModel)relation);
                    continue;
                }
                if (!String.valueOf(entry.getKey()).contains("t") || !((node = entry.getValue()) instanceof NodeModel)) continue;
                targetNodeModels.add((NodeModel)node);
            }
        }
        nodes = Neo4jUtil.changeToNeo4jBasicNode(nodeModels);
        List<Neo4jBasicNode> list = Neo4jUtil.changeToNeo4jBasicNode(targetNodeModels);
        relationships = Neo4jUtil.changeToNeo4jQueryRelation(relationShipModels);
        for (Neo4jBasicNode neo4jBasicNode : list) {
            answers.add(neo4jBasicNode.getLabel());
        }
        if (answerVO.getAnswer() == null) {
            answerVO.setAnswer(StringUtil.join(answers, (String)","));
        }
        answerVO.setNodes(nodes);
        answerVO.setRelationships(relationships);
        if (StringUtils.isEmpty((CharSequence)answerVO.getAnswer())) {
            answerVO.setAnswer("\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
        } else if ("null".equals(answerVO.getAnswer())) {
            answerVO.setAnswer("\u672a\u67e5\u8be2\u5230\u7ed3\u679c\uff0c\u4e3a\u60a8\u63a8\u8350\u4ee5\u4e0b\u76f8\u5173\u77e5\u8bc6");
        }
        return answerVO;
    }

    public ApiResponse dictUpdate() {
        CustomDictionary.reload();
        List synonymList = this.iSynonymManagementService.list();
        for (SynonymManagement synonym : synonymList) {
            CustomDictionary.insert((String)synonym.getSynonymWord(), (String)"synonym");
        }
        List<Map<String, Object>> labels = this.bluePrintRepository.getAllLables();
        List<Map<String, Object>> relationships = this.bluePrintRepository.getAllRelationships();
        List<Map<String, Object>> properties = this.bluePrintRepository.getAllNodeProps();
        List<Map<String, Object>> instanceNames = this.bluePrintRepository.getAllInstanceName();
        for (Map<String, Object> map : labels) {
            String label = String.valueOf(map.get("label"));
            CustomDictionary.insert((String)label, (String)"ent");
        }
        for (Map<String, Object> map : properties) {
            String property = String.valueOf(map.get("property"));
            CustomDictionary.insert((String)property, (String)"prop");
        }
        for (Map<String, Object> map : relationships) {
            String relationship = String.valueOf(map.get("relationship"));
            CustomDictionary.insert((String)relationship, (String)"rel");
        }
        for (Map<String, Object> map : instanceNames) {
            String instanceName = String.valueOf(map.get("name"));
            CustomDictionary.insert((String)instanceName, (String)"inst");
        }
        return ApiResponse.success((String)"\u8bcd\u5178\u91cd\u65b0\u52a0\u8f7d\u6210\u529f");
    }
}

