/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.kbqa.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.kgbase.kbqa.service.IKbqaService;
import com.jxdinfo.hussar.kgbase.kbqa.service.IQuestionRecordsService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kbqa"})
public class KbqaController
extends BaseController {
    @Resource
    private IKbqaService kbqaService;
    @Resource
    private IQuestionRecordsService questionRecordsService;

    @GetMapping(value={"/getAnswer"})
    public ApiResponse getAnswer(@RequestParam String question) {
        return this.kbqaService.getAnswer(question, Boolean.valueOf(true));
    }

    @GetMapping(value={"/dictUpdate"})
    public ApiResponse dictUpdate() {
        return this.kbqaService.dictUpdate();
    }

    @GetMapping(value={"/feedback"})
    public ApiResponse feedback(@RequestParam String recordId, String isUseful) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"ID", (Object)recordId);
        updateWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        if ("2".equals(isUseful)) {
            updateWrapper.set((Object)"IS_USEFUL", null);
        } else {
            updateWrapper.set((Object)"IS_USEFUL", (Object)isUseful);
        }
        this.questionRecordsService.update((Wrapper)updateWrapper);
        return ApiResponse.success();
    }

    @GetMapping(value={"/deleteRecord"})
    public ApiResponse deleteRecord(@RequestParam String recordId) {
        this.questionRecordsService.removeById((Serializable)((Object)recordId));
        return ApiResponse.success();
    }

    @GetMapping(value={"/clearRecords"})
    public ApiResponse clearRecords() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        if (BaseSecurityUtil.getUser() != null && BaseSecurityUtil.getUser().getId() != null) {
            queryWrapper.eq((Object)"CREATOR", (Object)BaseSecurityUtil.getUser().getId());
        }
        return ApiResponse.success((Object)this.questionRecordsService.remove((Wrapper)queryWrapper));
    }

    @GetMapping(value={"/getRecords"})
    public ApiResponse getRecords() {
        return ApiResponse.success((Object)this.questionRecordsService.getUsefulRecords());
    }
}

