/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.computing.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.computing.service.ComputingSimilarityService;
import com.jxdinfo.hussar.kgbase.zsrh.kgknowledgefusion1.model.KgInstanceNeoAlign;
import com.jxdinfo.hussar.kgbase.zsrh.kgknowledgefusion1.model.KgKnowledgeFusion1;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/computing"})
public class ComputingSimilarityController
extends BaseController {
    @Resource
    private ComputingSimilarityService computingSimilarityService;

    @GetMapping(value={"/getNameSimilar"})
    public ApiResponse getNameSimilar(String type, String limit) {
        return ApiResponse.success((Object)this.computingSimilarityService.getNameSimilar(type, limit));
    }

    @GetMapping(value={"/getAttributeSimilar"})
    public ApiResponse getAttributeSimilar(String type, String att) {
        return ApiResponse.success((Object)this.computingSimilarityService.getAttributeSimilar(type, att));
    }

    @GetMapping(value={"/getRelationSimilar"})
    public ApiResponse getRelationSimilar(String type, String limit) {
        return ApiResponse.success((Object)this.computingSimilarityService.getRelationSimilar(type, limit));
    }

    @GetMapping(value={"/processData"})
    public void processData(@RequestBody KgKnowledgeFusion1 kgKnowledgeFusion1) {
        this.computingSimilarityService.processData(kgKnowledgeFusion1, "add");
    }

    @PostMapping(value={"/getList"})
    public ApiResponse<List<KgInstanceNeoAlign>> getList(@RequestBody String pId) {
        try {
            JSONObject jsonObject = (JSONObject)JSONObject.parse((String)pId);
            return ApiResponse.success((Object)this.computingSimilarityService.getList(jsonObject.get((Object)"pId").toString()));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/getAllLabel"})
    public ApiResponse<List<String>> getAllLabel() {
        try {
            return ApiResponse.success((Object)this.computingSimilarityService.getAllLabel());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/alignData"})
    public ApiResponse alignData(@RequestBody KgInstanceNeoAlign kgInstanceNeoAlign) {
        try {
            return ApiResponse.success((Object)this.computingSimilarityService.alignData(kgInstanceNeoAlign));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

