/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util.pdfUtil;

import cn.hutool.core.img.ImgUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;

public class PngImgUtil {
    public static Integer imageSize(String imageBase64Str) {
        Integer equalIndex = imageBase64Str.indexOf("=");
        if (imageBase64Str.indexOf("=") > 0) {
            imageBase64Str = imageBase64Str.substring(0, equalIndex);
        }
        Integer strLength = imageBase64Str.length();
        System.out.println("imageBase64Str Length = " + strLength);
        Integer size = strLength - strLength / 8 * 2;
        return PngImgUtil.bytesToKB(size.intValue());
    }

    public static Integer bytesToKB(long bytes) {
        BigDecimal filesize = new BigDecimal(bytes);
        BigDecimal megabyte = new BigDecimal(0x100000);
        BigDecimal kilobyte = new BigDecimal(1024);
        float returnValue = filesize.divide(kilobyte, 1, 1).floatValue();
        return (int)returnValue;
    }

    public static String scaleImage(String base64ImagStr) {
        BufferedImage bufferedImage = ImgUtil.toImage((String)base64ImagStr);
        Image scaleImage = ImgUtil.scale((Image)bufferedImage, (float)0.2f);
        String resultBase64Str = ImgUtil.toBase64((Image)scaleImage, (String)"png");
        return resultBase64Str;
    }

    public static String resizeImageTo200K(String base64ImagStr) {
        if (base64ImagStr.indexOf("data:image/png;base64,") > -1) {
            base64ImagStr = base64ImagStr.split("data:image/png;base64,")[1];
        }
        String resultBase64Str = PngImgUtil.scaleImage(base64ImagStr);
        Integer imageSizeBase64 = PngImgUtil.imageSize(resultBase64Str);
        for (int i = 0; imageSizeBase64 > 40 && i < 20; ++i) {
            resultBase64Str = PngImgUtil.scaleImage(resultBase64Str);
            imageSizeBase64 = PngImgUtil.imageSize(resultBase64Str);
        }
        return "data:image/png;base64," + resultBase64Str;
    }
}

