/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.WordToTextConverter;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordToTxtUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(WordToTxtUtil.class);

    public static void wordToTxt(String filePath, String fileType) throws Exception {
        int ind = filePath.lastIndexOf("\\");
        String sourcePath = filePath.substring(0, ind);
        String fileName = filePath.substring(ind + 1, filePath.length());
        int ind2 = fileName.lastIndexOf(".");
        String name = fileName.substring(0, ind2);
        String wordToTxtPath = sourcePath + "/" + name + "_" + new Date().getTime() + ".txt";
        if (StringUtil.equals((CharSequence)"docx", (CharSequence)fileType)) {
            XWPFWordExtractor docx = new XWPFWordExtractor(POIXMLDocument.openPackage((String)filePath));
            String text = docx.getText();
            FileWriter writer = new FileWriter(wordToTxtPath);
            writer.write(text);
            writer.close();
        } else if (StringUtil.equals((CharSequence)"doc", (CharSequence)fileType)) {
            FileInputStream is = new FileInputStream(filePath);
            HWPFDocument wordDocument = new HWPFDocument((InputStream)is);
            WordToTextConverter converter = new WordToTextConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            converter.processDocument((HWPFDocumentCore)wordDocument);
            FileWriter writer = new FileWriter(new File(wordToTxtPath));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "text");
            transformer.transform(new DOMSource(converter.getDocument()), new StreamResult(writer));
        }
    }
}

