/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import com.jxdinfo.hussar.kgbase.application.instancemanage.model.dto.InstancePropertyDTO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.vo.InstancePropertyVO;
import com.jxdinfo.hussar.kgbase.common.constant.KgConstants;
import com.jxdinfo.hussar.kgbase.common.util.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class PropUtil {
    public static Object arrToString(InstancePropertyDTO prop) {
        StringBuffer sb = new StringBuffer();
        if ("1".equals(prop.getIfMulti()) && "STRING".equals(prop.getPropType())) {
            List propValueList = (List)prop.getPropValue();
            sb.append("[");
            int index = 0;
            for (Object value : propValueList) {
                sb.append("'").append(value).append("'");
                if (++index >= propValueList.size()) continue;
                sb.append(",");
            }
            sb.append("]");
        } else if ("STRING".equals(prop.getPropType()) || "DATE".equals(prop.getPropType())) {
            sb.append("'");
            sb.append(prop.getPropValue());
            sb.append("'");
        } else {
            return prop.getPropValue();
        }
        return sb.toString();
    }

    public static List<InstancePropertyVO> generatePropList(List<HashMap<String, Object>> propMapList) {
        ArrayList<InstancePropertyVO> propList = new ArrayList<InstancePropertyVO>();
        block14: for (HashMap<String, Object> map : propMapList) {
            String columnType;
            List<String> defaultNodeProps = Arrays.asList(KgConstants.getDefaultNodeProps2());
            for (String defaultProp : defaultNodeProps) {
                if (!defaultProp.equals(String.valueOf(map.get("key")))) continue;
                continue block14;
            }
            InstancePropertyVO propertyVO = new InstancePropertyVO();
            propertyVO.setPropKey(String.valueOf(map.get("key")));
            propertyVO.setPropValue(map.get("value"));
            switch (columnType = String.valueOf(map.get("columnType"))) {
                case "String[]": {
                    propertyVO.setPropType("STRING");
                    propertyVO.setIfMulti("1");
                    break;
                }
                case "long[]": {
                    propertyVO.setPropType("INTEGER");
                    propertyVO.setIfMulti("1");
                    break;
                }
                case "double[]": {
                    propertyVO.setPropType("FLOAT");
                    propertyVO.setIfMulti("1");
                    break;
                }
                case "LocalDateTime": {
                    propertyVO.setPropType("DATE");
                    propertyVO.setIfMulti("0");
                    break;
                }
                case "STRING": {
                    if (DateUtil.judgeParseDate(String.valueOf(propertyVO.getPropValue()))) {
                        propertyVO.setPropType("DATE");
                    } else {
                        propertyVO.setPropType("STRING");
                    }
                    propertyVO.setIfMulti("0");
                    break;
                }
                default: {
                    propertyVO.setPropType(columnType);
                    propertyVO.setIfMulti("0");
                }
            }
            propList.add(propertyVO);
        }
        return propList;
    }
}

