/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.jxdinfo.hussar.kgbase.kbqa.model.QuestionParsePO;
import com.jxdinfo.hussar.kgbase.kbqa.model.WordParsePO;
import com.jxdinfo.hussar.kgbase.kbqa.model.po.SynonymManagement;
import com.jxdinfo.hussar.kgbase.kbqa.service.ISynonymManagementService;
import java.io.IOException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NlpUtil {
    private static ISynonymManagementService iSynonymManagementService;

    @Autowired
    public void setSynonymManagementService(ISynonymManagementService iSynonymManagementService) {
        NlpUtil.iSynonymManagementService = iSynonymManagementService;
    }

    public static QuestionParsePO changeQuestionToPattern(String question) {
        HanLP.newSegment().enableCustomDictionaryForcing(true);
        CoNLLSentence sentence = HanLP.parseDependency((String)question);
        CoNLLWord[] wordArray = sentence.getWordArray();
        StringBuffer pattern = new StringBuffer();
        ArrayList<WordParsePO> list = new ArrayList<WordParsePO>();
        int index = 0;
        for (CoNLLWord word : wordArray) {
            SynonymManagement synonym;
            if (word.POSTAG.equals("synonym") && (synonym = iSynonymManagementService.getTargetBySynonym(null, word.NAME)) != null) {
                word.POSTAG = synonym.getWordType();
                word.CPOSTAG = synonym.getWordType();
                word.NAME = synonym.getTargetWord();
                word.LEMMA = synonym.getSynonymWord();
            }
            ++index;
            if (word.POSTAG.equals("inst") || word.POSTAG.equals("ent") || word.POSTAG.equals("rel") || word.POSTAG.equals("prop") || word.POSTAG.equals("p") || word.POSTAG.equals("f") || word.POSTAG.equals("v") || word.POSTAG.equals("m") || word.POSTAG.equals("c")) {
                pattern.append(word.CPOSTAG);
                if (index < wordArray.length) {
                    pattern.append("-");
                }
            }
            if (!word.POSTAG.equals("inst") && !word.POSTAG.equals("ent") && !word.POSTAG.equals("rel") && !word.POSTAG.equals("prop") && !word.POSTAG.equals("v") && !word.POSTAG.equals("m")) continue;
            WordParsePO po = new WordParsePO();
            po.setNature(word.POSTAG);
            po.setContent(word.NAME);
            po.setPreContent(word.LEMMA);
            list.add(po);
        }
        WordParsePO[] poArr = list.toArray(new WordParsePO[list.size()]);
        return new QuestionParsePO(pattern.toString(), poArr);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        HanLP.newSegment().enableCustomDictionaryForcing(true);
        CustomDictionary.insert((String)"\u8881\u9686\u5e73", (String)"inst 1024");
        CustomDictionary.insert((String)"\u9093\u5219", (String)"inst 1024");
        CustomDictionary.insert((String)"\u6821\u53cb", (String)"rel 512");
        CustomDictionary.insert((String)"\u59bb\u5b50", (String)"rel 512");
        CustomDictionary.insert((String)"\u7236\u4eb2", (String)"rel 512");
        CustomDictionary.insert((String)"\u6bcd\u6821", (String)"rel 512");
        CustomDictionary.insert((String)"\u513f\u5b50", (String)"rel 512");
        CustomDictionary.insert((String)"\u9886\u5bfc", (String)"prop 256");
        CustomDictionary.insert((String)"\u7c4d\u8d2f", (String)"prop 256");
        CustomDictionary.insert((String)"\u5b66\u6821", (String)"ent 128");
        CustomDictionary.insert((String)"\u5f20\u4e09", (String)"inst 1024");
        CustomDictionary.insert((String)"\u4ea7\u54c1\u90e8", (String)"inst 1024");
        CustomDictionary.insert((String)"\u77e5\u8bc6\u56fe\u8c31", (String)"inst 1024");
        CustomDictionary.insert((String)"\u8f7b\u9a91\u5175", (String)"inst 1024");
        CustomDictionary.insert((String)"\u7ecf\u7406", (String)"inst 1024");
        CustomDictionary.insert((String)"\u5f00\u53d1", (String)"inst 1024");
        CustomDictionary.insert((String)"\u7814\u53d1", (String)"rel 512");
        CustomDictionary.insert((String)"\u4efb\u804c", (String)"rel 512");
        CustomDictionary.insert((String)"\u8d1f\u8d23\u4eba", (String)"rel 512");
        CustomDictionary.insert((String)"\u5de5\u8d44", (String)"prop 256");
        CustomDictionary.insert((String)"\u804c\u52a1", (String)"prop 256");
        CustomDictionary.insert((String)"\u5458\u5de5", (String)"ent 128");
        CustomDictionary.insert((String)"\u90e8\u95e8", (String)"ent 128");
        CustomDictionary.insert((String)"\u4ea7\u54c1", (String)"ent 128");
        CoNLLSentence sentence = HanLP.parseDependency((String)"\u8881\u9686\u5e73\u662f\u54ea\u6240\u5b66\u6821\u6bd5\u4e1a\u7684");
        System.out.println(sentence);
        CoNLLWord[] wordArray = sentence.getWordArray();
        ArrayList<CoNLLWord> headList = new ArrayList<CoNLLWord>();
        for (CoNLLWord word : sentence) {
            if (!"ent".equals(word.POSTAG) && !"inst".equals(word.POSTAG)) continue;
            headList.add(word);
        }
    }
}

