/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import cn.hutool.core.io.FastByteArrayOutputStream;
import com.jxdinfo.hussar.core.exception.HussarException;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioUtil {
    @Resource
    private MinioClient minioClient;

    public Boolean bucketExists(String bucketName) {
        Boolean found;
        try {
            found = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return found;
    }

    public Boolean makeBucket(String bucketName) {
        try {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Boolean removeBucket(String bucketName) {
        try {
            this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Boolean upload(MultipartFile file, String fileName, String bucketName) {
        try {
            PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build();
            this.minioClient.putObject(objectArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void download(String bucketName, String fileName, HttpServletResponse res) {
        GetObjectArgs objectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build();
        try (GetObjectResponse response = this.minioClient.getObject(objectArgs);){
            byte[] buf = new byte[1024];
            try (FastByteArrayOutputStream os = new FastByteArrayOutputStream();){
                int len;
                while ((len = response.read(buf)) != -1) {
                    os.write(buf, 0, len);
                }
                os.flush();
                byte[] bytes = os.toByteArray();
                res.setCharacterEncoding("utf-8");
                res.setContentType("application/force-download");
                res.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
                try (ServletOutputStream stream = res.getOutputStream();){
                    stream.write(bytes);
                    stream.flush();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void iterateDeleteObjects(String bucketName, String prefix) {
        try {
            boolean exists;
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            if (!(exists = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build()))) {
                throw new HussarException("bucket\u4e0d\u5b58\u5728");
            }
            ListObjectsArgs.Builder builder = ((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).recursive(true).prefix(prefix);
            Iterable iterable = this.minioClient.listObjects((ListObjectsArgs)builder.build());
            ArrayList<String> objects = new ArrayList<String>();
            for (Result itemResult : iterable) {
                Item item = (Item)itemResult.get();
                String objName = item.objectName();
                objects.add(objName);
            }
            this.removeObjects(bucketName, objects);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean removeObjects(String bucketName, List<String> objects) {
        try {
            List dos = objects.stream().map(e -> new DeleteObject(e)).collect(Collectors.toList());
            Iterable results = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects(dos).build());
            for (Result result : results) {
                DeleteError error = (DeleteError)result.get();
                System.out.println("Error in deleting object " + error.objectName() + "; " + error.message());
            }
            return true;
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e2) {
            e2.printStackTrace();
            return false;
        }
    }
}

