/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KeyWordUtil {
    private Map<String, Object> dictionaryMap;

    public KeyWordUtil(Set<String> wordSet) {
        this.dictionaryMap = this.handleToMap(wordSet);
    }

    public Map<String, Object> getDictionaryMap() {
        return this.dictionaryMap;
    }

    public void setDictionaryMap(Map<String, Object> dictionaryMap) {
        this.dictionaryMap = dictionaryMap;
    }

    private Map<String, Object> handleToMap(Set<String> wordSet) {
        if (wordSet == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(wordSet.size());
        HashMap<String, Object> curMap = null;
        for (String word : wordSet) {
            curMap = map;
            int len = word.length();
            for (int i = 0; i < len; ++i) {
                String key = String.valueOf(word.charAt(i));
                HashMap<String, String> wordMap = (HashMap<String, String>)curMap.get(key);
                if (wordMap == null) {
                    wordMap = new HashMap<String, String>();
                    wordMap.put("isEnd", "0");
                    curMap.put(key, wordMap);
                    curMap = wordMap;
                } else {
                    curMap = wordMap;
                }
                if (i != len - 1) continue;
                curMap.put("isEnd", "1");
            }
        }
        return map;
    }

    public int checkWord(String text, int beginIndex) {
        String key;
        if (this.dictionaryMap == null) {
            throw new RuntimeException("\u5b57\u5178\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean isEnd = false;
        int wordLength = 0;
        Map curMap = this.dictionaryMap;
        int len = text.length();
        for (int i = beginIndex; i < len && (curMap = (Map)curMap.get(key = String.valueOf(text.charAt(i)))) != null; ++i) {
            ++wordLength;
            if (!"1".equals(curMap.get("isEnd"))) continue;
            isEnd = true;
        }
        if (!isEnd) {
            wordLength = 0;
        }
        return wordLength;
    }

    public Set<String> getWords(String text) {
        HashSet<String> wordSet = new HashSet<String>();
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            int wordLength = this.checkWord(text, i);
            if (wordLength <= 0) continue;
            String word = text.substring(i, i + wordLength);
            wordSet.add(word);
            i = i + wordLength - 1;
        }
        return wordSet;
    }

    public static void main(String[] args) {
        String[] strings = new String[]{"abc", "efgg", "\u8fd8\u6709"};
        HashSet<String> wordSet = new HashSet<String>();
        for (String string : strings) {
            wordSet.add(string);
        }
        KeyWordUtil keyWordUtil = new KeyWordUtil(wordSet);
        Map<String, Object> map = keyWordUtil.getDictionaryMap();
        System.out.println(map);
        String text = "abcdefhigklmkn \u5929\u4e0b\u7b2c\u4e00\uff0c\u8fd8\u6709\u8c01\uff0c\u65e0\u654c\u662f\u591a\u4e48\u5bc2\u5bde\u3002";
        System.out.println(keyWordUtil.getWords(text));
        if (wordSet.size() == keyWordUtil.getWords(text).size()) {
            System.out.println("\u6b64\u5b57\u7b26\u4e32\u5305\u542b\u4ee5\u4e0a\u51e0\u4e2a\u5173\u952e\u5b57\u4fe1\u606f");
        } else {
            System.out.println("\u4e0d\u5305\u542b\u3002\u3002\u3002");
        }
    }
}

