/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class GraphUtil {
    public static List<LinkedList<Graph>> globalLinks = new ArrayList<LinkedList<Graph>>();

    public static void setRelation(Graph prev, Graph next) {
        if (!(prev.getNext().contains(next) || next.getPrev().contains(prev) || prev.getPrev().contains(next) || next.getNext().contains(prev))) {
            prev.setNext(next);
            next.setPrev(prev);
        }
    }

    public static List<LinkedList<Graph>> getLinks(List<Graph> nodeList) {
        ArrayList<LinkedList<Graph>> list = new ArrayList<LinkedList<Graph>>();
        boolean ifCircle = true;
        for (Graph graph : nodeList) {
            if (graph.getPrev().size() == 0) {
                GraphUtil.graphList(graph, new LinkedList<Graph>());
                list.addAll(globalLinks);
                globalLinks = new ArrayList<LinkedList<Graph>>();
                ifCircle = false;
                continue;
            }
            if (graph.getPrev().size() != 1 || !((Graph)graph.getPrev().get(0)).equals(graph)) continue;
            GraphUtil.graphList(graph, new LinkedList<Graph>());
            list.addAll(globalLinks);
            globalLinks = new ArrayList<LinkedList<Graph>>();
            ifCircle = false;
        }
        if (ifCircle) {
            Comparator<Graph> comparator = new Comparator<Graph>(){

                @Override
                public int compare(Graph g1, Graph g2) {
                    return g2.getDgree() - g1.getDgree();
                }
            };
            Collections.sort(nodeList, comparator);
            GraphUtil.graphList(nodeList.get(0), new LinkedList<Graph>());
            list.addAll(globalLinks);
            globalLinks = new ArrayList<LinkedList<Graph>>();
        }
        return list;
    }

    public static void printList(LinkedList<Graph> list) {
        int index = 0;
        for (Graph g : list) {
            System.out.print(g.getName());
            if (++index >= list.size()) continue;
            System.out.print("->");
        }
        System.out.println("");
        globalLinks.add(list);
    }

    private static void graphList(Graph graph, LinkedList<Graph> list) {
        list.add(graph);
        for (Graph n : graph.getNext()) {
            if (list.contains(n)) {
                if (list.size() <= 1 || graph.getNext().size() != 1) continue;
                GraphUtil.printList(list);
                continue;
            }
            LinkedList<Graph> newList = new LinkedList<Graph>();
            newList.addAll(list);
            GraphUtil.graphList(n, newList);
        }
        if (graph.getNext().size() == 0) {
            GraphUtil.printList(list);
        }
    }
}

