/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import com.jxdinfo.hussar.kgbase.common.model.ExcelDataTuPu;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    static Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static Workbook readExcel(String filePath) {
        HSSFWorkbook wb = null;
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            if (".xls".equals(extString)) {
                wb = new HSSFWorkbook((InputStream)is);
                return wb;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook((InputStream)is);
                return wb;
            }
            wb = null;
            return null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wb;
    }

    public static Object getCellFormatValue(Cell cell) {
        Object cellValue;
        block9: {
            block8: {
                cellValue = null;
                if (cell == null) break block8;
                switch (cell.getCellType()) {
                    case 0: {
                        double dvalue = cell.getNumericCellValue();
                        CellStyle cs = cell.getCellStyle();
                        DecimalFormat fmt = new DecimalFormat();
                        String temp = cs.getDataFormatString();
                        if (temp.equals("General")) {
                            fmt.applyPattern("#");
                        }
                        if ((cellValue = fmt.format(dvalue)) != null && cellValue.toString().indexOf(",") > -1) {
                            cellValue = cellValue.toString().replace(",", "");
                            break;
                        }
                        break block9;
                    }
                    case 2: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            cellValue = cell.getDateCellValue();
                            break;
                        }
                        cellValue = String.valueOf(cell.getNumericCellValue());
                        break;
                    }
                    case 1: {
                        cellValue = cell.getRichStringCellValue().getString();
                        break;
                    }
                    default: {
                        cellValue = "";
                        break;
                    }
                }
                break block9;
            }
            cellValue = "";
        }
        return cellValue;
    }

    public static void exportExcel(HttpServletResponse response, ExcelDataTuPu data) {
        log.info("\u5bfc\u51fa\u89e3\u6790\u5f00\u59cb\uff0cfileName:{}", (Object)data.getFileName());
        try {
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(data.getFileName() + ".xlsx", "utf-8"));
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet("sheet");
            ExcelUtil.setTitle(workbook, sheet, data.getHead());
            ExcelUtil.setData(sheet, (List<String[]>)data.getData());
            ExcelUtil.setBrowser(response, workbook, data.getFileName());
            log.info("\u5bfc\u51fa\u89e3\u6790\u6210\u529f!");
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u89e3\u6790\u5931\u8d25!");
            e.printStackTrace();
        }
    }

    private static void setTitle(HSSFWorkbook workbook, HSSFSheet sheet, String[] str) {
        try {
            HSSFRow row = sheet.createRow(0);
            for (int i = 0; i <= str.length; ++i) {
                sheet.setColumnWidth(i, 3840);
            }
            HSSFCellStyle style = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setBold(true);
            style.setFont(font);
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
            for (int j = 0; j < str.length; ++j) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(str[j]);
                cell.setCellStyle(style);
            }
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u65f6\u8bbe\u7f6e\u8868\u5934\u5931\u8d25\uff01");
            e.printStackTrace();
        }
    }

    private static void setData(HSSFSheet sheet, List<String[]> data) {
        try {
            int rowNum = 1;
            for (int i = 0; i < data.size(); ++i) {
                HSSFRow row = sheet.createRow(rowNum);
                for (int j = 0; j < data.get(i).length; ++j) {
                    row.createCell(j).setCellValue(data.get(i)[j]);
                }
                ++rowNum;
            }
            log.info("\u8868\u683c\u8d4b\u503c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.info("\u8868\u683c\u8d4b\u503c\u5931\u8d25\uff01");
            e.printStackTrace();
        }
    }

    private static void setBrowser(HttpServletResponse response, HSSFWorkbook workbook, String fileName) {
        try {
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/vnd.ms-excel;charset=gb2312");
            workbook.write((OutputStream)os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            log.info("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u4e0b\u8f7d\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u4e0b\u8f7d\u5931\u8d25\uff01");
            e.printStackTrace();
        }
    }

    public static void exportExcelSeven(HttpServletResponse response, ExcelDataTuPu data) {
        log.info("\u5bfc\u51fa\u89e3\u6790\u5f00\u59cb\uff0cfileName:{}", (Object)data.getFileName());
        try {
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(data.getFileName() + ".xlsx", "utf-8"));
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("sheet");
            ExcelUtil.setTitle(workbook, sheet, data.getHead());
            ExcelUtil.setData(sheet, (List<String[]>)data.getData());
            ExcelUtil.setBrowser(response, workbook, data.getFileName());
            log.info("\u5bfc\u51fa\u89e3\u6790\u6210\u529f!");
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u89e3\u6790\u5931\u8d25!");
            e.printStackTrace();
        }
    }

    private static void setTitle(XSSFWorkbook workbook, XSSFSheet sheet, String[] str) {
        try {
            XSSFRow row = sheet.createRow(0);
            for (int i = 0; i <= str.length; ++i) {
                sheet.setColumnWidth(i, 3840);
            }
            XSSFCellStyle style = workbook.createCellStyle();
            XSSFFont font = workbook.createFont();
            font.setBold(true);
            style.setFont((Font)font);
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
            for (int j = 0; j < str.length; ++j) {
                XSSFCell cell = row.createCell(j);
                cell.setCellValue(str[j]);
                cell.setCellStyle((CellStyle)style);
            }
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u65f6\u8bbe\u7f6e\u8868\u5934\u5931\u8d25\uff01");
            e.printStackTrace();
        }
    }

    private static void setData(XSSFSheet sheet, List<String[]> data) {
        try {
            int rowNum = 1;
            for (int i = 0; i < data.size(); ++i) {
                XSSFRow row = sheet.createRow(rowNum);
                for (int j = 0; j < data.get(i).length; ++j) {
                    row.createCell(j).setCellValue(data.get(i)[j]);
                }
                ++rowNum;
            }
            log.info("\u8868\u683c\u8d4b\u503c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.info("\u8868\u683c\u8d4b\u503c\u5931\u8d25\uff01");
            e.printStackTrace();
        }
    }

    private static void setBrowser(HttpServletResponse response, XSSFWorkbook workbook, String fileName) {
        try {
            response.reset();
            response.setHeader("content-type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".xlsx", "UTF-8"));
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            workbook.write((OutputStream)os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            log.info("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u4e0b\u8f7d\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u4e0b\u8f7d\u5931\u8d25\uff01");
            e.printStackTrace();
        }
    }

    public static List<Map<String, String>> readExcel(MultipartFile file) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
            int numberOfSheets = workbook.getNumberOfSheets();
            for (int i = 0; i < numberOfSheets; ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                int rownum = sheet.getPhysicalNumberOfRows();
                Row titlerow = sheet.getRow(0);
                int tilcol = titlerow.getPhysicalNumberOfCells();
                String[] columns = new String[tilcol];
                for (int z = 0; z < tilcol; ++z) {
                    String cellData;
                    columns[z] = cellData = (String)ExcelUtil.getCellFormatValue(titlerow.getCell(z));
                }
                for (int j = 1; j < rownum; ++j) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    Row rowData = sheet.getRow(j);
                    if (rowData != null) {
                        int colnum = rowData.getPhysicalNumberOfCells();
                        for (int z = 0; z < colnum; ++z) {
                            Cell cell = rowData.getCell(z);
                            Object obj = ExcelUtil.getCellFormatValue(cell);
                            if (obj == null) continue;
                            map.put(columns[z], obj.toString());
                        }
                    }
                    list.add(map);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void main(String[] args) {
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        ArrayList list = null;
        String cellData = null;
        String filePath = "D:\\ChromeCoreDownloads\\\u4ea7\u54c1_\u5b9e\u4f8b\u6570\u636e_1656557034644.xlsx";
        String[] columns = new String[]{"name", "age", "score"};
        wb = ExcelUtil.readExcel(filePath);
        if (wb != null) {
            list = new ArrayList();
            sheet = wb.getSheetAt(0);
            int rownum = sheet.getPhysicalNumberOfRows();
            row = sheet.getRow(0);
            int n = row.getPhysicalNumberOfCells();
            for (int i = 1; i < rownum; ++i) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                row = sheet.getRow(i);
                if (row == null) break;
                for (int j = 0; j < n; ++j) {
                    cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                    map.put(columns[j], cellData);
                }
                list.add(map);
            }
        }
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                System.out.print((String)entry.getKey() + ":" + (String)entry.getValue() + ",");
            }
            System.out.println();
        }
    }
}

