/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelToTxtUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(ExcelToTxtUtil.class);

    public static void excelToTxt(String filePath) throws IOException {
        int ind = filePath.lastIndexOf("\\");
        String sourcePath = filePath.substring(0, ind);
        String fileName = filePath.substring(ind + 1, filePath.length());
        int ind2 = fileName.lastIndexOf(".");
        String name = fileName.substring(0, ind2);
        String wordToTxtPath = sourcePath + "/" + name + "_" + new Date().getTime() + ".txt";
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        ArrayList list = null;
        String cellData = null;
        wb = ExcelToTxtUtil.readExcel(filePath);
        if (wb != null) {
            int i;
            list = new ArrayList();
            sheet = wb.getSheetAt(0);
            int rownum = sheet.getPhysicalNumberOfRows();
            row = sheet.getRow(0);
            int colnum = row.getPhysicalNumberOfCells();
            String[] stringArray = new String[colnum];
            for (i = 0; i < colnum; ++i) {
                stringArray[i] = (String)ExcelToTxtUtil.getCellFormatValue(row.getCell(i));
            }
            for (i = 1; i < rownum; ++i) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                row = sheet.getRow(i);
                if (row == null) break;
                for (int j = 0; j < colnum; ++j) {
                    cellData = (String)ExcelToTxtUtil.getCellFormatValue(row.getCell(j));
                    map.put(stringArray[j], cellData);
                }
                list.add(map);
            }
        }
        StringBuffer sb = new StringBuffer();
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                sb.append(value + ",");
            }
            sb.append("\r\n");
        }
        ExcelToTxtUtil.WriteToFile(sb.toString(), wordToTxtPath);
        System.out.println("*************EXCEL\u8f6c\u6210TXT\u683c\u5f0f\u6210\u529f*************");
    }

    public static Workbook readExcel(String filePath) {
        HSSFWorkbook wb = null;
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            if (".xls".equals(extString)) {
                wb = new HSSFWorkbook((InputStream)is);
                return wb;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook((InputStream)is);
                return wb;
            }
            wb = null;
            return null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wb;
    }

    public static Object getCellFormatValue(Cell cell) {
        Object cellValue = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = cell.getDateCellValue();
                        break;
                    }
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellValue = "";
                    break;
                }
            }
        } else {
            cellValue = "";
        }
        return cellValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteToFile(String str, String filePath) throws IOException {
        try (BufferedWriter bw = null;){
            FileOutputStream out = new FileOutputStream(filePath, true);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "GBK"));
            str = str + "\r\n";
            bw.write(str);
            bw.flush();
        }
    }
}

