/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.kgbase.build.dao.ConceptDao;
import com.jxdinfo.hussar.kgbase.build.dao.RelationDao;
import com.jxdinfo.hussar.kgbase.build.model.dto.ConceptDTO;
import com.jxdinfo.hussar.kgbase.build.model.dto.RelationDTO;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.model.po.RelProperty;
import com.jxdinfo.hussar.kgbase.build.model.po.Relation;
import com.jxdinfo.hussar.kgbase.build.model.vo.ConceptVO;
import com.jxdinfo.hussar.kgbase.build.model.vo.RelationVO;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.build.service.IRelPropertyService;
import com.jxdinfo.hussar.kgbase.build.service.IRelationService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RelationServiceImpl
extends ServiceImpl<RelationDao, Relation>
implements IRelationService {
    @Autowired
    private IRelPropertyService iRelPropertyService;
    @Autowired
    private RelationDao relationDao;
    @Autowired
    private ConceptDao conceptDao;
    @Autowired
    private IConceptService iconceptService;

    public String addOrEdit(RelationDTO relationDTO) {
        Relation relation = new Relation();
        BeanUtil.copyProperties((Object)relationDTO, (Object)relation);
        if (StringUtils.isBlank((CharSequence)relationDTO.getId())) {
            relation.setDelFlag("0");
            this.save(relation);
            if (CollectionUtil.isNotEmpty((Collection)relationDTO.getRelPropertyList())) {
                List list = relationDTO.getRelPropertyList();
                long i = 0L;
                for (RelProperty rel : list) {
                    rel.setRelationId(relation.getId());
                    rel.setShowOrder(Long.valueOf(i));
                    ++i;
                    rel.setDelFlag("0");
                }
                this.iRelPropertyService.saveBatch((Collection)list);
            }
        } else {
            this.updateById(relation);
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"RELATION_ID", (Object)relationDTO.getId());
            this.iRelPropertyService.remove((Wrapper)delWrapper);
            if (CollectionUtil.isNotEmpty((Collection)relationDTO.getRelPropertyList())) {
                List list = relationDTO.getRelPropertyList();
                long i = 0L;
                for (RelProperty rel : list) {
                    rel.setRelationId(relation.getId());
                    rel.setShowOrder(Long.valueOf(i));
                    ++i;
                    rel.setDelFlag("0");
                }
                this.iRelPropertyService.saveBatch((Collection)list);
            }
        }
        return relation.getId();
    }

    public void delete(RelationDTO relationDTO) {
        this.removeById((Serializable)((Object)relationDTO.getId()));
        HashMap relPropertyDeleteMap = Maps.newHashMap();
        relPropertyDeleteMap.put("RELATION_ID", relationDTO.getId());
        this.iRelPropertyService.removeByMap((Map)relPropertyDeleteMap);
    }

    public void deleteBatch(String relationIds) {
        if (StringUtil.isNotBlank((CharSequence)relationIds)) {
            String[] ids;
            for (String relationId : ids = relationIds.split(",")) {
                this.removeById((Serializable)((Object)relationId));
                HashMap relPropertyDeleteMap = Maps.newHashMap();
                relPropertyDeleteMap.put("RELATION_ID", relationId);
                this.iRelPropertyService.removeByMap((Map)relPropertyDeleteMap);
            }
        }
    }

    public RelationVO getRelationById(RelationDTO relationDTO) {
        Relation relation = (Relation)this.getById((Serializable)((Object)relationDTO.getId()));
        RelationVO vo = new RelationVO();
        BeanUtil.copyProperties((Object)relation, (Object)vo);
        this.getConceptNameById(vo);
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"RELATION_ID", (Object)relationDTO.getId());
        ew.orderByAsc((Object)"SHOW_ORDER");
        List propertyList = this.iRelPropertyService.list((Wrapper)ew);
        vo.setRelPropertyList(propertyList);
        return vo;
    }

    public Page<RelationVO> getList(RelationDTO relationDTO) {
        Page page = new Page();
        if (relationDTO.getCurrent() == null) {
            relationDTO.setCurrent(Integer.valueOf(1));
        }
        if (relationDTO.getSize() == null) {
            relationDTO.setSize(Integer.valueOf(10));
        }
        page.setCurrent((long)relationDTO.getCurrent().intValue());
        page.setSize((long)relationDTO.getSize().intValue());
        int startInd = (relationDTO.getCurrent() - 1) * relationDTO.getSize();
        int endInd = relationDTO.getCurrent() * relationDTO.getSize();
        String paramStr = StringUtil.isEmpty((Object)relationDTO.getRelationName()) ? null : relationDTO.getRelationName();
        String parentId = StringUtil.isEmpty((Object)relationDTO.getParentId()) ? null : relationDTO.getParentId();
        String groupOrConcept = relationDTO.getGroupOrConcept();
        if (parentId.equals("0")) {
            parentId = null;
        } else if (StringUtil.isNotBlank((CharSequence)groupOrConcept) && "group".equals(groupOrConcept)) {
            ConceptDTO conceptDTO = new ConceptDTO();
            conceptDTO.setCurrent(Integer.valueOf(1));
            conceptDTO.setParentId(parentId);
            conceptDTO.setSize(Integer.valueOf(1000));
            Page queryList = this.iconceptService.queryList(conceptDTO);
            String conceptIds = "";
            if (queryList != null) {
                for (ConceptVO conceptVO : queryList.getRecords()) {
                    if ("".equals(conceptIds)) {
                        conceptIds = conceptVO.getId();
                        continue;
                    }
                    conceptIds = conceptIds + "," + conceptVO.getId();
                }
                parentId = conceptIds;
            }
        }
        List<RelationVO> relationList = this.relationDao.getRelationList(parentId, paramStr);
        page.setTotal((long)relationList.size());
        endInd = endInd > relationList.size() ? relationList.size() : endInd;
        ArrayList<RelationVO> result = new ArrayList<RelationVO>();
        for (int i = startInd; i < endInd; ++i) {
            result.add(relationList.get(i));
        }
        page.setRecords(result);
        return page;
    }

    public String getChildren(String parentId) {
        String res = "";
        while (!StringUtil.isEmpty((Object)parentId)) {
            res = res + parentId + ",";
            String ids = this.conceptDao.getChildGroupId(parentId);
            if (StringUtil.isEmpty((Object)ids)) {
                parentId = null;
                continue;
            }
            parentId = ids;
        }
        if (!StringUtil.isEmpty((Object)res)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    RelationVO getConceptNameById(RelationVO vo) {
        Concept targetConcept;
        Concept sourceConcept;
        if (StringUtil.isNotBlank((CharSequence)vo.getSourceNode()) && !StringUtil.isEmpty((Object)(sourceConcept = (Concept)this.conceptDao.selectById((Serializable)((Object)vo.getSourceNode()))))) {
            vo.setSourceNodeName(sourceConcept.getConceptName());
        }
        if (StringUtil.isNotBlank((CharSequence)vo.getTargetNode()) && !StringUtil.isEmpty((Object)(targetConcept = (Concept)this.conceptDao.selectById((Serializable)((Object)vo.getTargetNode()))))) {
            vo.setTargetNodeName(targetConcept.getConceptName());
        }
        return vo;
    }
}

