/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.kgbase.build.dao.PropertyDao;
import com.jxdinfo.hussar.kgbase.build.model.dto.PropertyDTO;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.model.po.Property;
import com.jxdinfo.hussar.kgbase.build.model.vo.PropertyVO;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.build.service.IPropertyService;
import com.jxdinfo.hussar.kgbase.common.util.ListUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PropertyServiceImpl
extends ServiceImpl<PropertyDao, Property>
implements IPropertyService {
    @Autowired
    private IConceptService iConceptService;
    @Resource
    private PropertyDao propertyDao;

    public List<PropertyVO> getParentList(String parentId) {
        Concept concept = (Concept)this.iConceptService.getById((Serializable)((Object)parentId));
        String parentTreeCode = concept.getTreeCode();
        List<String> list = Arrays.asList(parentTreeCode.split(","));
        List<Property> properties = this.propertyDao.getParentPropertyList(list);
        ArrayList<PropertyVO> propertyVOS = new ArrayList<PropertyVO>();
        ListUtil.copyList(properties, propertyVOS, PropertyVO.class);
        return propertyVOS;
    }

    public void addOrEdit(PropertyDTO propertyDTO) {
        Property property = new Property();
        BeanUtil.copyProperties((Object)propertyDTO, (Object)property);
        if (propertyDTO.getId() != null) {
            this.updateById(property);
            if ("1".equals(propertyDTO.getIfSync()) && "0".equals(propertyDTO.getIfInherit())) {
                UpdateWrapper propUpdateWrapper = new UpdateWrapper();
                if (propertyDTO.getPropName() != null) {
                    propUpdateWrapper.set((Object)"PROP_NAME", (Object)propertyDTO.getPropName());
                }
                if (propertyDTO.getPropDatatype() != null) {
                    propUpdateWrapper.set((Object)"PROP_DATATYPE", (Object)propertyDTO.getPropDatatype());
                }
                if (propertyDTO.getIfMulti() != null) {
                    propUpdateWrapper.set((Object)"IF_MULTI", (Object)propertyDTO.getIfMulti());
                }
                propUpdateWrapper.eq((Object)"IF_INHERIT", (Object)"1");
                propUpdateWrapper.eq((Object)"INHERITED_ID", (Object)propertyDTO.getId());
                this.update((Wrapper)propUpdateWrapper);
            }
        } else {
            if (property.getIfInherit() == null) {
                property.setIfInherit("0");
            }
            if (property.getIfMulti() == null) {
                property.setIfMulti("0");
            }
            property.setDelFlag("0");
            this.save(property);
            if ("1".equals(propertyDTO.getIfSync())) {
                String conceptId = propertyDTO.getConceptId();
                String treeCode = ((Concept)this.iConceptService.getById((Serializable)((Object)conceptId))).getTreeCode();
                StringBuilder sb = new StringBuilder();
                sb.append(treeCode);
                sb.append(",");
                treeCode = sb.toString();
                QueryWrapper conceptQueryWrapper = new QueryWrapper();
                conceptQueryWrapper.like((Object)"TREE_CODE", (Object)treeCode);
                conceptQueryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
                List concepts = this.iConceptService.list((Wrapper)conceptQueryWrapper);
                ArrayList<Property> propList = new ArrayList<Property>();
                for (Concept concept : concepts) {
                    Property prop = new Property();
                    BeanUtil.copyProperties((Object)propertyDTO, (Object)prop);
                    prop.setIfInherit("1");
                    prop.setInheritedId(property.getId());
                    prop.setConceptId(concept.getId());
                    prop.setDelFlag("0");
                    propList.add(prop);
                }
                if (propList.size() > 0) {
                    this.saveBatch(propList);
                }
            }
        }
    }

    public void delete(PropertyDTO propertyDTO) {
        this.removeById((Serializable)((Object)propertyDTO.getId()));
        if ("1".equals(propertyDTO.getIfSync())) {
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"IF_INHERIT", (Object)"1");
            delWrapper.eq((Object)"INHERITED_ID", (Object)propertyDTO.getId());
            this.remove((Wrapper)delWrapper);
        }
    }
}

