/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.kgbase.build.dao.GroupDao;
import com.jxdinfo.hussar.kgbase.build.model.dto.GroupDTO;
import com.jxdinfo.hussar.kgbase.build.model.dto.NodeDTO;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.model.po.Groups;
import com.jxdinfo.hussar.kgbase.build.model.po.Node;
import com.jxdinfo.hussar.kgbase.build.model.vo.ConceptVO;
import com.jxdinfo.hussar.kgbase.build.model.vo.GroupVO;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.build.service.IGroupService;
import com.jxdinfo.hussar.kgbase.build.service.INodeService;
import com.jxdinfo.hussar.kgbase.build.service.IPropertyService;
import com.jxdinfo.hussar.kgbase.common.util.GroupTreeUtil;
import com.jxdinfo.hussar.kgbase.common.util.ListUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupServiceImpl
extends ServiceImpl<GroupDao, Groups>
implements IGroupService {
    private static final Logger logger = LoggerFactory.getLogger(GroupServiceImpl.class);
    @Autowired
    private IConceptService iConceptService;
    @Autowired
    private IPropertyService iPropertyService;
    @Autowired
    private INodeService iNodeService;
    @Autowired
    private GroupDao groupDao;

    public void addGroup(GroupDTO groupDTO) {
        if (!StringUtil.isEmpty((Object)groupDTO)) {
            Groups groups = new Groups();
            BeanUtils.copyProperties((Object)groupDTO, (Object)groups);
            this.save(groups);
            String treeCode = "";
            if (groups.getParentId() != null) {
                String parentTreeCode = this.getById((Serializable)((Object)groupDTO.getParentId())) == null ? null : ((Groups)this.getById((Serializable)((Object)groupDTO.getParentId()))).getTreeCode();
                treeCode = parentTreeCode + "," + groups.getId();
            } else {
                treeCode = groups.getId();
            }
            groups.setTreeCode(treeCode);
            this.updateById(groups);
            this.queryByParam(new GroupDTO());
        }
    }

    public void editGroup(GroupDTO groupDTO) {
        QueryWrapper oldew = new QueryWrapper();
        oldew.eq((Object)"id", (Object)groupDTO.getId());
        Groups oldgroup = (Groups)this.getOne((Wrapper)oldew);
        Groups groups = new Groups();
        BeanUtils.copyProperties((Object)groupDTO, (Object)groups);
        if (StringUtil.isBlank((CharSequence)groups.getParentId()) || StringUtil.equals((CharSequence)"", (CharSequence)groups.getParentId())) {
            groups.setParentId(null);
        }
        this.updateById(groups);
        QueryWrapper ew = new QueryWrapper();
        ew.likeRight((Object)"tree_code", (Object)oldgroup.getTreeCode());
        ew.ne((Object)"id", (Object)oldgroup.getId());
        List groupsList = this.list((Wrapper)ew);
        for (Groups group : groupsList) {
            group.setGroupPath(group.getGroupPath().replace(oldgroup.getGroupPath(), groups.getGroupPath()));
            this.updateById(group);
        }
    }

    public void deleteGroup(GroupDTO groupDTO) {
        String groupId = groupDTO.getId();
        ArrayList<String> delGroupIdList = new ArrayList<String>();
        delGroupIdList.add(groupId);
        while (!StringUtil.isEmpty((Object)groupId)) {
            QueryWrapper ew = new QueryWrapper();
            Object[] ids = groupId.split(",");
            ew.in((Object)"PARENT_ID", ids);
            List groupsList = this.list((Wrapper)ew);
            groupId = "";
            for (Groups item : groupsList) {
                delGroupIdList.add(item.getId());
                groupId = groupId + item.getId() + ",";
            }
            if (StringUtil.isEmpty((Object)groupId)) continue;
            groupId = groupId.substring(0, groupId.length() - 1);
        }
        this.removeByIds(delGroupIdList);
        QueryWrapper conceptW = new QueryWrapper();
        conceptW.in((Object)"PARENT_ID", delGroupIdList);
        List conceptList = this.iConceptService.list((Wrapper)conceptW);
        for (Concept item : conceptList) {
            this.iConceptService.removeById((Serializable)((Object)item.getId()));
            NodeDTO nodeDTO = new NodeDTO();
            nodeDTO.setConceptId(item.getId());
            this.iNodeService.delete(nodeDTO);
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"CONCEPT_ID", (Object)item.getId());
            this.iPropertyService.remove((Wrapper)delWrapper);
        }
    }

    public Page<Groups> queryByParam(GroupDTO groupDTO) {
        Page page = new Page();
        if (groupDTO.getCurrent() == null) {
            groupDTO.setCurrent(Integer.valueOf(1));
        }
        if (groupDTO.getSize() == null) {
            groupDTO.setSize(Integer.valueOf(10));
        }
        page.setCurrent((long)groupDTO.getCurrent().intValue());
        page.setSize((long)groupDTO.getSize().intValue());
        QueryWrapper ew = new QueryWrapper();
        if (!StringUtil.isEmpty((Object)groupDTO.getGroupName())) {
            ew.like((Object)"GROUP_NAME", (Object)groupDTO.getGroupName());
        }
        page = (Page)this.page((IPage)page, (Wrapper)ew);
        return page;
    }

    public List<GroupVO> getTree() {
        List dataList = this.iConceptService.list();
        ArrayList voList = new ArrayList();
        ListUtil.copyList(dataList, voList, ConceptVO.class);
        List nodeList = this.iNodeService.list();
        for (ConceptVO conceptVO : voList) {
            for (Node node : nodeList) {
                if (!conceptVO.getId().equals(node.getConceptId())) continue;
                conceptVO.setNode(node);
            }
        }
        List groupsdataList = this.list();
        ArrayList<GroupVO> groupVoList = new ArrayList<GroupVO>();
        ListUtil.copyList(groupsdataList, groupVoList, GroupVO.class);
        for (GroupVO groupVO : groupVoList) {
            ArrayList<ConceptVO> temList = new ArrayList<ConceptVO>();
            for (ConceptVO conceptVO : voList) {
                if (!groupVO.getId().equals(conceptVO.getParentId())) continue;
                conceptVO.setConceptPath(groupVO.getGroupPath() + "/" + conceptVO.getConceptName());
                conceptVO.setConceptOrGroup("concept");
                temList.add(conceptVO);
            }
            groupVO.setConceptVoChildre(temList);
            groupVO.setConceptOrGroup("group");
        }
        GroupTreeUtil treeUtil = new GroupTreeUtil(groupVoList);
        return treeUtil.builTree();
    }

    public List<GroupVO> getChildGroup(String parentId) {
        return this.groupDao.getChildGroupRecursion(parentId);
    }

    public ApiResponse checkGroupUnique(String parentId, String groupName, String GroupId) {
        try {
            QueryWrapper groupsWrapper = new QueryWrapper();
            if (StringUtil.isNotBlank((CharSequence)parentId)) {
                ((QueryWrapper)((QueryWrapper)groupsWrapper.eq((Object)"PARENT_ID", (Object)parentId)).eq((Object)"GROUP_NAME", (Object)groupName)).ne((Object)"ID", (Object)GroupId);
            } else {
                ((QueryWrapper)groupsWrapper.eq((Object)"PARENT_ID", (Object)parentId)).eq((Object)"GROUP_NAME", (Object)groupName);
            }
            Groups groups = (Groups)this.getOne((Wrapper)groupsWrapper);
            if (groups != null) {
                return ApiResponse.success((Object)false, (String)"\u540c\u4e00\u6587\u4ef6\u5939\u4e0b\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            return ApiResponse.success((Object)true, (String)"\u540c\u4e00\u6587\u4ef6\u5939\u4e0b\u5206\u7ec4\u540d\u79f0\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u540c\u4e00\u6587\u4ef6\u5939\u4e0b\u5206\u7ec4\u540d\u79f0\u552f\u4e00\u6027\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public List<GroupVO> getGroupTree() {
        List groupsdataList = this.list();
        ArrayList<GroupVO> groupVoList = new ArrayList<GroupVO>();
        ListUtil.copyList(groupsdataList, groupVoList, GroupVO.class);
        GroupTreeUtil treeUtil = new GroupTreeUtil(groupVoList);
        return treeUtil.builTree();
    }
}

