/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.service.impl;

import cn.hutool.core.text.TextSimilarity;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.kgbase.build.dao.ConceptDao;
import com.jxdinfo.hussar.kgbase.build.dao.EntityAlignDao;
import com.jxdinfo.hussar.kgbase.build.model.dto.ConceptDTO;
import com.jxdinfo.hussar.kgbase.build.model.dto.NodeDTO;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.model.po.EntityAlign;
import com.jxdinfo.hussar.kgbase.build.model.po.Node;
import com.jxdinfo.hussar.kgbase.build.model.po.Property;
import com.jxdinfo.hussar.kgbase.build.model.po.Relation;
import com.jxdinfo.hussar.kgbase.build.model.vo.ConceptSimilarVO;
import com.jxdinfo.hussar.kgbase.build.model.vo.ConceptVO;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.build.service.INodeService;
import com.jxdinfo.hussar.kgbase.build.service.IPropertyService;
import com.jxdinfo.hussar.kgbase.build.service.IRelationService;
import com.jxdinfo.hussar.kgbase.common.util.ConceptTreeUtil;
import com.jxdinfo.hussar.kgbase.common.util.ListUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.core.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConceptServiceImpl
extends ServiceImpl<ConceptDao, Concept>
implements IConceptService {
    @Autowired
    private IPropertyService iPropertyService;
    @Autowired
    private INodeService iNodeService;
    @Autowired
    private IRelationService iRelationService;
    @Autowired
    private ConceptDao conceptDao;
    @Autowired
    private EntityAlignDao entityAlignDao;
    private static final Logger logger = LoggerFactory.getLogger(ConceptServiceImpl.class);

    public ConceptVO addConcept(ConceptDTO conceptDto) {
        if (StringUtil.isEmpty((Object)conceptDto.getLevel())) {
            conceptDto.setLevel(Integer.valueOf(0));
        }
        conceptDto.setDelFlag("0");
        Concept concept = new Concept();
        BeanUtils.copyProperties((Object)conceptDto, (Object)concept);
        this.save(concept);
        String treeCode = "";
        if (concept.getParentId() != null) {
            String parentTreeCode = this.getById((Serializable)((Object)conceptDto.getParentId())) == null ? null : ((Concept)this.getById((Serializable)((Object)conceptDto.getParentId()))).getTreeCode();
            treeCode = parentTreeCode + "," + concept.getId();
        } else {
            treeCode = concept.getId();
        }
        concept.setTreeCode(treeCode);
        this.updateById(concept);
        Node node = conceptDto.getNode();
        node.setId(concept.getId());
        node.setConceptId(concept.getId());
        node.setDelFlag("0");
        this.iNodeService.save((Object)node);
        List propertyList = conceptDto.getPropertyList();
        long i = 0L;
        for (Property property : propertyList) {
            if (property.getIfInherit() == null) {
                property.setIfInherit("0");
            }
            if (property.getIfMulti() == null) {
                property.setIfMulti("0");
            }
            property.setConceptId(concept.getId());
            property.setShowOrder(Long.valueOf(i));
            ++i;
            property.setDelFlag("0");
        }
        this.iPropertyService.saveBatch((Collection)propertyList);
        ConceptVO conceptVO = new ConceptVO();
        conceptVO.setNode(node);
        BeanUtils.copyProperties((Object)concept, (Object)conceptVO);
        conceptVO.setPropertyList(propertyList);
        return conceptVO;
    }

    public void editConcept(ConceptDTO conceptDto) {
        Concept concept = new Concept();
        BeanUtils.copyProperties((Object)conceptDto, (Object)concept);
        if (StringUtil.isBlank((CharSequence)concept.getParentId()) || StringUtil.equals((CharSequence)"", (CharSequence)concept.getParentId())) {
            concept.setParentId(null);
        }
        this.updateById(concept);
        Node node = conceptDto.getNode();
        if (node != null && StringUtils.isNotEmpty((CharSequence)node.getConceptId())) {
            this.iNodeService.updateById((Object)node);
        }
        QueryWrapper delWrapper = new QueryWrapper();
        delWrapper.eq((Object)"CONCEPT_ID", (Object)concept.getId());
        this.iPropertyService.remove((Wrapper)delWrapper);
        List propertyList = conceptDto.getPropertyList();
        long i = 0L;
        for (Property property : propertyList) {
            if (property.getIfInherit() == null) {
                property.setIfInherit("0");
            }
            if (property.getIfMulti() == null) {
                property.setIfMulti("0");
            }
            property.setInheritedId(null);
            property.setConceptId(concept.getId());
            property.setShowOrder(Long.valueOf(i));
            ++i;
            property.setDelFlag("0");
        }
        this.iPropertyService.saveOrUpdateBatch((Collection)propertyList);
    }

    public void deleteConcept(ConceptDTO conceptDto) {
        String conceptId = conceptDto.getId();
        this.removeById((Serializable)((Object)conceptId));
        NodeDTO nodeDTO = new NodeDTO();
        nodeDTO.setConceptId(conceptId);
        this.iNodeService.delete(nodeDTO);
        QueryWrapper delWrapper = new QueryWrapper();
        delWrapper.eq((Object)"CONCEPT_ID", (Object)conceptId);
        this.iPropertyService.remove((Wrapper)delWrapper);
    }

    public void deleteConceptByIds(String conceptIds) {
        if (StringUtil.isNotBlank((CharSequence)conceptIds)) {
            String[] ids;
            for (String conceptId : ids = conceptIds.split(",")) {
                this.removeById((Serializable)((Object)conceptId));
                NodeDTO nodeDTO = new NodeDTO();
                nodeDTO.setConceptId(conceptId);
                this.iNodeService.delete(nodeDTO);
                QueryWrapper delWrapper = new QueryWrapper();
                delWrapper.eq((Object)"CONCEPT_ID", (Object)conceptId);
                this.iPropertyService.remove((Wrapper)delWrapper);
            }
        }
    }

    public List<ConceptVO> getTree() {
        List dataList = this.list();
        ArrayList<ConceptVO> voList = new ArrayList<ConceptVO>();
        ListUtil.copyList(dataList, voList, ConceptVO.class);
        List nodeList = this.iNodeService.list();
        for (ConceptVO conceptVO : voList) {
            for (Node node : nodeList) {
                if (!conceptVO.getId().equals(node.getConceptId())) continue;
                conceptVO.setNode(node);
            }
        }
        ConceptTreeUtil treeUtil = new ConceptTreeUtil(voList);
        return treeUtil.builTree();
    }

    public ConceptVO getDetailsById(String conceptId) {
        Concept concept = (Concept)this.getById((Serializable)((Object)conceptId));
        ConceptVO conceptVO = new ConceptVO();
        if (concept != null) {
            BeanUtils.copyProperties((Object)concept, (Object)conceptVO);
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"CONCEPT_ID", (Object)conceptId);
            ew.orderByAsc((Object)"SHOW_ORDER");
            List propertyList = this.iPropertyService.list((Wrapper)ew);
            conceptVO.setPropertyList(propertyList);
            String groupPath = this.conceptDao.getGroupPath(concept.getParentId());
            groupPath = StringUtil.isEmpty((Object)groupPath) ? "" : groupPath;
            groupPath = groupPath + "/" + concept.getConceptName();
            conceptVO.setConceptPath(groupPath);
        }
        return conceptVO;
    }

    public Page<ConceptVO> queryList(ConceptDTO conceptDto) {
        String parentId;
        Page page = new Page();
        if (conceptDto.getCurrent() == null) {
            conceptDto.setCurrent(Integer.valueOf(1));
        }
        if (conceptDto.getSize() == null) {
            conceptDto.setSize(Integer.valueOf(10));
        }
        page.setCurrent((long)conceptDto.getCurrent().intValue());
        page.setSize((long)conceptDto.getSize().intValue());
        int startInd = (conceptDto.getCurrent() - 1) * conceptDto.getSize();
        int endInd = conceptDto.getCurrent() * conceptDto.getSize();
        String paramStr = StringUtil.isEmpty((Object)conceptDto.getConceptName()) ? "" : conceptDto.getConceptName();
        String string = parentId = StringUtil.isEmpty((Object)conceptDto.getParentId()) ? "" : conceptDto.getParentId();
        if (!StringUtil.isEmpty((Object)parentId)) {
            parentId = this.getChildren(parentId);
        }
        List<ConceptVO> conceptVOList = this.conceptDao.getParentPropertyList(parentId, paramStr);
        page.setTotal((long)conceptVOList.size());
        endInd = endInd > conceptVOList.size() ? conceptVOList.size() : endInd;
        ArrayList<ConceptVO> result = new ArrayList<ConceptVO>();
        for (int i = startInd; i < endInd; ++i) {
            result.add(conceptVOList.get(i));
        }
        page.setRecords(result);
        return page;
    }

    public String getChildren(String parentId) {
        String res = "";
        while (!StringUtil.isEmpty((Object)parentId)) {
            res = res + parentId + ",";
            String ids = this.conceptDao.getChildGroupId(parentId);
            if (StringUtil.isEmpty((Object)ids)) {
                parentId = null;
                continue;
            }
            parentId = ids;
        }
        if (!StringUtil.isEmpty((Object)res)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public String getGroupIds(String parentId) {
        String res = "";
        while (!StringUtil.isEmpty((Object)parentId)) {
            res = res + parentId + ",";
            String ids = this.conceptDao.getChildGroupId(parentId);
            if (StringUtil.isEmpty((Object)ids)) {
                parentId = null;
                continue;
            }
            parentId = ids;
        }
        if (!StringUtil.isEmpty((Object)res)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public List<String> getConceptByGroupId(String groupIds) {
        return this.conceptDao.getConceptByGroupId(groupIds);
    }

    public ApiResponse checkConceptUnique(String conceptOrLabelName, String nameOrLabel, String conceptId) {
        try {
            QueryWrapper conceptWrapper = new QueryWrapper();
            if (StringUtil.isNotBlank((CharSequence)conceptId)) {
                if ("name".equals(nameOrLabel)) {
                    ((QueryWrapper)((QueryWrapper)conceptWrapper.eq((Object)"CONCEPT_NAME", (Object)conceptOrLabelName)).ne((Object)"ID", (Object)conceptId)).eq((Object)"DEL_FLAG", (Object)"0");
                } else {
                    ((QueryWrapper)((QueryWrapper)conceptWrapper.eq((Object)"CONCEPT_LABEL", (Object)conceptOrLabelName)).ne((Object)"ID", (Object)conceptId)).eq((Object)"DEL_FLAG", (Object)"0");
                }
            } else if ("name".equals(nameOrLabel)) {
                ((QueryWrapper)conceptWrapper.eq((Object)"CONCEPT_NAME", (Object)conceptOrLabelName)).eq((Object)"DEL_FLAG", (Object)"0");
            } else {
                ((QueryWrapper)conceptWrapper.eq((Object)"CONCEPT_LABEL", (Object)conceptOrLabelName)).eq((Object)"DEL_FLAG", (Object)"0");
            }
            Concept concept = (Concept)this.getOne((Wrapper)conceptWrapper);
            if (concept != null) {
                return ApiResponse.success((Object)false, (String)"\u5b9e\u4f53\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            return ApiResponse.success((Object)true, (String)"\u5b9e\u4f53\u540d\u79f0\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5b9e\u4f53\u540d\u79f0\u552f\u4e00\u6027\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public List<ConceptSimilarVO> getOntologyFusionList() {
        List<ConceptVO> conceptVOList = this.conceptDao.getParentPropertyList(null, null);
        ArrayList<ConceptVO> compareConceptVOList = new ArrayList<ConceptVO>(conceptVOList);
        ArrayList<ConceptSimilarVO> res = new ArrayList<ConceptSimilarVO>();
        for (ConceptVO concept : conceptVOList) {
            compareConceptVOList.remove(concept);
            for (ConceptVO compareConcept : compareConceptVOList) {
                double similar = TextSimilarity.similar((String)concept.getConceptName(), (String)compareConcept.getConceptName());
                if (!(similar > 0.0)) continue;
                ConceptSimilarVO conceptSimilarVO = new ConceptSimilarVO();
                conceptSimilarVO.setAid(concept.getId());
                conceptSimilarVO.setAconceptName(concept.getConceptName());
                conceptSimilarVO.setAparentId(concept.getParentId());
                conceptSimilarVO.setAconceptPath(concept.getConceptPath());
                conceptSimilarVO.setBid(compareConcept.getId());
                conceptSimilarVO.setBconceptName(compareConcept.getConceptName());
                conceptSimilarVO.setBparentId(compareConcept.getParentId());
                conceptSimilarVO.setBconceptPath(compareConcept.getConceptPath());
                conceptSimilarVO.setState("\u672a\u5bf9\u9f50");
                conceptSimilarVO.setSource("\u6587\u672c\u76f8\u4f3c\u5ea6\u7b97\u6cd5");
                conceptSimilarVO.setSimilarScore(similar + "");
                res.add(conceptSimilarVO);
            }
        }
        Collections.sort(res, new Comparator<ConceptSimilarVO>(){

            @Override
            public int compare(ConceptSimilarVO o1, ConceptSimilarVO o2) {
                double similar2;
                double similar1 = Double.parseDouble(o1.getSimilarScore());
                if (similar1 < (similar2 = Double.parseDouble(o2.getSimilarScore()))) {
                    return -1;
                }
                return 1;
            }
        });
        return res;
    }

    public Map<String, Object> getAAndBInfo(String ids) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String[] idarr = ids.split(",");
        if (idarr.length == 2) {
            String aid = idarr[0];
            String bid = idarr[1];
            HashMap<String, Object> amap = new HashMap<String, Object>();
            Concept aconcept = (Concept)this.conceptDao.selectById((Serializable)((Object)aid));
            QueryWrapper aw = new QueryWrapper();
            aw.eq((Object)"CONCEPT_ID", (Object)aid);
            List apropertyList = this.iPropertyService.list((Wrapper)aw);
            List<Map<String, String>> aRelationList = this.conceptDao.getRelationByConceptId(aid);
            amap.put("concept", aconcept);
            amap.put("Property", apropertyList);
            amap.put("relation", aRelationList);
            Concept bconcept = (Concept)this.conceptDao.selectById((Serializable)((Object)bid));
            QueryWrapper bw = new QueryWrapper();
            bw.eq((Object)"CONCEPT_ID", (Object)bid);
            List bpropertyList = this.iPropertyService.list((Wrapper)bw);
            List<Map<String, String>> bRelationList = this.conceptDao.getRelationByConceptId(bid);
            HashMap<String, Object> bmap = new HashMap<String, Object>();
            bmap.put("concept", bconcept);
            bmap.put("Property", bpropertyList);
            bmap.put("relation", bRelationList);
            res.put(aid, amap);
            res.put(bid, bmap);
        }
        return res;
    }

    public ApiResponse addOntologyFusion(EntityAlign entityAlign) {
        if (entityAlign != null) {
            this.entityAlignDao.insert(entityAlign);
            Long entityAId = entityAlign.getEntityAId();
            Long entityBId = entityAlign.getEntityBId();
            QueryWrapper paqw = new QueryWrapper();
            paqw.eq((Object)"CONCEPT_ID", (Object)entityAId);
            paqw.eq((Object)"DEL_FLAG", (Object)"0");
            List propertyAList = this.iPropertyService.list((Wrapper)paqw);
            QueryWrapper pbqw = new QueryWrapper();
            pbqw.eq((Object)"CONCEPT_ID", (Object)entityBId);
            pbqw.eq((Object)"DEL_FLAG", (Object)"0");
            List propertyBList = this.iPropertyService.list((Wrapper)pbqw);
            String activeInstance = entityAlign.getEntityAlign();
            String attributesAlignRule = entityAlign.getAttributesAlignRule();
            String relationalAlignmentRule = entityAlign.getRelationalAlignmentRule();
            if ("A".equals(activeInstance)) {
                Concept conceptB = (Concept)this.conceptDao.selectById(entityAlign.getEntityBId());
                conceptB.setDelFlag("1");
                this.conceptDao.deleteById(conceptB);
                Node nodeB = (Node)this.iNodeService.getById((Serializable)entityAlign.getEntityBId());
                nodeB.setDelFlag("1");
                this.iNodeService.removeById((Object)nodeB);
                if ("0".equals(attributesAlignRule)) {
                    for (Object property : propertyBList) {
                        property.setConceptId(entityAId.toString());
                    }
                    this.iPropertyService.updateBatchById((Collection)propertyBList);
                } else if ("1".equals(attributesAlignRule)) {
                    ArrayList<Property> temList = new ArrayList<Property>();
                    for (Object property : propertyBList) {
                        if (this.JudgeContains(propertyAList, (Property)property)) continue;
                        property.setConceptId(entityAId.toString());
                        temList.add((Property)property);
                    }
                    this.iPropertyService.updateBatchById(temList);
                } else {
                    this.iPropertyService.remove((Wrapper)pbqw);
                }
                QueryWrapper RelationQueryWrapper = new QueryWrapper();
                RelationQueryWrapper.apply("SOURCE_NODE = " + entityBId + "  or TARGET_NODE = " + entityBId, new Object[0]);
                List relationList = this.iRelationService.list((Wrapper)RelationQueryWrapper);
                if ("0".equals(relationalAlignmentRule)) {
                    for (Relation relation : relationList) {
                        if (StringUtil.equals((CharSequence)entityBId.toString(), (CharSequence)relation.getTargetNode())) {
                            relation.setTargetNode(entityAId.toString());
                        }
                        if (StringUtil.equals((CharSequence)entityBId.toString(), (CharSequence)relation.getSourceNode())) {
                            relation.setSourceNode(entityAId.toString());
                        }
                        this.iRelationService.updateById((Object)relation);
                    }
                } else {
                    this.iRelationService.remove((Wrapper)RelationQueryWrapper);
                }
            } else {
                Concept conceptA = (Concept)this.conceptDao.selectById(entityAlign.getEntityAId());
                conceptA.setDelFlag("1");
                this.conceptDao.deleteById(conceptA);
                Node nodeA = (Node)this.iNodeService.getById((Serializable)entityAlign.getEntityAId());
                nodeA.setDelFlag("1");
                this.iNodeService.removeById((Object)nodeA);
                if ("0".equals(attributesAlignRule)) {
                    for (Object property : propertyAList) {
                        property.setConceptId(entityBId.toString());
                    }
                    this.iPropertyService.updateBatchById((Collection)propertyAList);
                } else if ("1".equals(attributesAlignRule)) {
                    ArrayList<Property> temList = new ArrayList<Property>();
                    for (Property property : propertyAList) {
                        if (this.JudgeContains(propertyBList, property)) continue;
                        property.setConceptId(entityBId.toString());
                        temList.add(property);
                    }
                    this.iPropertyService.updateBatchById(temList);
                } else {
                    this.iPropertyService.remove((Wrapper)paqw);
                }
                QueryWrapper RelationQueryWrapper = new QueryWrapper();
                RelationQueryWrapper.apply("SOURCE_NODE = " + entityAId + "  or TARGET_NODE = " + entityAId, new Object[0]);
                List relationList = this.iRelationService.list((Wrapper)RelationQueryWrapper);
                if ("0".equals(relationalAlignmentRule)) {
                    for (Relation relation : relationList) {
                        if (StringUtil.equals((CharSequence)entityAId.toString(), (CharSequence)relation.getTargetNode())) {
                            relation.setTargetNode(entityBId.toString());
                        }
                        if (StringUtil.equals((CharSequence)entityAId.toString(), (CharSequence)relation.getSourceNode())) {
                            relation.setSourceNode(entityBId.toString());
                        }
                        this.iRelationService.updateById((Object)relation);
                    }
                } else {
                    this.iRelationService.remove((Wrapper)RelationQueryWrapper);
                }
            }
        }
        return ApiResponse.success((String)"\u5b58\u50a8\u5bf9\u9f50\u6570\u636e\u6210\u529f\uff01");
    }

    private boolean JudgeContains(List<Property> plist, Property cpro) {
        boolean res = false;
        for (Property property : plist) {
            if (!StringUtil.equals((CharSequence)property.getDelFlag(), (CharSequence)cpro.getDelFlag()) || !StringUtil.equals((CharSequence)property.getPropName(), (CharSequence)cpro.getPropName()) || !StringUtil.equals((CharSequence)property.getPropDatatype(), (CharSequence)cpro.getPropDatatype()) || !StringUtil.equals((CharSequence)property.getIfMulti(), (CharSequence)cpro.getIfMulti())) continue;
            res = true;
        }
        return res;
    }
}

