/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.build.model.dto.GroupDTO;
import com.jxdinfo.hussar.kgbase.build.model.po.Groups;
import com.jxdinfo.hussar.kgbase.build.model.vo.GroupVO;
import com.jxdinfo.hussar.kgbase.build.service.IGroupService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/groups"})
public class GroupController
extends BaseController {
    @Autowired
    private IGroupService groupService;

    @AuditLog(moduleName="\u5206\u7ec4", eventDesc="\u65b0\u589e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/add"})
    public ApiResponse addGroup(@RequestBody GroupDTO groupDTO) {
        try {
            this.groupService.addGroup(groupDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @AuditLog(moduleName="\u5206\u7ec4", eventDesc="\u4fee\u6539", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/edit"})
    public ApiResponse editGroup(@RequestBody GroupDTO groupDTO) {
        try {
            this.groupService.editGroup(groupDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @AuditLog(moduleName="\u5206\u7ec4", eventDesc="\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @PostMapping(value={"/delete"})
    public ApiResponse deleteGroup(@RequestBody GroupDTO groupDTO) {
        try {
            this.groupService.deleteGroup(groupDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @AuditLog(moduleName="\u5206\u7ec4", eventDesc="\u67e5\u8be2\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/getList"})
    public ApiResponse<Page<Groups>> getTree(@RequestBody GroupDTO groupDTO) {
        try {
            return ApiResponse.success((Object)this.groupService.queryByParam(groupDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u5206\u7ec4", eventDesc="\u67e5\u8be2\u6811", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getTree"})
    public ApiResponse<List<GroupVO>> getTree() {
        try {
            return ApiResponse.success((Object)this.groupService.getTree());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u5206\u7ec4", eventDesc="\u6839\u636e\u7236\u7ea7ID\u67e5\u8be2\u5b50\u7ea7\u5206\u7ec4", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getChildGroup"})
    public ApiResponse<List<GroupVO>> getChildGroup(String parentId) {
        try {
            return ApiResponse.success((Object)this.groupService.getChildGroup(parentId));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u5206\u7ec4", eventDesc="\u6839\u636e\u540c\u4e00\u6587\u4ef6\u5939\u4e0b\u662f\u5426\u6709\u540c\u540d\u7684\u5206\u7ec4", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/checkGroupUnique"})
    public ApiResponse checkGroupUnique(String parentId, String groupName, String GroupId) {
        try {
            return ApiResponse.success((Object)this.groupService.checkGroupUnique(parentId, groupName, GroupId));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u5206\u7ec4", eventDesc="\u83b7\u53d6\u5168\u90e8\u5206\u7ec4\u6811", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getGroupTree"})
    public ApiResponse<List<GroupVO>> getGroupTree() {
        try {
            return ApiResponse.success((Object)this.groupService.getGroupTree());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

