/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.pathquery.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Joiner;
import com.jxdinfo.hussar.kgbase.application.pathquery.model.PathQueryDTO;
import com.jxdinfo.hussar.kgbase.application.pathquery.service.PathQueryService;
import com.jxdinfo.hussar.kgbase.common.constant.KgConstants;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.repository.PathQueryRepository;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.kgbase.neo4j.vo.Neo4jBasicSegmentsVO;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.ogm.response.model.NodeModel;
import org.springframework.stereotype.Service;

@Service
public class PathQueryServiceImpl
implements PathQueryService {
    @Resource
    private PathQueryRepository pathQueryRepository;

    public List<Neo4jBasicNode> getNodesByName(String name) {
        List<Neo4jBasicNode> returnList = new ArrayList<Neo4jBasicNode>();
        if (StringUtil.isEmpty((Object)name)) {
            return returnList;
        }
        List<Map<String, Object>> result = this.pathQueryRepository.getNodesByName(name);
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        for (Map<String, Object> map : result) {
            Object node = map.get("n");
            if (!(node instanceof NodeModel)) continue;
            nodes.add((NodeModel)node);
        }
        returnList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        return returnList;
    }

    public Page<Neo4jBasicSegmentsVO> getPathByNodes(PathQueryDTO dto) {
        Page page = new Page();
        page.setSize(5L);
        if (null != dto.getCurrentNum() && dto.getCurrentNum() > 0) {
            page.setCurrent((long)dto.getCurrentNum().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getDegree() == null) {
            dto.setDegree(Integer.valueOf(6));
        }
        ArrayList<Neo4jBasicSegmentsVO> returnList = new ArrayList<Neo4jBasicSegmentsVO>();
        List<Object> allPathResult = new ArrayList();
        if (dto.getRelations() == null || dto.getRelations().size() == 0) {
            allPathResult = this.pathQueryRepository.getPathByNodes(dto.getStart(), dto.getEnd(), dto.getDegree());
        } else {
            String relations = Joiner.on((String)"|").join((Iterable)dto.getRelations());
            allPathResult = this.pathQueryRepository.getPathByNodes(dto.getStart(), dto.getEnd(), relations, dto.getDegree());
        }
        if (allPathResult.size() == 0) {
            return page;
        }
        List<Object> limitPathResult = new ArrayList();
        if (null != dto.getCurrentNum() && dto.getCurrentNum() > 0) {
            Integer endIndex = dto.getCurrentNum() * KgConstants.page_size;
            limitPathResult = allPathResult.size() >= endIndex ? allPathResult.subList((dto.getCurrentNum() - 1) * 5, endIndex) : allPathResult.subList((dto.getCurrentNum() - 1) * 5, allPathResult.size());
        } else {
            limitPathResult = allPathResult.size() >= KgConstants.page_size ? allPathResult.subList(0, KgConstants.page_size) : allPathResult.subList(0, allPathResult.size());
        }
        for (Map map : limitPathResult) {
            Object paths = map.get("path");
            if (!(paths instanceof InternalPath.SelfContainedSegment[])) continue;
            returnList.add(Neo4jUtil.changeToNeo4jBasicRelationReturnVO((InternalPath.SelfContainedSegment[])paths));
        }
        page.setTotal((long)allPathResult.size());
        page.setRecords(returnList);
        return page;
    }

    public List<String> getRelationsByPath(PathQueryDTO dto) {
        if (dto.getDegree() == null) {
            dto.setDegree(Integer.valueOf(6));
        }
        ArrayList<String> relationships = new ArrayList<String>();
        List<Map<String, Object>> allRels = this.pathQueryRepository.getRelationsByPath(dto.getStart(), dto.getEnd(), dto.getDegree());
        for (Map<String, Object> relMap : allRels) {
            if (relMap.get("relation") == null) continue;
            relationships.add(String.valueOf(relMap.get("relation")));
        }
        return relationships;
    }
}

