/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.ksearch.service.impl;

import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.KSearchDTO;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.vo.KSearchVO;
import com.jxdinfo.hussar.kgbase.application.ksearch.service.KSearchService;
import com.jxdinfo.hussar.kgbase.common.constant.KgConstants;
import com.jxdinfo.hussar.kgbase.common.util.KeyWordUtil;
import com.jxdinfo.hussar.kgbase.common.util.PhoneNumberUtil;
import com.jxdinfo.hussar.kgbase.kbqa.model.WordParsePO;
import com.jxdinfo.hussar.kgbase.kbqa.model.vo.KbqaAnswerVO;
import com.jxdinfo.hussar.kgbase.kbqa.service.IKbqaService;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.repository.KSearchRepository;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.neo4j.ogm.response.model.NodeModel;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KSearchServiceImpl
implements KSearchService {
    @Resource
    private KSearchRepository kSearchRepository;
    @Resource
    private IKbqaService kbqaService;
    @Value(value="${private-protection}")
    private boolean privateProtectFlag;

    public Page<KSearchVO> queryByKeyWord(KSearchDTO kSearchDTO) {
        Integer count;
        List<HashMap<String, Object>> kSearch;
        ArrayList<KSearchVO> searchVOList = new ArrayList<KSearchVO>();
        Page page = new Page();
        if (kSearchDTO.getCurrent() == null) {
            kSearchDTO.setCurrent(Integer.valueOf(1));
        }
        if (kSearchDTO.getSize() == null) {
            kSearchDTO.setSize(Integer.valueOf(10));
        }
        if (StringUtil.isEmpty((Object)kSearchDTO.getKeyWord())) {
            return page;
        }
        page.setCurrent((long)kSearchDTO.getCurrent().intValue());
        page.setSize((long)kSearchDTO.getSize().intValue());
        Integer pageIndex = (kSearchDTO.getCurrent() - 1) * kSearchDTO.getSize();
        kSearchDTO.setCurrent(pageIndex);
        String conceptName = kSearchDTO.getConceptName();
        try {
            Object answerVO = null;
            if (answerVO != null && answerVO.getNodes() != null && answerVO.getNodes().size() > 0) {
                WordParsePO[] parsePOS = answerVO.getWordParsePOS();
                List nodes = answerVO.getNodes();
                if (!StringUtil.isEmpty((Object)conceptName)) {
                    for (int i = 0; i < nodes.size(); ++i) {
                        if (((Neo4jBasicNode)nodes.get(i)).getNodeType().equals(conceptName)) continue;
                        nodes.remove(i);
                        --i;
                    }
                }
                Integer count2 = nodes.size();
                nodes = nodes.subList(kSearchDTO.getCurrent(), kSearchDTO.getCurrent() + kSearchDTO.getSize() <= count2 ? kSearchDTO.getCurrent() + kSearchDTO.getSize() : count2);
                for (Neo4jBasicNode node : nodes) {
                    KSearchVO vo = new KSearchVO();
                    vo.setId(node.getId());
                    vo.setName(node.getLabel());
                    vo.setLabel(node.getNodeType());
                    ArrayList<String> contents = new ArrayList<String>();
                    for (Map propMap : node.getProperties()) {
                        for (String key : propMap.keySet()) {
                            if ("name".equals(key)) {
                                vo.setName(String.valueOf(propMap.get(key)));
                            }
                            List<String> defaultNodeProps = Arrays.asList(KgConstants.getDefaultNodeProps());
                            boolean flag = false;
                            for (String string : defaultNodeProps) {
                                if (!key.equals(string)) continue;
                                flag = true;
                                break;
                            }
                            if (flag || !(propMap.get(key) instanceof String)) continue;
                            if (this.privateProtectFlag) {
                                String propVal = String.valueOf(propMap.get(key));
                                if (IdcardUtil.isValidCard((String)propVal)) {
                                    propMap.put(key, propVal.replace(propVal.substring(6, 12), "******"));
                                } else if (PhoneNumberUtil.isPhone(propVal)) {
                                    propMap.put(key, propVal.replace(propVal.substring(4, 8), "****"));
                                }
                            }
                            HashSet<String> keywordsSet = new HashSet<String>();
                            for (WordParsePO wordParsePO : parsePOS) {
                                keywordsSet.add(wordParsePO.getContent());
                            }
                            KeyWordUtil keyWordUtil = new KeyWordUtil(keywordsSet);
                            String text = String.valueOf(propMap.get(key));
                            if (keyWordUtil.getWords(text).size() <= 1) continue;
                            contents.add(key + "\uff1a" + text);
                        }
                    }
                    vo.setContents(contents);
                    searchVOList.add(vo);
                }
                page.setTotal((long)count2.intValue());
                page.setRecords(searchVOList);
                return page;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] systemProps = KgConstants.getDefaultNodeProps();
        List<String> systemPropList = Arrays.asList(systemProps);
        systemPropList = new ArrayList<String>(systemPropList);
        for (int i = 0; i < systemPropList.size(); ++i) {
            if (!"name".equals(systemPropList.get(i))) continue;
            systemPropList.remove(i);
            --i;
        }
        try {
            if (StringUtil.isNotBlank((CharSequence)conceptName)) {
                kSearch = this.kSearchRepository.getKSearch(kSearchDTO.getKeyWord(), conceptName, systemPropList, "allFullIndex");
                count = kSearch.size();
            } else {
                kSearch = this.kSearchRepository.getKSearch(kSearchDTO.getKeyWord(), systemPropList, "allFullIndex");
                count = kSearch.size();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (StringUtil.isNotBlank((CharSequence)conceptName)) {
                kSearch = this.kSearchRepository.getKSearchWithoutIndex(kSearchDTO.getKeyWord(), conceptName, systemPropList);
                count = kSearch.size();
            }
            kSearch = this.kSearchRepository.getKSearchWithoutIndex(kSearchDTO.getKeyWord(), systemPropList);
            count = kSearch.size();
        }
        kSearch = kSearch.subList(kSearchDTO.getCurrent(), kSearchDTO.getCurrent() + kSearchDTO.getSize() <= count ? kSearchDTO.getCurrent() + kSearchDTO.getSize() : count);
        for (HashMap<String, Object> map : kSearch) {
            JSONObject data = (JSONObject)JSON.toJSON((Object)map.get("n"));
            KSearchVO kSearchVO = new KSearchVO();
            kSearchVO.setId(String.valueOf(data.get((Object)"id")));
            List labels = (List)data.get((Object)"labels");
            if (labels.size() > 0) {
                kSearchVO.setLabel((String)labels.get(0));
            }
            ArrayList<String> contents = new ArrayList<String>();
            List propertyList = (List)data.get((Object)"propertyList");
            for (Map propertyMap : propertyList) {
                String propValue;
                if (this.privateProtectFlag && propertyMap.get("value") instanceof String) {
                    String propVal = String.valueOf(propertyMap.get("value"));
                    if (IdcardUtil.isValidCard((String)propVal)) {
                        propertyMap.put("value", propVal.replace(propVal.substring(6, 12), "******"));
                    } else if (PhoneNumberUtil.isPhone(propVal)) {
                        propertyMap.put("value", propVal.replace(propVal.substring(4, 8), "****"));
                    }
                }
                if ("name".equals(String.valueOf(propertyMap.get("key")))) {
                    kSearchVO.setName(String.valueOf(propertyMap.get("value")));
                }
                boolean flag = false;
                List<String> defaultNodeProps = Arrays.asList(KgConstants.getDefaultNodeProps());
                for (String string : defaultNodeProps) {
                    if (!propertyMap.get("key").equals(string)) continue;
                    flag = true;
                    break;
                }
                if (flag || !(propertyMap.get("value") instanceof String) || !(propValue = String.valueOf(propertyMap.get("value"))).contains(kSearchDTO.getKeyWord())) continue;
                contents.add(propertyMap.get("key") + "\uff1a" + propValue);
            }
            kSearchVO.setContents(contents);
            searchVOList.add(kSearchVO);
        }
        page.setTotal((long)count.intValue());
        page.setRecords(searchVOList);
        return page;
    }

    public KSearchVO queryById(KSearchDTO kSearchDTO) {
        List<Map<String, Object>> list = this.kSearchRepository.getNodeById(kSearchDTO.getId());
        if (list.size() > 0) {
            Object res = list.get(0).get("n");
            ArrayList<NodeModel> nodeModels = new ArrayList<NodeModel>();
            nodeModels.add((NodeModel)res);
            List<Neo4jBasicNode> nodes = Neo4jUtil.changeToNeo4jBasicNode(nodeModels);
            Neo4jBasicNode node = nodes.get(0);
            KSearchVO vo = new KSearchVO();
            vo.setId(node.getId());
            vo.setLabel(node.getNodeType());
            HashMap properties = new HashMap();
            List propertyList = node.getProperties();
            for (Map tmp : propertyList) {
                if (this.privateProtectFlag) {
                    for (String key : tmp.keySet()) {
                        if (!(tmp.get(key) instanceof String)) continue;
                        String propVal = String.valueOf(tmp.get(key));
                        if (IdcardUtil.isValidCard((String)propVal)) {
                            tmp.put(key, propVal.replace(propVal.substring(6, 12), "******"));
                            continue;
                        }
                        if (!PhoneNumberUtil.isPhone(propVal)) continue;
                        tmp.put(key, propVal.replace(propVal.substring(3, 7), "****"));
                    }
                }
                properties.putAll(tmp);
            }
            vo.setProperties(properties);
            if (properties.get("name") != null) {
                vo.setName(String.valueOf(properties.get("name")));
            }
            List<String> defaultNodeProps = Arrays.asList(KgConstants.getDefaultNodeProps());
            for (String defaultNodeProp : defaultNodeProps) {
                properties.remove(defaultNodeProp);
            }
            return vo;
        }
        throw new HussarException("\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
    }

    public JSONObject queryConceptnameByKeyword(String keyword) {
        JSONObject conceptObj = new JSONObject();
        try {
            KbqaAnswerVO answerVO = (KbqaAnswerVO)this.kbqaService.getAnswer(keyword, Boolean.valueOf(false)).getData();
            HashSet<String> strSet = new HashSet<String>();
            if (answerVO != null && answerVO.getNodes() != null && answerVO.getNodes().size() > 0) {
                List nodes = answerVO.getNodes();
                for (Neo4jBasicNode node : nodes) {
                    strSet.add(node.getNodeType());
                }
                conceptObj.put("conceptList", strSet);
                return conceptObj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] systemProps = KgConstants.getDefaultNodeProps();
        List<String> systemPropList = Arrays.asList(systemProps);
        systemPropList = new ArrayList<String>(systemPropList);
        for (int i = 0; i < systemPropList.size(); ++i) {
            if (!"name".equals(systemPropList.get(i))) continue;
            systemPropList.remove(i);
            --i;
        }
        List<Object> conceptList = new ArrayList();
        try {
            conceptList = this.kSearchRepository.queryConceptnameByKeyword(keyword, systemPropList, "allFullIndex");
        }
        catch (Exception e) {
            e.printStackTrace();
            conceptList = this.kSearchRepository.queryConceptnameByKeywordWithoutIndex(keyword, systemPropList);
        }
        conceptObj.put("conceptList", conceptList);
        return conceptObj;
    }
}

