/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.ksearch.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.kgbase.application.ksearch.dao.KSearchRecordsDao;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.KSearchRecordsDTO;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.po.KSearchRecords;
import com.jxdinfo.hussar.kgbase.application.ksearch.service.KSearchRecordsService;
import java.util.Arrays;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Service;

@Service
public class KSearchRecordsServiceImpl
extends ServiceImpl<KSearchRecordsDao, KSearchRecords>
implements KSearchRecordsService {
    public Page<KSearchRecords> getSearchRecords(KSearchRecordsDTO kSearchRecordsDTO) {
        Page page = new Page();
        if (kSearchRecordsDTO.getCurrent() == null) {
            kSearchRecordsDTO.setCurrent(Integer.valueOf(1));
        }
        if (kSearchRecordsDTO.getSize() == null) {
            kSearchRecordsDTO.setSize(Integer.valueOf(5));
        }
        page.setCurrent((long)kSearchRecordsDTO.getCurrent().intValue());
        page.setSize((long)kSearchRecordsDTO.getSize().intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        if (BaseSecurityUtil.getUser() != null) {
            queryWrapper.eq((Object)"CREATOR", (Object)BaseSecurityUtil.getUser().getId());
        }
        if (kSearchRecordsDTO.getSearchType() != null) {
            queryWrapper.eq((Object)"SEARCH_TYPE", (Object)kSearchRecordsDTO.getSearchType());
        }
        queryWrapper.orderByDesc((Object)"LAST_TIME");
        page = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        return page;
    }

    public boolean addSearchRecord(KSearchRecordsDTO kSearchRecordsDTO) {
        try {
            String nodeId;
            Date date = new Date();
            Long userId = null;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
            if (BaseSecurityUtil.getUser() != null) {
                userId = BaseSecurityUtil.getUser().getId();
                queryWrapper.eq((Object)"CREATOR", (Object)userId);
            }
            if ("1".equals(kSearchRecordsDTO.getSearchType())) {
                nodeId = kSearchRecordsDTO.getFirstNodeId();
                queryWrapper.eq((Object)"SEARCH_TYPE", (Object)"1");
                queryWrapper.eq((Object)"FIRST_NODE_ID", (Object)nodeId);
                KSearchRecords oldRecord = (KSearchRecords)this.getOne((Wrapper)queryWrapper);
                if (oldRecord != null) {
                    oldRecord.setLastTime(date);
                    oldRecord.setSearchTimes(Integer.valueOf(oldRecord.getSearchTimes() + 1));
                    return this.updateById(oldRecord);
                }
            } else if ("2".equals(kSearchRecordsDTO.getSearchType())) {
                nodeId = kSearchRecordsDTO.getFirstNodeId();
                String secondNodeId = kSearchRecordsDTO.getSecondNodeId();
                queryWrapper.eq((Object)"SEARCH_TYPE", (Object)"2");
                queryWrapper.eq((Object)"FIRST_NODE_ID", (Object)nodeId);
                queryWrapper.eq((Object)"SECOND_NODE_ID", (Object)secondNodeId);
                KSearchRecords oldRecord = (KSearchRecords)this.getOne((Wrapper)queryWrapper);
                if (oldRecord != null) {
                    oldRecord.setLastTime(date);
                    oldRecord.setSearchTimes(Integer.valueOf(oldRecord.getSearchTimes() + 1));
                    return this.updateById(oldRecord);
                }
            }
            KSearchRecords kSearchRecord = new KSearchRecords();
            BeanUtils.copyProperties((Object)kSearchRecordsDTO, (Object)kSearchRecord);
            kSearchRecord.setCreator(userId);
            kSearchRecord.setCreateTime(date);
            kSearchRecord.setLastEditor(userId);
            kSearchRecord.setLastTime(date);
            kSearchRecord.setSearchTimes(Integer.valueOf(1));
            kSearchRecord.setDelFlag("0");
            return this.save(kSearchRecord);
        }
        catch (BeansException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteSearchRecords(String ids) {
        String[] idArr = ids.split(",");
        return this.removeByIds(Arrays.asList(idArr));
    }
}

