/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.kcalculate.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KCentralityDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KCommunityDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KLinkPredictDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KMiniNumDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KShortestPathDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KSimilarityDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.vo.KCentralityVO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.vo.KCommunityVO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.vo.KLinkPredictVO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.vo.KShortestPathVO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.vo.KSimilarityVO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.service.KCalculateService;
import com.jxdinfo.hussar.kgbase.neo4j.repository.GraphQueryRepository;
import com.jxdinfo.hussar.kgbase.neo4j.repository.KCalculateRepository;
import com.jxdinfo.hussar.kgbase.neo4j.repository.PathQueryRepository;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.kgbase.neo4j.vo.Neo4jBasicNodeVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KCalculateServiceImpl
implements KCalculateService {
    @Autowired
    private KCalculateRepository kCalculateRepository;
    @Resource
    GraphQueryRepository graphQueryRepository;
    @Resource
    PathQueryRepository pathQueryRepository;
    @Resource
    private Session session;

    public List<KShortestPathVO> shortestPath(KShortestPathDTO kShortestPathDTO) {
        if (kShortestPathDTO.getWeight() == null) {
            kShortestPathDTO.setWeight("null");
        } else {
            String weight = "'" + kShortestPathDTO.getWeight() + "'";
            kShortestPathDTO.setWeight(weight);
        }
        String cypherSQL = "MATCH (source:`" + kShortestPathDTO.getSource().getNodeType() + "` {name:'" + kShortestPathDTO.getSource().getName() + "'}),  (destination:`" + kShortestPathDTO.getDestination().getNodeType() + "` {name:'" + kShortestPathDTO.getDestination().getName() + "'}) CALL algo.shortestPath.stream(source, destination," + kShortestPathDTO.getWeight() + ") YIELD nodeId, cost RETURN id(algo.getNodeById(nodeId)) as id,algo.getNodeById(nodeId).name as name,cost";
        Result query = this.session.query(cypherSQL, new HashMap());
        Iterable idMaps = (Iterable)query.queryResults();
        ArrayList<KShortestPathVO> kShortestPathVOS = new ArrayList<KShortestPathVO>();
        for (Map map : idMaps) {
            KShortestPathVO shortestPathVO = new KShortestPathVO(String.valueOf(map.get("id")), String.valueOf(map.get("name")), String.valueOf(map.get("cost")));
            kShortestPathVOS.add(shortestPathVO);
        }
        return kShortestPathVOS;
    }

    public void minimum(KMiniNumDTO kMiniNumDTO) {
        String clearCQL = "MATCH p=()-[r:MINST]->() delete r";
        this.session.query(clearCQL, new HashMap());
        String buildCQL = "MATCH (n:`" + kMiniNumDTO.getNode().getNodeType() + "` {name:'" + kMiniNumDTO.getNode().getName() + "'}) CALL algo.spanningTree.minimum('" + kMiniNumDTO.getNode().getNodeType() + "', '" + kMiniNumDTO.getRelationShip() + "', '" + kMiniNumDTO.getRelProperty() + "', id(n),  {write:true, writeProperty:'MINST'}) YIELD loadMillis, computeMillis, writeMillis, effectiveNodeCount RETURN loadMillis, computeMillis, writeMillis, effectiveNodeCount";
        this.session.query(buildCQL, new HashMap());
        String queryCQL = "MATCH path = (n:`" + kMiniNumDTO.getNode().getNodeType() + "` {name:'" + kMiniNumDTO.getNode().getName() + "'})-[:MINST*]-() WITH relationships(path) AS rels UNWIND rels AS rel WITH DISTINCT rel AS rel RETURN startNode(rel).id AS source, endNode(rel).id AS destination,rel.distance AS cost";
        Result dataQuery = this.session.query(queryCQL, new HashMap());
        String graphCQL = "MATCH path = (n:`" + kMiniNumDTO.getNode().getNodeType() + "` {name:'" + kMiniNumDTO.getNode().getName() + "'})-[:MINST*]-() return path";
        Result graphQuery = this.session.query(graphCQL, new HashMap());
    }

    public KCentralityVO degree(KCentralityDTO kCentralityDTO) {
        kCentralityDTO.setOrderType(kCentralityDTO.getOrderType() == null ? "desc" : kCentralityDTO.getOrderType());
        kCentralityDTO.setLimit(Integer.valueOf(kCentralityDTO.getLimit() == null ? 10 : kCentralityDTO.getLimit()));
        kCentralityDTO.setRelationDirection(kCentralityDTO.getRelationDirection() == null ? "both" : kCentralityDTO.getRelationDirection());
        StringBuffer queryCQL = new StringBuffer();
        String nodeType = kCentralityDTO.getNode() == null || kCentralityDTO.getNode().getNodeType() == null ? "null" : "'" + kCentralityDTO.getNode().getNodeType() + "'";
        String relationShip = kCentralityDTO.getRelationShip() == null ? "null" : "'" + kCentralityDTO.getRelationShip() + "'";
        queryCQL.append("call algo.degree.stream(null,").append(relationShip).append(",{direction:'").append(kCentralityDTO.getRelationDirection()).append("'");
        if (kCentralityDTO.getWeightProperty() != null) {
            queryCQL.append(",weightproperty:'").append(kCentralityDTO.getWeightProperty()).append("'");
        }
        queryCQL.append(" }) yield nodeId,score ");
        if (kCentralityDTO.getNode() != null && kCentralityDTO.getNode().getNodeType() != null) {
            queryCQL.append(" WHERE labels(algo.getNodeById(nodeId))[0] = ").append(nodeType);
        }
        queryCQL.append(" return algo.getNodeById(nodeId) as n,nodeId as id,algo.getNodeById(nodeId).name as name,score ORDER BY score ");
        queryCQL.append(kCentralityDTO.getOrderType());
        queryCQL.append(" LIMIT ").append(kCentralityDTO.getLimit());
        System.out.println(queryCQL.toString());
        Result calculateRes = this.session.query(queryCQL.toString(), new HashMap());
        KCentralityVO vo = new KCentralityVO();
        vo.setResult(calculateRes);
        HashMap<String, String> scoreMap = new HashMap<String, String>();
        for (Map map : (Iterable)calculateRes.queryResults()) {
            NodeModel node = (NodeModel)map.get("n");
            String score = String.valueOf(map.get("score"));
            scoreMap.put(String.valueOf(node.getId()), score);
        }
        ArrayList mapList = Lists.newArrayList((Iterable)((Iterable)calculateRes.queryResults()));
        JSONObject jo = Neo4jUtil.generateQueryResult(mapList);
        List nodeVOS = (List)jo.get((Object)"nodes");
        for (Neo4jBasicNodeVO nodeVO : nodeVOS) {
            nodeVO.setScore((String)scoreMap.get(nodeVO.getId()));
        }
        jo.put("nodes", (Object)nodeVOS);
        vo.setGraphData(jo);
        return vo;
    }

    public KCentralityVO betweenness(KCentralityDTO kCentralityDTO) {
        kCentralityDTO.setOrderType(kCentralityDTO.getOrderType() == null ? "desc" : kCentralityDTO.getOrderType());
        kCentralityDTO.setLimit(Integer.valueOf(kCentralityDTO.getLimit() == null ? 10 : kCentralityDTO.getLimit()));
        kCentralityDTO.setRelationDirection(kCentralityDTO.getRelationDirection() == null ? "both" : kCentralityDTO.getRelationDirection());
        StringBuffer queryCQL = new StringBuffer();
        String nodeType = kCentralityDTO.getNode() == null || kCentralityDTO.getNode().getNodeType() == null ? "null" : "'" + kCentralityDTO.getNode().getNodeType() + "'";
        String relationShip = kCentralityDTO.getRelationShip() == null ? "null" : "'" + kCentralityDTO.getRelationShip() + "'";
        queryCQL.append("call algo.closeness.stream(null,").append(relationShip).append(",{direction:'").append(kCentralityDTO.getRelationDirection()).append("'");
        queryCQL.append(" }) yield nodeId,centrality ");
        if (kCentralityDTO.getNode() != null && kCentralityDTO.getNode().getNodeType() != null) {
            queryCQL.append(" WHERE labels(algo.getNodeById(nodeId))[0] = ").append(nodeType);
        }
        queryCQL.append(" return algo.getNodeById(nodeId) as n,nodeId as id,algo.getNodeById(nodeId).name as name,centrality as score ORDER BY score ");
        queryCQL.append(kCentralityDTO.getOrderType());
        queryCQL.append(" LIMIT ").append(kCentralityDTO.getLimit());
        Result calculateRes = this.session.query(queryCQL.toString(), new HashMap());
        KCentralityVO vo = new KCentralityVO();
        vo.setResult(calculateRes);
        HashMap<String, String> scoreMap = new HashMap<String, String>();
        for (Map map : (Iterable)calculateRes.queryResults()) {
            NodeModel node = (NodeModel)map.get("n");
            String score = String.valueOf(map.get("score"));
            scoreMap.put(String.valueOf(node.getId()), score);
        }
        ArrayList mapList = Lists.newArrayList((Iterable)((Iterable)calculateRes.queryResults()));
        JSONObject jo = Neo4jUtil.generateQueryResult(mapList);
        List nodeVOS = (List)jo.get((Object)"nodes");
        for (Neo4jBasicNodeVO nodeVO : nodeVOS) {
            nodeVO.setScore((String)scoreMap.get(nodeVO.getId()));
        }
        jo.put("nodes", (Object)nodeVOS);
        vo.setGraphData(jo);
        return vo;
    }

    public KCentralityVO pageRank(KCentralityDTO kCentralityDTO) {
        kCentralityDTO.setOrderType(kCentralityDTO.getOrderType() == null ? "desc" : kCentralityDTO.getOrderType());
        kCentralityDTO.setLimit(Integer.valueOf(kCentralityDTO.getLimit() == null ? 10 : kCentralityDTO.getLimit()));
        kCentralityDTO.setRelationDirection(kCentralityDTO.getRelationDirection() == null ? "both" : kCentralityDTO.getRelationDirection());
        kCentralityDTO.setIterations(Integer.valueOf(kCentralityDTO.getIterations() == null ? 20 : kCentralityDTO.getIterations()));
        kCentralityDTO.setDampingFactor(Double.valueOf(kCentralityDTO.getDampingFactor() == null ? 0.85 : kCentralityDTO.getDampingFactor()));
        StringBuffer queryCQL = new StringBuffer();
        String nodeType = kCentralityDTO.getNode() == null || kCentralityDTO.getNode().getNodeType() == null ? "null" : "'" + kCentralityDTO.getNode().getNodeType() + "'";
        String relationShip = kCentralityDTO.getRelationShip() == null ? "null" : "'" + kCentralityDTO.getRelationShip() + "'";
        queryCQL.append("call algo.pageRank.stream(").append(nodeType).append(",").append(relationShip);
        queryCQL.append(",{direction:'").append(kCentralityDTO.getRelationDirection()).append("',iterations:").append(kCentralityDTO.getIterations()).append(", dampingFactor:").append(kCentralityDTO.getDampingFactor());
        queryCQL.append(" }) yield nodeId,score ");
        if (kCentralityDTO.getNode() != null && kCentralityDTO.getNode().getNodeType() != null) {
            queryCQL.append(" WHERE labels(algo.getNodeById(nodeId))[0] = ").append(nodeType);
        }
        queryCQL.append(" return algo.getNodeById(nodeId) as n,nodeId as id,algo.getNodeById(nodeId).name as name,score ORDER BY score ");
        queryCQL.append(kCentralityDTO.getOrderType());
        queryCQL.append(" LIMIT ").append(kCentralityDTO.getLimit());
        Result calculateRes = this.session.query(queryCQL.toString(), new HashMap());
        KCentralityVO vo = new KCentralityVO();
        vo.setResult(calculateRes);
        HashMap<String, String> scoreMap = new HashMap<String, String>();
        for (Map map : (Iterable)calculateRes.queryResults()) {
            NodeModel node = (NodeModel)map.get("n");
            String score = String.valueOf(map.get("score"));
            scoreMap.put(String.valueOf(node.getId()), score);
        }
        ArrayList mapList = Lists.newArrayList((Iterable)((Iterable)calculateRes.queryResults()));
        JSONObject jo = Neo4jUtil.generateQueryResult(mapList);
        List nodeVOS = (List)jo.get((Object)"nodes");
        for (Neo4jBasicNodeVO nodeVO : nodeVOS) {
            nodeVO.setScore((String)scoreMap.get(nodeVO.getId()));
        }
        jo.put("nodes", (Object)nodeVOS);
        vo.setGraphData(jo);
        return vo;
    }

    public KCommunityVO louvain(KCommunityDTO kCommunityDTO) {
        kCommunityDTO.setOrderType(kCommunityDTO.getOrderType() == null ? "desc" : kCommunityDTO.getOrderType());
        kCommunityDTO.setLimit(Integer.valueOf(kCommunityDTO.getLimit() == null ? 10 : kCommunityDTO.getLimit()));
        kCommunityDTO.setRelationDirection(kCommunityDTO.getRelationDirection() == null ? "both" : kCommunityDTO.getRelationDirection());
        kCommunityDTO.setIterations(Integer.valueOf(kCommunityDTO.getIterations() == null ? 20 : kCommunityDTO.getIterations()));
        StringBuffer queryCQL = new StringBuffer();
        String nodeType = kCommunityDTO.getNode() == null || kCommunityDTO.getNode().getNodeType() == null ? "null" : "'" + kCommunityDTO.getNode().getNodeType() + "'";
        String relationShip = kCommunityDTO.getRelationShip() == null ? "null" : "'" + kCommunityDTO.getRelationShip() + "'";
        queryCQL.append("call algo.louvain.stream(").append(nodeType).append(",").append(relationShip).append(",{direction:'").append(kCommunityDTO.getRelationDirection()).append("'").append(",innerIterations:").append(kCommunityDTO.getIterations()).append(",includeIntermediateCommunities:true");
        if (kCommunityDTO.getCommunityProperty() != null) {
            queryCQL.append(",communityProperty:'").append(kCommunityDTO.getCommunityProperty()).append("'");
        }
        if (kCommunityDTO.getWeightProperty() != null) {
            queryCQL.append(",weightProperty:'").append(kCommunityDTO.getWeightProperty()).append("', defaultValue:1.0");
        }
        queryCQL.append(" }) yield nodeId,communities,community ");
        queryCQL.append("WHERE apoc.node.degree(algo.getNodeById(nodeId)) > 0 ");
        queryCQL.append("return algo.getNodeById(nodeId) as n,nodeId as id,algo.getNodeById(nodeId).name as name,communities,community ORDER BY community ");
        queryCQL.append(kCommunityDTO.getOrderType());
        queryCQL.append(" LIMIT ").append(kCommunityDTO.getLimit());
        Result calculateRes = this.session.query(queryCQL.toString(), new HashMap());
        KCommunityVO vo = new KCommunityVO();
        vo.setResult(calculateRes);
        HashMap<String, String> nodeClusterMap = new HashMap<String, String>();
        HashMap clustersMap = new HashMap();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (Map map : (Iterable)calculateRes.queryResults()) {
            Object tempList;
            idList.add(Integer.parseInt(String.valueOf(map.get("id"))));
            nodeClusterMap.put(String.valueOf(map.get("id")), String.valueOf(map.get("community")));
            String community = String.valueOf(map.get("community"));
            if (clustersMap.get(community) == null) {
                tempList = new ArrayList<Map>();
                tempList.add(map);
                clustersMap.put(community, tempList);
                continue;
            }
            tempList = (List)clustersMap.get(community);
            tempList.add(map);
            clustersMap.put(community, tempList);
        }
        List<Map<String, Object>> graphData = this.graphQueryRepository.getUnlimitedNodesAndRelationshipsWithId2(idList.toArray(new Integer[]{idList.size()}));
        List<Map<String, Object>> nodeData = this.graphQueryRepository.getSingleNodesWithId(idList.toArray(new Integer[]{idList.size()}));
        graphData.addAll(nodeData);
        vo.setGraphData(Neo4jUtil.generateQueryResult(graphData));
        List nodeList = (List)vo.getGraphData().get((Object)"nodes");
        for (Neo4jBasicNodeVO node : nodeList) {
            if (nodeClusterMap.get(node.getId()) == null) continue;
            node.setComboId((String)nodeClusterMap.get(node.getId()));
            node.setCluster(node.getNodeType());
            node.setClusterId((String)nodeClusterMap.get(node.getId()));
            node.setComboId((String)nodeClusterMap.get(node.getId()) + "_combos");
        }
        vo.getGraphData().put("nodes", (Object)nodeList);
        ArrayList combosList = new ArrayList();
        ArrayList tableData = new ArrayList();
        for (Map.Entry entry : clustersMap.entrySet()) {
            HashMap<String, String> comboMap = new HashMap<String, String>();
            comboMap.put("id", (String)entry.getKey() + "_combos");
            combosList.add(comboMap);
            HashMap<String, Object> tableDataMap = new HashMap<String, Object>();
            tableDataMap.put("comboId", entry.getKey());
            tableDataMap.put("list", entry.getValue());
            tableData.add(tableDataMap);
        }
        vo.getGraphData().put("combos", combosList);
        vo.setTableData(tableData);
        return vo;
    }

    public KCommunityVO labelPropagation(KCommunityDTO kCommunityDTO) {
        kCommunityDTO.setOrderType(kCommunityDTO.getOrderType() == null ? "desc" : kCommunityDTO.getOrderType());
        kCommunityDTO.setLimit(Integer.valueOf(kCommunityDTO.getLimit() == null ? 10 : kCommunityDTO.getLimit()));
        kCommunityDTO.setRelationDirection(kCommunityDTO.getRelationDirection() == null ? "both" : kCommunityDTO.getRelationDirection());
        kCommunityDTO.setIterations(Integer.valueOf(kCommunityDTO.getIterations() == null ? 20 : kCommunityDTO.getIterations()));
        StringBuffer queryCQL = new StringBuffer();
        String nodeType = kCommunityDTO.getNode() == null || kCommunityDTO.getNode().getNodeType() == null ? "null" : "'" + kCommunityDTO.getNode().getNodeType() + "'";
        String relationShip = kCommunityDTO.getRelationShip() == null ? "null" : "'" + kCommunityDTO.getRelationShip() + "'";
        queryCQL.append("call algo.labelPropagation.stream(").append(nodeType).append(",").append(relationShip).append(",{direction:'").append(kCommunityDTO.getRelationDirection()).append("'").append(",iterations:").append(kCommunityDTO.getIterations());
        queryCQL.append(" }) yield nodeId,label ");
        queryCQL.append("WHERE apoc.node.degree(algo.getNodeById(nodeId)) > 0 ");
        queryCQL.append("return algo.getNodeById(nodeId) as n,nodeId as id,algo.getNodeById(nodeId).name as name,label ORDER BY label ");
        queryCQL.append(kCommunityDTO.getOrderType());
        queryCQL.append(" LIMIT ").append(kCommunityDTO.getLimit());
        Result calculateRes = this.session.query(queryCQL.toString(), new HashMap());
        KCommunityVO vo = new KCommunityVO();
        vo.setResult(calculateRes);
        HashMap<String, String> nodeClusterMap = new HashMap<String, String>();
        HashMap clustersMap = new HashMap();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (Map map : (Iterable)calculateRes.queryResults()) {
            Object tempList;
            idList.add(Integer.parseInt(String.valueOf(map.get("id"))));
            nodeClusterMap.put(String.valueOf(map.get("id")), String.valueOf(map.get("label")));
            String label = String.valueOf(map.get("label"));
            if (clustersMap.get(label) == null) {
                tempList = new ArrayList<Map>();
                tempList.add(map);
                clustersMap.put(label, tempList);
                continue;
            }
            tempList = (List)clustersMap.get(label);
            tempList.add(map);
            clustersMap.put(label, tempList);
        }
        List<Map<String, Object>> graphData = this.graphQueryRepository.getUnlimitedNodesAndRelationshipsWithId2(idList.toArray(new Integer[]{idList.size()}));
        List<Map<String, Object>> nodeData = this.graphQueryRepository.getSingleNodesWithId(idList.toArray(new Integer[]{idList.size()}));
        graphData.addAll(nodeData);
        vo.setGraphData(Neo4jUtil.generateQueryResult(graphData));
        List nodeList = (List)vo.getGraphData().get((Object)"nodes");
        for (Neo4jBasicNodeVO node : nodeList) {
            if (nodeClusterMap.get(node.getId()) == null) continue;
            node.setComboId((String)nodeClusterMap.get(node.getId()));
            node.setCluster(node.getNodeType());
            node.setClusterId((String)nodeClusterMap.get(node.getId()));
            node.setComboId((String)nodeClusterMap.get(node.getId()) + "_combos");
        }
        vo.getGraphData().put("nodes", (Object)nodeList);
        ArrayList combosList = new ArrayList();
        ArrayList tableData = new ArrayList();
        for (Map.Entry entry : clustersMap.entrySet()) {
            HashMap<String, String> comboMap = new HashMap<String, String>();
            comboMap.put("id", (String)entry.getKey() + "_combos");
            combosList.add(comboMap);
            HashMap<String, Object> tableDataMap = new HashMap<String, Object>();
            tableDataMap.put("comboId", entry.getKey());
            tableDataMap.put("list", entry.getValue());
            tableData.add(tableDataMap);
        }
        vo.getGraphData().put("combos", combosList);
        vo.setTableData(tableData);
        return vo;
    }

    public KSimilarityVO jaccard(KSimilarityDTO kSimilarityDTO) {
        kSimilarityDTO.setOrderType(kSimilarityDTO.getOrderType() == null ? "desc" : kSimilarityDTO.getOrderType());
        kSimilarityDTO.setLimit(Integer.valueOf(kSimilarityDTO.getLimit() == null ? 10 : kSimilarityDTO.getLimit()));
        kSimilarityDTO.setThreshold(Double.valueOf(kSimilarityDTO.getThreshold() == null ? 0.0 : kSimilarityDTO.getThreshold()));
        StringBuffer queryCQL = new StringBuffer();
        Long id = kSimilarityDTO.getNode().getId();
        String relationCondition = "";
        if (kSimilarityDTO.getRelationShip() != null) {
            relationCondition = " :'" + relationCondition + "' ";
        }
        queryCQL.append("MATCH (n1)-[r").append(relationCondition).append("]-(cuisine1) where id(n1)= ").append(id).append(" and id(cuisine1)<> ").append(id).append(" ").append("WITH n1, collect(id(cuisine1)) AS n1Cuisine ");
        if (kSimilarityDTO.getNode().getNodeType() != null) {
            queryCQL.append("MATCH (n2:`").append(kSimilarityDTO.getNode().getNodeType()).append("`)-[r2").append(relationCondition).append("]-(cuisine2) where id(n2)<> ").append(id).append(" and id(cuisine2)<> ").append(id).append(" ");
        } else {
            queryCQL.append("MATCH (n2)-[r2").append(relationCondition).append("]-(cuisine2) where id(n2)<> ").append(id).append(" and id(cuisine2)<> ").append(id).append(" ");
        }
        queryCQL.append("WITH n1, n1Cuisine, n2, collect(id(cuisine2)) AS n2Cuisine ").append("WHERE algo.similarity.jaccard(n1Cuisine, n2Cuisine) > ").append(kSimilarityDTO.getThreshold()).append(" RETURN id(n2) as id,n2 as n,n2.name as name,algo.similarity.jaccard(n1Cuisine, n2Cuisine) AS score ").append("ORDER BY score ").append(kSimilarityDTO.getOrderType()).append(" LIMIT ").append(kSimilarityDTO.getLimit());
        Result calculateRes = this.session.query(queryCQL.toString(), new HashMap());
        KSimilarityVO vo = new KSimilarityVO();
        vo.setResult(calculateRes);
        vo.setGraphData(Neo4jUtil.generateQueryResult(calculateRes));
        return vo;
    }

    public KSimilarityVO overlap(KSimilarityDTO kSimilarityDTO) {
        kSimilarityDTO.setOrderType(kSimilarityDTO.getOrderType() == null ? "desc" : kSimilarityDTO.getOrderType());
        kSimilarityDTO.setLimit(Integer.valueOf(kSimilarityDTO.getLimit() == null ? 10 : kSimilarityDTO.getLimit()));
        kSimilarityDTO.setThreshold(Double.valueOf(kSimilarityDTO.getThreshold() == null ? 0.0 : kSimilarityDTO.getThreshold()));
        StringBuffer queryCQL = new StringBuffer();
        Long id = kSimilarityDTO.getNode().getId();
        queryCQL.append("MATCH (p1) -[r]- (p01) WHERE id(p1) = ").append(id);
        queryCQL.append(" WITH p1, collect(id(p01)) AS p1s ");
        if (kSimilarityDTO.getNode().getNodeType() != null) {
            queryCQL.append(" MATCH (p2:`").append(kSimilarityDTO.getNode().getNodeType()).append("`) -[r]- (p02) WHERE p1 <> p2 ");
        } else {
            queryCQL.append(" MATCH (p2) -[r]- (p02) WHERE p1 <> p2 ");
        }
        queryCQL.append(" WITH p1, p1s, p2, collect(id(p02)) AS p2s ");
        queryCQL.append(" WHERE algo.similarity.overlap(p1s, p2s) > ").append(kSimilarityDTO.getThreshold());
        queryCQL.append(" RETURN id(p2) as id,p2 as n,p2.name as name,algo.similarity.overlap(p1s, p2s) AS score ");
        queryCQL.append("ORDER BY score ").append(kSimilarityDTO.getOrderType()).append(" LIMIT ").append(kSimilarityDTO.getLimit());
        Result calculateRes = this.session.query(queryCQL.toString(), new HashMap());
        KSimilarityVO vo = new KSimilarityVO();
        vo.setResult(calculateRes);
        vo.setGraphData(Neo4jUtil.generateQueryResult(calculateRes));
        return vo;
    }

    public KLinkPredictVO linkPredict(KLinkPredictDTO kLinkPredictDTO, String algorithm) {
        kLinkPredictDTO.setOrderType(kLinkPredictDTO.getOrderType() == null ? "desc" : kLinkPredictDTO.getOrderType());
        kLinkPredictDTO.setLimit(Integer.valueOf(kLinkPredictDTO.getLimit() == null ? 10 : kLinkPredictDTO.getLimit()));
        kLinkPredictDTO.setRelationDirection(kLinkPredictDTO.getRelationDirection() == null ? "both" : kLinkPredictDTO.getRelationDirection());
        StringBuffer queryCQL = new StringBuffer();
        String relationShip = kLinkPredictDTO.getRelationShip() == null ? "null" : "'" + kLinkPredictDTO.getRelationShip() + "'";
        queryCQL.append("MATCH (n1) WHERE id(n1) = ").append(kLinkPredictDTO.getNode().getId());
        if (kLinkPredictDTO.getNode().getNodeType() != null) {
            queryCQL.append(" MATCH (n2:`").append(kLinkPredictDTO.getNode().getNodeType()).append("`) WHERE n1<>n2 and apoc.node.degree(n2) > 0 ");
        } else {
            queryCQL.append(" MATCH (n2) WHERE n1<>n2 and apoc.node.degree(n2) > 0");
        }
        queryCQL.append(" AND algo.linkprediction.").append(algorithm).append(" (n1, n2,{relationshipQuery:").append(relationShip).append(",direction:'").append(kLinkPredictDTO.getRelationDirection()).append("'}) > 0 ");
        queryCQL.append(" RETURN id(n1) as source,id(n2) as target,n2 as n,n2.name as name,algo.linkprediction.").append(algorithm).append(" (n1, n2,{relationshipQuery:").append(relationShip).append(",direction:'").append(kLinkPredictDTO.getRelationDirection()).append("'}) AS score ");
        queryCQL.append(" ORDER BY score ").append(kLinkPredictDTO.getOrderType());
        queryCQL.append(" LIMIT ").append(kLinkPredictDTO.getLimit());
        Result calculateRes = this.session.query(queryCQL.toString(), new HashMap());
        KLinkPredictVO vo = new KLinkPredictVO();
        vo.setResult(calculateRes);
        ArrayList<Integer> idList = new ArrayList<Integer>();
        idList.add(kLinkPredictDTO.getNode().getId().intValue());
        ArrayList predictLinks = new ArrayList();
        for (Map map : calculateRes) {
            idList.add(Integer.parseInt(String.valueOf(map.get("target"))));
            HashMap<String, String> pLinkMap = new HashMap<String, String>();
            pLinkMap.put("id", IdUtil.fastSimpleUUID());
            pLinkMap.put("source", String.valueOf(map.get("source")));
            pLinkMap.put("target", String.valueOf(map.get("target")));
            pLinkMap.put("score", (String)map.get("score"));
            predictLinks.add(pLinkMap);
        }
        List<Map<String, Object>> graphData = this.graphQueryRepository.getUnlimitedNodesAndRelationshipsWithId(idList.toArray(new Integer[]{idList.size()}));
        vo.setGraphData(Neo4jUtil.generateQueryResult(graphData));
        vo.setPredictEdge(predictLinks);
        return vo;
    }
}

